/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

import com.ibm.debug.pdt.internal.core.engine.EngineIdentifier;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.util.ILicenseCheckHandler;
import com.ibm.debug.pdt.internal.core.util.ILicenseCheckHandlerExtension;
import com.ibm.debug.pdt.internal.core.util.ILicenseCheckHandlerProductIDExtension;
import com.ibm.debug.pdt.internal.core.util.ILicenseCheckHandlerWithModeExtension;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class PDTLicenseCheck {
    static Map<EngineIdentifier, ILicenseCheckHandler> fLicenseHandlers = new HashMap<EngineIdentifier, ILicenseCheckHandler>();

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.licensecheckhandler");
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IConfigurationElement[] children;
                    Object handler = element.createExecutableExtension("class");
                    IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement engineElement = iConfigurationElementArray2[n4];
                        short type = Short.parseShort(engineElement.getAttribute("type"));
                        short os = Short.parseShort(engineElement.getAttribute("os"));
                        short hardware = Short.parseShort(engineElement.getAttribute("hw"));
                        EngineIdentifier engine = new EngineIdentifier(type, os, hardware);
                        fLicenseHandlers.put(engine, (ILicenseCheckHandler)handler);
                        ++n4;
                    }
                }
                catch (NumberFormatException nfe) {
                    PDTCoreUtils.logError(nfe);
                }
                catch (CoreException e) {
                    PDTCoreUtils.logError((Exception)((Object)e));
                }
                catch (ClassCastException e) {
                    PDTCoreUtils.logError(e);
                }
                ++n2;
            }
        }
    }

    public static boolean isLicenceAvailable(DebugEngine engine, String mode) {
        EngineIdentifier engineId = new EngineIdentifier(engine);
        return PDTLicenseCheck.isLicenceAvailable(engineId, false, null, mode);
    }

    public static boolean isLicenceAvailable(short engineType, short platformOS, short platformHW, String product, String mode) {
        return PDTLicenseCheck.isLicenceAvailable(engineType, platformOS, platformHW, false, product, mode);
    }

    public static boolean isLicenceAvailable(short engineType, short platformOS, short platformHW, boolean quiet, String product, String mode) {
        EngineIdentifier engineId = new EngineIdentifier(engineType, platformOS, platformHW);
        return PDTLicenseCheck.isLicenceAvailable(engineId, quiet, product, mode);
    }

    private static boolean isLicenceAvailable(EngineIdentifier engineId, boolean quiet, String product, String mode) {
        boolean result = false;
        for (Map.Entry<EngineIdentifier, ILicenseCheckHandler> entry : fLicenseHandlers.entrySet()) {
            if (entry.getKey().equals(engineId) && PDTLicenseCheck.isMatchingProduct(entry.getValue(), product)) {
                result = entry.getValue() instanceof ILicenseCheckHandlerWithModeExtension ? (result |= ((ILicenseCheckHandlerWithModeExtension)entry.getValue()).isLicenseValid(quiet, mode)) : (result |= entry.getValue() instanceof ILicenseCheckHandlerExtension ? ((ILicenseCheckHandlerExtension)entry.getValue()).isLicenseValid(quiet) : entry.getValue().isLicenseValid());
            }
            if (result) break;
        }
        return result;
    }

    private static boolean isMatchingProduct(ILicenseCheckHandler value, String product) {
        return product == null || !(value instanceof ILicenseCheckHandlerProductIDExtension) || product.equals(((ILicenseCheckHandlerProductIDExtension)value).getProductID());
    }

    public static boolean supportsClientLicenseCheck() {
        return fLicenseHandlers.size() > 0;
    }
}

