/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

import com.ibm.debug.pdt.core.ISourceBreakpointAdapter;
import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceEntryBreakpoint;
import com.ibm.debug.pdt.core.saverestore.ISaveRestore;
import com.ibm.debug.pdt.core.sourcelocator.IRemoteEnginePathContainer;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggerPersistentProfile;
import com.ibm.debug.pdt.internal.core.model.Line;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.DebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.util.DebuggerProfileNameUtil;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public final class PDTCoreUtils {
    public static final Pattern ADDRESS_REGEX = Pattern.compile("(0[xX])?[0-9a-fA-F]+");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";

    public static String getNullFreeDisplayString(String value) {
        if (PDTCoreUtils.isEmpty(value)) {
            return "";
        }
        return value.replace('\u0000', '\u0001');
    }

    public static final boolean isEmpty(String checkMe) {
        return checkMe == null || checkMe.length() == 0;
    }

    public static final String getValidFileName(String proposedName) {
        if (PDTCoreUtils.isEmpty(proposedName)) {
            return "";
        }
        return DebuggerProfileNameUtil.escapeFileName(proposedName);
    }

    public static final String getValidFileNameOldEscape(String proposedName) {
        if (PDTCoreUtils.isEmpty(proposedName)) {
            return "";
        }
        return proposedName.replaceAll("[:\\\\/*?|<>]", "_");
    }

    public static long getAddress(String addrStr) throws NumberFormatException {
        try {
            return Long.parseLong(addrStr, 16);
        }
        catch (NumberFormatException nfe) {
            return Long.decode(addrStr);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getLineBreakFreeString(String str) {
        block2: {
            curStr = null;
            toReplace = new String[]{"\n", System.getProperty("line.separator")};
            prefix = null;
            postfix = null;
            index = -1;
            if (str == null) break block2;
            curStr = str;
            i = 0;
            ** GOTO lbl16
            {
                prefix = curStr.substring(0, index);
                postfix = curStr.substring(index + 1, curStr.length());
                curStr = prefix + " " + postfix;
                do {
                    if ((index = curStr.indexOf(toReplace[i])) != -1) continue block0;
                    ++i;
lbl16:
                    // 2 sources

                } while (i < toReplace.length);
            }
        }
        return curStr;
    }

    public static final void logError(Exception e) {
        PDTCoreUtils.logString(null, e.getMessage() != null ? e.getMessage() : e.toString(), 4, e);
    }

    public static final synchronized void logString(Object originator, String text, int severity) {
        PDTCoreUtils.logString(originator, text, severity, null);
    }

    public static final synchronized void logString(Object originator, String text, int severity, Exception e) {
        StringBuffer buffer = new StringBuffer(PDTCoreUtils.getTiming());
        buffer.append(" [" + Thread.currentThread().getName() + "]");
        if (originator != null) {
            buffer.append(PDTCoreUtils.getBaseName(originator));
        }
        buffer.append(" ");
        buffer.append(text);
        Status sts = new Status(severity, "com.ibm.debug.pdt.core", 0, buffer.toString(), (Throwable)e);
        try {
            PDTCorePlugin.getInstance().getLog().log((IStatus)sts);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static final synchronized void logString(Object originator, String text) {
        PDTCoreUtils.logString(originator, text, 1);
    }

    public static final void logEvent(String text, Object originator) {
        String msgText = "EVENT(" + PDTCoreUtils.getBaseName(originator) + " <" + originator.hashCode() + ">)-> " + text;
        if (PDTCorePlugin.fLogEventStack) {
            PDTCoreUtils.logString(null, msgText, 1, new Exception(msgText));
        } else {
            PDTCoreUtils.logString(null, msgText);
        }
    }

    public static final String getBaseName(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        String qualifiedClassName = obj.getClass().getName();
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static final String getModelIdentifier() {
        return "com.ibm.debug.pdt";
    }

    public static final void resetTiming() {
        PDTCorePlugin.fElapsedTime = System.currentTimeMillis();
    }

    public static final String getTiming() {
        if (PDTCorePlugin.fTiming) {
            long currTime = System.currentTimeMillis();
            Object msg = String.valueOf(currTime - PDTCorePlugin.fElapsedTime);
            switch (((String)msg).length()) {
                case 1: {
                    msg = "    " + (String)msg;
                    break;
                }
                case 2: {
                    msg = "   " + (String)msg;
                    break;
                }
                case 3: {
                    msg = "  " + (String)msg;
                    break;
                }
                case 4: {
                    msg = " " + (String)msg;
                    break;
                }
            }
            msg = "[" + (String)msg + "ms] ";
            PDTCorePlugin.fElapsedTime = currTime;
            return msg;
        }
        return "";
    }

    public static String getProfileSaveRestoreLocation() {
        IPath path = PDTCoreUtils.getProfileSaveRestorePath();
        File saveDir = path.toFile();
        if (saveDir.exists() || !saveDir.mkdir()) {
            // empty if block
        }
        String saveRestorePath = path.toOSString();
        return saveRestorePath;
    }

    public static IPath getProfileSaveRestorePath() {
        IPath path = PDTCorePlugin.getInstance().getStateLocation();
        path = path.append("profiles");
        return path;
    }

    public static String getRestoreErrorMsg(ISaveRestore objToRestore, boolean directMethod, Throwable ex) {
        String objClassName = objToRestore.getClass().getSimpleName();
        String fileName = objToRestore.getFileName();
        String restoreMethod = directMethod ? "direct" : "migration";
        String errorMsg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
        return String.format(" Cannot restore %s from %s (%s method) [%s]", objClassName, fileName, restoreMethod, errorMsg);
    }

    public static String getSaveErrorMsg(ISaveRestore objToSave, Exception ex) {
        String objClassName = objToSave.getClass().getSimpleName();
        String fileName = objToSave.getFileName();
        String errorMsg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
        return String.format(" Cannot save %s to %s [%s]", objClassName, fileName, errorMsg);
    }

    public static String getStatementNumberFromLine(ViewFile viewFile, int lineNumber) {
        if (lineNumber < 0) {
            return null;
        }
        Line line = viewFile.getLine(lineNumber);
        String stmtPrefix = line.getPrefix(viewFile.getPrefixLength());
        return stmtPrefix;
    }

    public static IRemoteEnginePathContainer getDebugEnginePathContainer(ISourceLookupDirector director) {
        if (director == null) {
            return null;
        }
        ISourceContainer[] containers = director.getSourceContainers();
        if (containers == null) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            if (containers[i] instanceof IRemoteEnginePathContainer) {
                return (IRemoteEnginePathContainer)containers[i];
            }
            ++i;
        }
        return null;
    }

    public static void mkDir(IFolder folder) throws CoreException {
        if (folder == null || folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent.getType() == 2) {
            PDTCoreUtils.mkDir((IFolder)parent);
        }
        folder.create(true, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSourceLineBreakpoint(IBreakpoint bp) {
        try {
            if (bp instanceof GenericLineBreakpoint) {
                return true;
            }
            IConfigurationElement[] sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
            if (sourceBPAdapters == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= sourceBPAdapters.length) {
                    return false;
                }
                Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                if (adapterClass instanceof ISourceBreakpointAdapter && ((ISourceBreakpointAdapter)adapterClass).isSourceLineBreakpoint(bp)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSourceEntryBreakpoint(IBreakpoint bp) {
        return bp instanceof PICLSourceEntryBreakpoint;
    }

    public static void deleteDebuggerPersistentProfiles() {
        DebuggerPersistentProfile.getDefaultDeleter().deleteAllSavedDebuggerProfiles();
        DebuggerProfileMigrator.deleteAllOldSavedDebuggerProfiles();
    }

    public static void deleteFiles(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                PDTCoreUtils.deleteFiles(file);
            }
            if (!file.delete()) {
                // empty if block
            }
            ++n2;
        }
    }

    public static void setMarkerLineNumber(final IMarker marker, final int lineNumber) throws CoreException {
        if (marker.getAttribute("lineNumber", -1) == lineNumber) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                marker.setAttribute("lineNumber", lineNumber);
            }
        }, (ISchedulingRule)marker.getResource(), 1, null);
    }

    public static boolean isAddress(String input) {
        Matcher m = ADDRESS_REGEX.matcher(input);
        return m.matches();
    }

    public static Map<String, String> getEventAttributes(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute("com.ibm.debug.pdt.event_attributes", Collections.EMPTY_MAP);
    }

    public static void setEventAttributes(ILaunchConfiguration launchConfig, Map<String, String> attributes, boolean saveIntoConfig) throws CoreException {
        ILaunchConfigurationWorkingCopy lcwc = null;
        lcwc = launchConfig instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)launchConfig : launchConfig.getWorkingCopy();
        lcwc.setAttribute("com.ibm.debug.pdt.event_attributes", attributes);
        if (saveIntoConfig) {
            lcwc.doSave();
        }
    }

    public static IFolder getViewFileCache(String Id) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject viewFileProject = workspaceRoot.getProject("DebugViewFiles");
        if (viewFileProject == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.core", PICLMessages.PICLDebugTarget_TempDirectoryNotFound));
        }
        if (!viewFileProject.exists()) {
            viewFileProject.create((IProgressMonitor)new NullProgressMonitor());
        }
        viewFileProject.open((IProgressMonitor)new NullProgressMonitor());
        viewFileProject.setHidden(true);
        IPath path = viewFileProject.getProjectRelativePath();
        if (Id != null) {
            path = path.append(Id);
        }
        IFolder folder = viewFileProject.getFolder(path);
        PDTCoreUtils.mkDir(folder);
        return folder;
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
            return null;
        }
    }
}

