/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

public class EntryListItem
implements Comparable<EntryListItem> {
    private String fFullName;
    private String fFunctionName;
    private String fClassName;
    private String fFileName;
    private String fDemangledName;
    private String[] fFileList;
    private int fEntryId;
    private int fHasDebug;

    public EntryListItem(String waitForEngineMsg) {
        this.fFullName = waitForEngineMsg;
        this.fFunctionName = waitForEngineMsg;
        this.fClassName = "";
        this.fDemangledName = "";
    }

    public EntryListItem(String demangledname, String basename, String filename, int entryId, int hasDebug) {
        this.fEntryId = entryId;
        this.fHasDebug = hasDebug;
        this.fDemangledName = demangledname;
        this.parseFunction(demangledname, basename);
        this.parseFileName(filename);
    }

    public String getLabel() {
        return this.fFullName;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getFullName() {
        return this.fFullName;
    }

    public String getFunctionFileName() {
        return this.fFileName;
    }

    public String getOriginalName() {
        return this.fDemangledName;
    }

    @Override
    public int compareTo(EntryListItem o) {
        return this.fFullName.compareTo(o.getFullName());
    }

    public void parseFunction(String demangledName, String basename) {
        int baseIndex = -1;
        if (basename != null) {
            baseIndex = demangledName.lastIndexOf(basename);
        }
        int len = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (baseIndex > 2) {
                if (demangledName.substring(baseIndex - 2, baseIndex).equals("::")) {
                    len = basename.length();
                    if (demangledName.length() >= baseIndex + len && demangledName.substring(baseIndex + len, baseIndex + len + 1).equals("(")) {
                        tryAgain = false;
                    }
                }
                if (!tryAgain) continue;
                baseIndex = demangledName.lastIndexOf(basename, baseIndex - 1);
                continue;
            }
            tryAgain = false;
        }
        if (baseIndex < 0) {
            this.fFunctionName = demangledName;
            this.fClassName = "";
            this.fFullName = demangledName;
        } else {
            this.fFunctionName = demangledName.substring(baseIndex);
            this.fClassName = demangledName.substring(0, baseIndex);
            if (this.fClassName != null && this.fClassName.endsWith("::")) {
                this.fClassName = this.fClassName.substring(0, this.fClassName.length() - 2);
            }
            this.fFullName = this.fClassName != null && this.fClassName.length() > 0 ? this.fFunctionName + " --- " + this.fClassName : this.fFunctionName;
        }
    }

    protected void parseFileName(String filename) {
        if (filename == null || filename.length() == 0) {
            this.fFileName = "";
            this.fFileList = new String[1];
            this.fFileList[0] = "";
            return;
        }
        this.fFileList = new String[1];
        this.fFileList[0] = filename;
    }

    public String[] getFileList() {
        return this.fFileList;
    }

    public int getEntryId() {
        return this.fEntryId;
    }

    public int hasDebug() {
        return this.fHasDebug;
    }
}

