/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

import com.ibm.debug.pdt.internal.core.IDebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class DebuggerProfileMigrator {
    private Class<?> fDebugModelObject;
    private IDebuggerProfileMigrator fDebuggerProfileMigrator;
    private int fOldVersion;
    private static boolean fRetrievedMigrators;
    private static DebuggerProfileMigrator[] fMigrators;

    static {
        fMigrators = new DebuggerProfileMigrator[0];
    }

    private static DebuggerProfileMigrator[] getDebuggerProfileMigrators() {
        if (!fRetrievedMigrators) {
            fRetrievedMigrators = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.debuggerprofilemigrator");
            if (ep != null) {
                IConfigurationElement[] elements = ep.getConfigurationElements();
                ArrayList<DebuggerProfileMigrator> migrations = new ArrayList<DebuggerProfileMigrator>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        DebuggerProfileMigrator migrator = new DebuggerProfileMigrator();
                        migrator.fDebugModelObject = Class.forName(element.getAttribute("debugModelObject"));
                        migrator.fDebuggerProfileMigrator = (IDebuggerProfileMigrator)element.createExecutableExtension("debuggerProfileMigrator");
                        String version = element.getAttribute("version");
                        migrator.fOldVersion = Integer.parseInt(version);
                        migrations.add(migrator);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++n2;
                }
                fMigrators = migrations.toArray(new DebuggerProfileMigrator[migrations.size()]);
            }
        }
        return fMigrators;
    }

    public static boolean restoreUsingOldProfile(DebugModelObject profiled, int profileVersion, String profileName, int restoreFlags) {
        DebuggerProfileMigrator[] migrators;
        DebuggerProfileMigrator[] debuggerProfileMigratorArray = migrators = DebuggerProfileMigrator.getDebuggerProfileMigrators();
        int n = migrators.length;
        int n2 = 0;
        while (n2 < n) {
            DebuggerProfileMigrator migrator = debuggerProfileMigratorArray[n2];
            if (migrator.canMigrate(profileVersion, profiled)) {
                try {
                    return migrator.getDebuggerProfileMigrator().restoreFromOldProfile(profiled, profileName, restoreFlags);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return false;
    }

    public static void deleteAllOldSavedDebuggerProfiles() {
        DebuggerProfileMigrator[] migrators;
        DebuggerProfileMigrator[] debuggerProfileMigratorArray = migrators = DebuggerProfileMigrator.getDebuggerProfileMigrators();
        int n = migrators.length;
        int n2 = 0;
        while (n2 < n) {
            DebuggerProfileMigrator migrator = debuggerProfileMigratorArray[n2];
            migrator.getDebuggerProfileMigrator().deleteAllSavedDebuggerProfiles();
            ++n2;
        }
    }

    public final Class<?> getDebugModelObject() {
        return this.fDebugModelObject;
    }

    public final IDebuggerProfileMigrator getDebuggerProfileMigrator() {
        return this.fDebuggerProfileMigrator;
    }

    public final int getOldVersion() {
        return this.fOldVersion;
    }

    public final boolean canMigrate(int version, DebugModelObject restoreTo) {
        return this.fOldVersion == version && this.fDebugModelObject.isInstance(restoreTo);
    }
}

