/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

import com.ibm.debug.pdt.internal.core.util.ArgumentTokenizer;
import com.ibm.debug.pdt.internal.core.util.DebuggerOptionDescriptor;
import com.ibm.debug.pdt.internal.core.util.QuoteUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebuggerOptions {
    private String _debuggeeName = "";
    private String _debuggeeArgs = "";
    protected boolean _acceptUnknownOptions = false;
    private Hashtable<String, String> _options = new Hashtable();
    private static String _nameSep = "--";
    private ArrayList<DebuggerOptionDescriptor> _optionDescriptors = null;
    private Vector<String> _invalidOptions = new Vector();

    public DebuggerOptions() {
    }

    public DebuggerOptions(String[] args) {
        this.rebuild(args);
    }

    public DebuggerOptions(DebuggerOptions source) {
        this._debuggeeName = source._debuggeeName;
        this._debuggeeArgs = source._debuggeeArgs;
        Enumeration<String> keys = source._options.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = source._options.get(key);
            this._options.put(key, value);
        }
    }

    public String debuggeeArgs() {
        return this._debuggeeArgs;
    }

    public String debuggeeName() {
        return this._debuggeeName;
    }

    public String flatten() {
        StringBuilder flattened = new StringBuilder();
        Enumeration<String> e = this._options.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(_nameSep)) continue;
            String value = this._options.get(key);
            if (value.length() != 0) {
                flattened.append(" ").append(QuoteUtil.enquote(key + "=" + value));
                continue;
            }
            flattened.append(" ").append(QuoteUtil.enquote(key));
        }
        if (this._debuggeeName.length() != 0) {
            flattened.append(" ").append(_nameSep).append(" ").append(QuoteUtil.enquote(this._debuggeeName));
            if (this._debuggeeArgs.length() != 0) {
                flattened.append(" ").append(QuoteUtil.enquote(this._debuggeeArgs));
            }
        }
        return flattened.toString();
    }

    public String[] invalidOptions() {
        Object[] invalid = new String[this._invalidOptions.size()];
        this._invalidOptions.copyInto(invalid);
        return invalid;
    }

    public void rebuildFromResponseFile(String responseFile, boolean add) {
        StringBuilder optionStrings = new StringBuilder();
        BufferedReader breader = null;
        try {
            try {
                FileReader input = new FileReader(responseFile);
                breader = new BufferedReader(input);
                while (breader.ready()) {
                    String line = breader.readLine();
                    if (line == null || line.length() == 0) continue;
                    optionStrings.append(" ").append(QuoteUtil.enquoteIfNecessary(line));
                }
            }
            catch (FileNotFoundException fnfEx) {
                this.rebuild(new String[0], add);
                try {
                    if (breader != null) {
                        breader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException ioEx) {
                this.rebuild(new String[0], add);
                try {
                    if (breader != null) {
                        breader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
            }
            catch (IOException iOException) {}
        }
        String[] array = this.makeOptionArray(optionStrings.toString());
        this.rebuild(array, add);
    }

    public static DebuggerOptions recover(String optionStrings) {
        DebuggerOptions opt = new DebuggerOptions();
        opt.rebuild(optionStrings);
        return opt;
    }

    public String valueByName(String name) {
        return this._options.get(name);
    }

    protected void addOptionDescriptor(DebuggerOptionDescriptor descriptor) {
        if (this._optionDescriptors == null) {
            this._optionDescriptors = new ArrayList();
        }
        this._optionDescriptors.add(descriptor);
    }

    protected void clearOptionDescriptors() {
        this._optionDescriptors = null;
    }

    protected void rebuild(String optionStrings) {
        String[] array = this.makeOptionArray(optionStrings);
        this.rebuild(array, false);
    }

    protected String[] makeOptionArray(String optionStrings) {
        String option;
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(optionStrings);
        Vector<String> options = new Vector<String>();
        boolean nextOptionDebuggeeName = false;
        while ((option = tokenizer.nextToken()).length() != 0) {
            if (!nextOptionDebuggeeName) {
                nextOptionDebuggeeName = '-' != this.rationalizeOption(option).charAt(0);
            }
            options.addElement(option);
            if (nextOptionDebuggeeName) {
                options.addElement(QuoteUtil.unquote(tokenizer.remainderOfString()));
                break;
            }
            nextOptionDebuggeeName = option.equals(_nameSep);
        }
        Object[] optionArray = new String[options.size()];
        options.copyInto(optionArray);
        return optionArray;
    }

    protected void rebuild(String[] args) {
        this.rebuild(args, false);
    }

    protected void rebuild(String[] args, boolean add) {
        if (!add) {
            this._invalidOptions.removeAllElements();
            this._options.clear();
            this._debuggeeName = "";
            this._debuggeeArgs = "";
        }
        boolean nextIsDebuggee = false;
        boolean twoOrMoreDebuggeeArgs = false;
        int argIndex = 0;
        while (argIndex < args.length && args[argIndex] != null) {
            if (args[argIndex].length() != 0) {
                if (this._debuggeeName.length() != 0) {
                    if (this._debuggeeArgs.length() == 0) {
                        this._debuggeeArgs = args[argIndex];
                    } else if (twoOrMoreDebuggeeArgs) {
                        this._debuggeeArgs = String.valueOf(this._debuggeeArgs) + " " + QuoteUtil.enquoteIfNecessary(args[argIndex]);
                    } else {
                        this._debuggeeArgs = QuoteUtil.enquoteIfNecessary(this._debuggeeArgs) + " " + QuoteUtil.enquoteIfNecessary(args[argIndex]);
                        twoOrMoreDebuggeeArgs = true;
                    }
                } else if (nextIsDebuggee) {
                    this._debuggeeName = args[argIndex];
                } else {
                    String arg = this.rationalizeOption(args[argIndex]);
                    if (_nameSep.equals(arg)) {
                        nextIsDebuggee = true;
                    } else if (this._optionDescriptors == null) {
                        this.acceptUnknownOption(arg);
                    } else {
                        int optionIndex = -1;
                        int argct = 0;
                        DebuggerOptionDescriptor d = null;
                        while (argct == 0 && ++optionIndex < this._optionDescriptors.size() && this._optionDescriptors.get(optionIndex) != null) {
                            d = this._optionDescriptors.get(optionIndex);
                            argct = d.match(arg);
                            if (argct == 2) {
                                if (++argIndex < args.length && args[argIndex] != null && '-' != this.rationalizeOption(args[argIndex]).charAt(0)) {
                                    d.setValue(args[argIndex]);
                                } else {
                                    --argIndex;
                                    argct = 0;
                                }
                            }
                            if (argct == 0) continue;
                            this._options.put(d.name(), d.value());
                        }
                        if (argct == 0) {
                            if (this._acceptUnknownOptions) {
                                this.acceptUnknownOption(arg);
                            } else if ('-' != arg.charAt(0)) {
                                this._debuggeeName = arg;
                            } else {
                                this._invalidOptions.addElement(args[argIndex]);
                            }
                        }
                    }
                }
            }
            ++argIndex;
        }
    }

    protected void setValueByName(String name, String value) {
        this._options.put(name, value);
    }

    protected void clearDebuggee() {
        this._debuggeeName = "";
        this._debuggeeArgs = "";
    }

    public Hashtable<String, String> getOptions() {
        return this._options;
    }

    private void acceptUnknownOption(String arg) {
        if ('-' != arg.charAt(0)) {
            this._debuggeeName = arg;
        } else {
            int eqIndex = arg.indexOf(61);
            if (eqIndex == -1) {
                this._options.put(arg, "");
            } else if (eqIndex > arg.length() - 1) {
                String key = arg.substring(0, eqIndex - 1);
                this._options.put(key, "");
            } else {
                String key = arg.substring(0, eqIndex - 1);
                String value = arg.substring(eqIndex + 1);
                this._options.put(key, value);
            }
        }
    }

    private String rationalizeOption(String arg) {
        if (File.separatorChar == '\\' && arg.charAt(0) == '/') {
            return "-" + arg.substring(1);
        }
        return arg;
    }
}

