/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

public class DebuggerOptionDescriptor {
    private String _name;
    private String _minName;
    private String _value = null;
    private boolean _takesParms;
    private boolean _mayConcatenate;

    public DebuggerOptionDescriptor(String name, int minLength, boolean takesParms, boolean mayConcatenate) {
        this._name = name;
        this._minName = name.substring(0, minLength);
        this._takesParms = takesParms;
        this._mayConcatenate = mayConcatenate;
    }

    String value() {
        return this._value;
    }

    void setValue(String value) {
        this._value = value;
    }

    String name() {
        return this._name;
    }

    int match(String arg) {
        if (!arg.startsWith(this._minName)) {
            return 0;
        }
        int i = this._minName.length();
        while (i < arg.length() && i < this._name.length()) {
            if (arg.charAt(i) != this._name.charAt(i)) {
                if (arg.charAt(i) != '=') {
                    return 0;
                }
                if (arg.length() == ++i) {
                    this._value = "";
                } else {
                    if (!this._takesParms) {
                        return 0;
                    }
                    this._value = arg.substring(i);
                }
                return 1;
            }
            ++i;
        }
        if (i == arg.length()) {
            this._value = "";
            return this._takesParms ? 2 : 1;
        }
        if (arg.charAt(i) == '=') {
            if (++i == arg.length()) {
                this._value = "";
                return 1;
            }
            if (!this._takesParms) {
                return 0;
            }
            this._value = arg.substring(i);
            return 1;
        }
        if (!this._takesParms) {
            return 0;
        }
        if (!this._mayConcatenate) {
            return 0;
        }
        this._value = arg.substring(i);
        return 1;
    }
}

