/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

public class CharacterEscapeUtils {
    private static final String NBSP = "&nbsp;";
    private static final char SPACE = ' ';

    public static String escapeXMLAttribute(String attribute) {
        return CharacterEscapeUtils.escapeString(attribute, false, 0, true);
    }

    public static String escapeHTMLData(String html) {
        return CharacterEscapeUtils.escapeString(html, false, 0, false);
    }

    public static String escapeHTMLData(String html, boolean convertSpacesToNonBreaking, int tabExpansion) {
        return CharacterEscapeUtils.escapeString(html, convertSpacesToNonBreaking, tabExpansion, false);
    }

    private static String escapeString(String text, boolean convertSpacesToNonBreaking, int tabExpansion, boolean ignoreApos) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    if (ignoreApos) {
                        sb.append(c);
                        break;
                    }
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quote;");
                    break;
                }
                case ' ': {
                    CharacterEscapeUtils.insertBlank(sb, convertSpacesToNonBreaking);
                    break;
                }
                case '\t': {
                    if (tabExpansion > 0) {
                        int j = 0;
                        while (j < tabExpansion) {
                            CharacterEscapeUtils.insertBlank(sb, convertSpacesToNonBreaking);
                            ++j;
                        }
                        break;
                    }
                }
                default: {
                    if (c < '\u0010' && c != '\t' && c != '\n' && c != '\r') {
                        CharacterEscapeUtils.insertBlank(sb, convertSpacesToNonBreaking);
                        break;
                    }
                    if (c > '\u007f') {
                        sb.append("&#");
                        sb.append(Integer.toHexString(c));
                        sb.append(';');
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static void insertBlank(StringBuilder sb, boolean convertSpacesToNonBreaking) {
        if (convertSpacesToNonBreaking) {
            sb.append(NBSP);
        } else {
            sb.append(' ');
        }
    }
}

