/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.util;

import java.io.File;
import java.util.Vector;

public class ArgumentTokenizer {
    private String _string;

    public ArgumentTokenizer(String string) {
        this.resetString(string);
    }

    public String nextToken() {
        int stringLen = this._string.length();
        StringBuilder token = new StringBuilder();
        boolean inQuotedString = false;
        boolean insQuotedString = false;
        int pos = 0;
        char nextChar = this.getCharacter(0);
        while (pos < stringLen) {
            char c = nextChar;
            nextChar = this.getCharacter(++pos);
            if (c == '\"') {
                inQuotedString = !inQuotedString;
                continue;
            }
            if (c == '\'') {
                insQuotedString = !insQuotedString;
                token.append(c);
                continue;
            }
            if (c == '\\') {
                if (inQuotedString) {
                    switch (nextChar) {
                        case '\"': 
                        case '\\': {
                            token.append(nextChar);
                            break;
                        }
                        case ' ': {
                            if (pos >= stringLen) break;
                        }
                        default: {
                            token.append('\\').append(nextChar);
                        }
                    }
                    nextChar = this.getCharacter(++pos);
                    continue;
                }
                if ('\\' == File.separatorChar) {
                    token.append(c);
                    continue;
                }
                if (nextChar == ' ' && pos < stringLen) {
                    token.append(nextChar);
                }
                nextChar = this.getCharacter(++pos);
                continue;
            }
            if (inQuotedString || insQuotedString || !Character.isWhitespace(c)) {
                token.append(c);
                continue;
            }
            if (token.length() > 0) break;
        }
        this._string = pos < this._string.length() ? this._string.substring(pos) : "";
        return token.toString();
    }

    public String remainderOfString() {
        int stringLen = this._string.length();
        int pos = 0;
        while (pos < stringLen) {
            if (!Character.isWhitespace(this._string.charAt(pos))) {
                return this._string.substring(pos);
            }
            ++pos;
        }
        return "";
    }

    public void resetString(String s) {
        this._string = s;
    }

    private char getCharacter(int pos) {
        if (pos >= this._string.length() || pos < 0) {
            return '\u0000';
        }
        return this._string.charAt(pos);
    }

    public static String[] fullParse(String arguments) {
        String option;
        Vector<String> args = new Vector<String>();
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments);
        while ((option = tokenizer.nextToken()).length() != 0) {
            args.addElement(option);
        }
        Object[] result = new String[args.size()];
        args.copyInto(result);
        return result;
    }
}

