/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointWatchpoint;
import com.ibm.debug.pdt.internal.epdc.EStdEnhancedWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EStdWatchBPData;
import java.util.Map;

public class Watchpoint
extends EventBreakpoint {
    private static final long serialVersionUID = 20050525L;

    Watchpoint() {
    }

    public Watchpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(owningProcess, epdcBkp, properties);
    }

    public String getExpression() {
        return this._epdcBkp.getEntryName();
    }

    public String getFileName() {
        return this._epdcBkp.getFileName();
    }

    public String getModuleName() {
        return this._epdcBkp.getModuleName();
    }

    public String getPartName() {
        return this._epdcBkp.getPartName();
    }

    public Location getOriginalLocation() {
        EStdView epdcLocation = this._epdcBkp.getOriginalLocation();
        try {
            return new Location(this.getProcess(), epdcLocation);
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    private EStdView getContext() {
        if (this._epdcBkp.getEventBPData() instanceof EStdWatchBPData) {
            return ((EStdWatchBPData)this._epdcBkp.getEventBPData()).getContext();
        }
        if (this._epdcBkp.getEventBPData() instanceof EStdEnhancedWatchBPData) {
            return ((EStdEnhancedWatchBPData)this._epdcBkp.getEventBPData()).getContext();
        }
        return null;
    }

    @Override
    public String getAddress() {
        return this._epdcBkp.getAddress();
    }

    public int getByteCount() {
        return this._epdcBkp.getByteCount();
    }

    public void modify(String addrOrExpr, int byteCount, OptionalBreakpointData optData) throws EngineRequestException {
        if (!this.getEngineSession().supportsModifyingBreakpoints() || this.isReadOnly() || !optData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = this.getRequestAttributes();
        attributes = (short)(attributes | optData.getSyncStopControlAttribute());
        EEveryClause everyClause = optData.getEEveryClause();
        EStdExpression2 condExpr = null;
        if (this.getEngineSession().supportsChgAddrContionalBkp()) {
            condExpr = optData.getEStdExpression2(EStdView.EMPTY_VIEW, this.getEngineSession());
        }
        EStdWatchBPData bkpData = new EStdWatchBPData(addrOrExpr, byteCount, EStdView.EMPTY_VIEW, this.getEngineSession());
        bkpData.setRestoreAddress(this._epdcBkp.getAddress());
        bkpData.setConditionalExpr(condExpr);
        bkpData.setAction(optData.getBreakpointAction());
        bkpData.setModuleName(this.getModuleName());
        bkpData.setPartName(this.getPartName());
        bkpData.setFileName(this.getFileName());
        EReqBreakpointWatchpoint request = new EReqBreakpointWatchpoint(this._epdcBkp.getId(), attributes, everyClause, optData.getThreadId(), bkpData, this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, this.getWorkingSetName());
    }

    boolean restore(DebuggeeProcess targetProcess, Object property) {
        if (!targetProcess.getEngineSession().supportsChangeAddrBreakpoints()) {
            return false;
        }
        try {
            targetProcess.setWatchpoint(true, this.isEnabled(), this.getExpression(), this.getByteCount(), new OptionalBreakpointData(this), null, this.getContext(), this.getFileName(), this.getModuleName(), this.getPartName(), this._epdcBkp.getAddress());
        }
        catch (EngineRequestException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void doCleanupDetails() {
    }
}

