/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ERepGetViews;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ViewInformation
extends DebugModelObject {
    private static final String ENGINE_PREFERRED_VIEW = "engine_preferred_view_";
    private ERepGetViews _epdcViewInformation;
    private short _index;

    ViewInformation(ERepGetViews epdcViewInformation, short viewIndex, DebugEngine debugEngine) {
        super(debugEngine);
        this._epdcViewInformation = epdcViewInformation;
        this._index = viewIndex;
    }

    public String getName() {
        return this._epdcViewInformation.getName();
    }

    public boolean hasPrefixArea() {
        return this._epdcViewInformation.hasPrefixArea();
    }

    public short getKind() {
        return this._epdcViewInformation.getKind();
    }

    public boolean isSourceView() {
        return this._epdcViewInformation.getKind() == 2;
    }

    public boolean isDisassemblyView() {
        return this._epdcViewInformation.getKind() == 4;
    }

    public boolean isMixedView() {
        return this._epdcViewInformation.getKind() == 3;
    }

    public boolean isListingView() {
        return this._epdcViewInformation.getKind() == 5;
    }

    public boolean isMonitorCapable() {
        return this._epdcViewInformation.isMonitorCapable();
    }

    public boolean isLineBreakpointCapable() {
        return this._epdcViewInformation.isLineBreakpointCapable();
    }

    short getViewNum() {
        return this._index;
    }

    @Override
    protected void doCleanupDetails() {
    }

    void setViewNum(short index) {
        this._index = index;
    }

    public static int getPreferredView(DebugEngine engine) {
        if (!engine.getEngineSession().isViewOrderSupported()) {
            return 0;
        }
        IEclipsePreferences coreNode = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.core");
        String engineKey = engine.getUniqueEngineKey();
        return coreNode.getInt(ENGINE_PREFERRED_VIEW + engineKey, 0);
    }

    public static void setPreferredView(DebugEngine engine, int viewNum) {
        IEclipsePreferences coreNode = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.core");
        String engineKey = engine.getUniqueEngineKey();
        coreNode.putInt(ENGINE_PREFERRED_VIEW + engineKey, viewNum);
        try {
            coreNode.flush();
        }
        catch (BackingStoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
    }

    public static int[] getPreferredViewOrder(DebugEngine engine) {
        int preferred = ViewInformation.getPreferredView(engine);
        if (preferred == 0) {
            return null;
        }
        int numViews = engine.getNumberSupportedViews();
        int[] order = new int[numViews];
        order[0] = preferred;
        order[1] = preferred != 1 ? 1 : 2;
        int viewId = preferred != 1 ? 2 : 3;
        int orderIndex = 2;
        while (viewId < numViews + 1) {
            if (viewId != preferred) {
                order[orderIndex++] = viewId;
            }
            ++viewId;
        }
        return order;
    }
}

