/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineBusyException;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Line;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepPartGet;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLine;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqPartGet;
import com.ibm.debug.pdt.internal.epdc.EReqPartSet;
import com.ibm.debug.pdt.internal.epdc.EReqViewFileInfoSet;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdSourceLine;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EViewFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class ViewFile
extends DebugModelObject
implements IDebugLocationProvider {
    private static final String separator = System.getProperty("line.separator");
    protected View _owningView;
    protected EViewFile _epdcFile;
    protected int _index;
    public static final Line[] EMPTYLINES = new Line[0];
    private int fLastLineNumber = -1;
    private int fFirstLineNumber = -1;
    private LineCache fLineCache;
    private boolean fIncludeInternalEntryPoints = true;
    private Hashtable<Integer, ArrayList<LocationBreakpoint>> _breakpoints;
    private static final LocationBreakpoint[] EMPTYBREAKPOINTS = new LocationBreakpoint[0];
    private String _searchString;
    private Location _lastFindLocation;
    private boolean _caseSensitiveSearch;
    private AbstractEditorFile fEditorFile = null;
    private boolean fEngineFoundFile = false;
    private Object fContext;
    private PDTLookupResult fOverride;
    public static final QualifiedName VIEWFILE_KEY = new QualifiedName(null, "com.ibm.debug.pdt.viewfile");
    public static final QualifiedName CONTEXT_KEY = new QualifiedName(null, "com.ibm.debug.pdt.context");
    public static final QualifiedName VIEWFILE_ENGINESUPPLIED_KEY = new QualifiedName(null, "com.ibm.debug.pdt.viewfile.enginesupplied");
    private TreeMap<Integer, ArrayList<Function>> fFunctions = new TreeMap();
    private boolean fFunctionsRetrieved = false;
    private static final Function[] EMPTYFUNCTIONS = new Function[0];

    ViewFile(View owningView, int index, EViewFile epdcFile, DebugEngine debugEngine) {
        this(owningView, index, debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating ViewFile : Index=" + index + " Name=" + epdcFile.getFileName());
        }
        this._epdcFile = epdcFile;
    }

    ViewFile(View owningView, int index, DebugEngine debugEngine) {
        super(debugEngine);
        this._owningView = owningView;
        this._index = index;
        this.fLineCache = new LineCache();
    }

    void setViewFile(EViewFile epdcFile) {
        boolean clearCache = false;
        if (epdcFile == null || this._epdcFile == null) {
            clearCache = true;
        } else {
            String newName = epdcFile.getFileName();
            String oldName = this._epdcFile.getFileName();
            if (newName != null) {
                if (!newName.equals(oldName)) {
                    clearCache = true;
                }
            } else if (oldName != null) {
                clearCache = true;
            }
            if (!clearCache) {
                String newBaseFileName = epdcFile.getBaseFileName();
                String oldBaseFileName = this._epdcFile.getBaseFileName();
                if (newBaseFileName != null) {
                    if (!newBaseFileName.equals(oldBaseFileName)) {
                        clearCache = true;
                    }
                } else if (oldBaseFileName != null) {
                    clearCache = true;
                }
            }
        }
        if (clearCache) {
            this.fLineCache.clear();
        }
        this._epdcFile = epdcFile;
    }

    public Location findString(String string, int startingLine, int startingColumn, boolean caseSensitive) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".findString(" + string + ", " + startingLine + ", " + startingColumn + ")");
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        this._searchString = string;
        this._caseSensitiveSearch = caseSensitive;
        this._lastFindLocation = null;
        this._lastFindLocation = this.fEditorFile.findString(string, startingLine, startingColumn, caseSensitive);
        return this._lastFindLocation;
    }

    public Location findNext() {
        if (this._searchString == null || this._lastFindLocation == null) {
            return null;
        }
        int startingLine = this._lastFindLocation.getLineNumber();
        int startingColumn = this._lastFindLocation.getColumnNumber() + 1;
        return this.findString(this._searchString, startingLine, startingColumn, this._caseSensitiveSearch);
    }

    public Location findAgain(int startingLine, int startingColumn) {
        if (this._searchString == null) {
            return null;
        }
        return this.findString(this._searchString, startingLine, startingColumn, this._caseSensitiveSearch);
    }

    public String getSearchString() {
        return this._searchString;
    }

    public Location getLastSearchStringLocation() {
        return this._lastFindLocation;
    }

    public boolean getSearchCaseSensitivity() {
        return this._caseSensitiveSearch;
    }

    public LocationBreakpoint[] getBreakpoints(int lineNumber) {
        if (this._breakpoints == null) {
            return EMPTYBREAKPOINTS;
        }
        ArrayList<LocationBreakpoint> foundBkps = this._breakpoints.get(lineNumber);
        return foundBkps.toArray(new LocationBreakpoint[foundBkps.size()]);
    }

    public LocationBreakpoint[] getBreakpoints() {
        if (this._breakpoints == null) {
            return EMPTYBREAKPOINTS;
        }
        ArrayList<LocationBreakpoint> allBkps = new ArrayList<LocationBreakpoint>();
        Collection<ArrayList<LocationBreakpoint>> values = this._breakpoints.values();
        for (ArrayList<LocationBreakpoint> arrayList : values) {
            for (LocationBreakpoint locationBreakpoint : arrayList) {
                allBkps.add(locationBreakpoint);
            }
        }
        return allBkps.toArray(new LocationBreakpoint[allBkps.size()]);
    }

    void breakpointAdded(LocationBreakpoint bkp, int lineNumber) {
        ArrayList<LocationBreakpoint> bkpsOnLine;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointAdded()");
        }
        if (this._breakpoints == null) {
            this._breakpoints = new Hashtable();
        }
        if ((bkpsOnLine = this._breakpoints.get(lineNumber)) == null) {
            bkpsOnLine = new ArrayList();
            this._breakpoints.put(lineNumber, bkpsOnLine);
        }
        bkpsOnLine.add(bkp);
        try {
            if (this.fEditorFile != null) {
                this.fEditorFile.addMarker(bkp);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    void breakpointRemoved(LocationBreakpoint bkp, int lineNumber) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointRemoved()");
        }
        if (this._breakpoints == null) {
            return;
        }
        ArrayList<LocationBreakpoint> bkpsOnLine = this._breakpoints.get(lineNumber);
        if (bkpsOnLine != null) {
            bkpsOnLine.remove(bkp);
        }
        if (this.fEditorFile != null) {
            try {
                this.fEditorFile.removeMarker(bkp);
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
    }

    void breakpointChanged(LocationBreakpoint bkp, int lineNumber) {
        if (this._breakpoints == null) {
            return;
        }
        if (this.fEditorFile != null) {
            try {
                this.fEditorFile.updateMarker(bkp, lineNumber);
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
    }

    public boolean hasBreakpoint(Breakpoint breakpoint) {
        if (this._breakpoints == null) {
            return false;
        }
        Enumeration<Integer> bpEnum = this._breakpoints.keys();
        while (bpEnum.hasMoreElements()) {
            Integer intKey = bpEnum.nextElement();
            if (!this._breakpoints.get(intKey).contains(breakpoint)) continue;
            return true;
        }
        return false;
    }

    public View getView() {
        return this._owningView;
    }

    public Part getPart() {
        return this._owningView.getPart();
    }

    public int getFirstLineNumber() {
        if (this.fFirstLineNumber == -1) {
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return -1;
            }
            if (this._epdcFile != null && this.isVerified()) {
                this.fFirstLineNumber = this._epdcFile.getFirstLineNumber();
            }
        }
        return this.fFirstLineNumber;
    }

    public int getLastLineNumber() {
        if (this.fLastLineNumber == -1) {
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return -1;
            }
            if (this._epdcFile != null && this.isVerified()) {
                this.fLastLineNumber = this._epdcFile.getLastLineNumber();
            }
        }
        if (this.fLastLineNumber == 0) {
            this.fLastLineNumber = -1;
        }
        return this.fLastLineNumber;
    }

    public int getNumberOfLines() {
        return this.getLastLineNumber() - this.getFirstLineNumber() + 1;
    }

    public int getPrefixLength() {
        return this._owningView.getPrefixLength();
    }

    public String getFileName() {
        if (this._epdcFile == null || this._epdcFile.getFileName() == null) {
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return null;
            }
        }
        if (this._epdcFile == null) {
            return null;
        }
        return this._epdcFile.getFileName();
    }

    public String getBaseFileName() {
        Language lang;
        String derivedBaseName;
        if (this._epdcFile == null) {
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return null;
            }
        }
        if (this._epdcFile == null) {
            return null;
        }
        if (this._epdcFile.getBaseFileName() == null) {
            if (this._epdcFile.isVerified() || this._epdcFile.isVerificationAttempted()) {
                return this.getPart().getName();
            }
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return null;
            }
        }
        int epdcVersion = this.getEngineSession().getNegotiatedEPDCVersion();
        if (!this._epdcFile.isVerificationAttempted() && this.getEngineSession().isTPF41engine()) {
            try {
                this.verify();
            }
            catch (EngineConnectionException e) {
                return null;
            }
        }
        if (epdcVersion <= 306 && this.getEngineSession().isDebugTool() && (derivedBaseName = new Path(this.getFileName()).lastSegment()) != null) {
            return derivedBaseName.trim();
        }
        if (this.getEngineSession().isDebugTool() && ((lang = this.getPart().getLanguage()).isC() || lang.isCPP())) {
            return this.getFileName();
        }
        return this._epdcFile.getBaseFileName();
    }

    public int getId() {
        return this._index;
    }

    public boolean canFileNameBeOverridden() {
        try {
            this.verify();
        }
        catch (EngineConnectionException e) {
            return false;
        }
        if (this._epdcFile == null) {
            return false;
        }
        return this._epdcFile.isFileNameOverrideSupported() && this.getEngineSession().supportsChangeSourceFile();
    }

    public boolean overrideFileName(String newFileName) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".overrideFileName(" + newFileName + ")");
        }
        if (!this.canFileNameBeOverridden()) {
            throw new EngineRequestUnsupportedException();
        }
        Part part = this.getPart();
        DebugEngine debugEngine = this.getDebugEngine();
        EReqPartSet request = new EReqPartSet(newFileName, part.getId(), this._owningView.getId(), this._index, this.getEngineSession());
        try {
            debugEngine.processRequest(request);
        }
        catch (EngineRequestErrorException ere) {
            return false;
        }
        return true;
    }

    public boolean verify() throws EngineConnectionException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".verify()");
        }
        if (this.haveDoneCleanup()) {
            return false;
        }
        if (this._epdcFile == null || !this._epdcFile.isVerified() && !this._epdcFile.isVerificationAttempted()) {
            try {
                this.getPart().verify(this._index);
            }
            catch (EngineConnectionException ece) {
                throw ece;
            }
            catch (EngineRequestException e) {
                return false;
            }
        }
        return this.isVerified();
    }

    public AbstractEditorFile setEditorFile(AbstractEditorFile editorFile) throws IOException, CoreException {
        if (this.haveDoneCleanup()) {
            return null;
        }
        if (editorFile == null) {
            this.clearEditorFile();
            this.setFoundLocal(false);
            return null;
        }
        if (editorFile.equals((Object)this.fEditorFile)) {
            return this.fEditorFile;
        }
        this.clearEditorFile();
        this.fEditorFile = editorFile;
        this.fEditorFile.init();
        this.setFoundLocal(this.fEditorFile.isFileLocal());
        return this.fEditorFile;
    }

    public AbstractEditorFile getEditorFile() {
        return this.fEditorFile;
    }

    public void setFoundLocal(boolean local) {
        boolean current;
        if (!this.getEngineSession().supportsLocalSourceFiles()) {
            return;
        }
        byte attr = this._epdcFile.getAttributes();
        boolean bl = current = (attr & 0x10) != 0;
        if (local != current) {
            if (local) {
                this.fEngineFoundFile = (attr & 0xFFFFFF80) != 0;
                attr = (byte)(attr | 0xFFFFFF90);
            } else {
                if (!this.fEngineFoundFile) {
                    attr = (byte)(attr & 0x7F);
                }
                attr = (byte)(attr & 0xFFFFFFEF);
            }
            if (this.fEditorFile == null) {
                return;
            }
            try {
                int recLen = Math.max(80, this._epdcFile.getRecordLength());
                EViewFile updatedViewFile = new EViewFile(recLen, this.fEditorFile.getFileStartLine(), this.fEditorFile.getFileEndLine(), this._epdcFile.getFileName(), this._epdcFile.getBaseFileName(), attr, this.getEngineSession());
                EReqViewFileInfoSet request = new EReqViewFileInfoSet(this.getPart().getId(), this.getView().getId(), (short)this.getId(), updatedViewFile, this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineConnectionException recLen) {
            }
            catch (Exception e) {
                PDTCoreUtils.logError(e);
            }
        }
    }

    public void clearEditorFile() {
        if (this.fEditorFile != null) {
            this.fEditorFile.close();
        }
        if (this.fLineCache != null) {
            this.fLineCache.clear();
        }
        this.fEditorFile = null;
    }

    public void clearLineCache() {
        if (this.fLineCache != null) {
            this.fLineCache.clear();
        }
    }

    void fireFileNotFoundErrorEvent() {
        this.getDebugEngine().fireErrorOccurredEventForFileNotFound();
    }

    public void setBreakpoint(boolean enabled, int lineNumber, String stmtNumber, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, String engineData) throws EngineRequestException {
        EReqBreakpointLocation request = this.createBreakpointRequest(enabled, lineNumber, stmtNumber, optBpData, engineData);
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public EReqBreakpointLocation createBreakpointRequest(boolean enabled, int lineNumber, String stmtNumber, OptionalBreakpointData optBpData, String engineData) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setBreakpoint()");
        }
        if (stmtNumber == null && this.getEngineSession().supportsStatementBreakpoints()) {
            stmtNumber = Integer.toString(lineNumber);
        }
        Part part = this.getPart();
        DebuggeeProcess process = part.getModule().getProcess();
        EReqBreakpointLocation request = null;
        if (!this._owningView.isLineBreakpointCapable() && (this._owningView.isDisassemblyView() || this._owningView.isMixedView())) {
            Line line = this.getLine(lineNumber);
            if (line == null) {
                throw new EngineRequestException("Unable to obtain line");
            }
            String address = line.getPrefix(this.getPrefixLength());
            if (address == null) {
                throw new EngineRequestException();
            }
            request = process.createAddressBreakpointRequest(enabled, address, null, optBpData);
        } else {
            EStdView epdcContext = new EStdView(part.getId(), this._owningView.getId(), this._index, lineNumber);
            if (!this.getEngineSession().supportsLineBreakpoints() || !this._owningView.getViewInformation().isLineBreakpointCapable()) {
                throw new EngineRequestException();
            }
            EEveryClause clause = optBpData.getEEveryClause();
            short attributes = enabled ? (short)Short.MIN_VALUE : 0;
            attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
            EStdExpression2 conditionalExpr = optBpData.getEStdExpression2(epdcContext, this.getEngineSession());
            int threadId = optBpData.getThreadId(process);
            request = new EReqBreakpointLine(attributes, clause, null, null, null, null, conditionalExpr, threadId, stmtNumber, epdcContext, engineData, optBpData.getBreakpointAction(), this.getEngineSession());
        }
        return request;
    }

    public int getLineNumberFromCache(String stmtNum) {
        Line[] lines = this.fLineCache.getLinesInCache();
        stmtNum = stmtNum.trim();
        int prefixLength = this.getPrefixLength();
        Line[] lineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            String prefix = line.getPrefix(prefixLength);
            if (stmtNum.equals(prefix.trim())) {
                return line.getLineNumber();
            }
            ++n2;
        }
        try {
            if (this.getEngineSession().isDebugTool()) {
                return Integer.parseInt("3FFFFFFF", 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public Line[] getLines(int startLineNumber, int numberOfLines) {
        try {
            return this.fLineCache.getLines(startLineNumber, numberOfLines);
        }
        catch (InvalidLineRequestException e) {
            PDTCoreUtils.logError(e);
            return EMPTYLINES;
        }
    }

    public Line getLine(int lineNumber) {
        try {
            return this.fLineCache.getLine(lineNumber);
        }
        catch (InvalidLineRequestException e) {
            PDTCoreUtils.logError(e);
            return null;
        }
    }

    public InputStream getInputStream() throws EngineRequestException, IOException {
        Line[] lines = this.getLines(this.getFirstLineNumber(), this.getNumberOfLines());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int prefixLength = this.getView().getPrefixLength(false);
        Line[] lineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            bos.write(this.getPrintableLine(line.getTextNoPrefix(prefixLength, this.getEngineSession())).getBytes("UTF-8"));
            bos.write(separator.getBytes("UTF-8"));
            line.removeText(prefixLength);
            ++n2;
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public String getPrintableLine(String line) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            char currentChar = line.charAt(i);
            if (Character.isWhitespace(currentChar)) {
                buffer.append(' ');
            } else {
                buffer.append(currentChar);
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean isLineExecutable(int lineNumber) {
        return this.fLineCache.isExecutable(lineNumber);
    }

    public boolean isVerified() {
        if (this._epdcFile == null) {
            return false;
        }
        return this._epdcFile.isVerified();
    }

    public boolean isEngineVerified() {
        if (this.isLocal()) {
            return this.fEngineFoundFile;
        }
        return this.isVerified();
    }

    public boolean isLocal() {
        if (this._epdcFile == null) {
            return false;
        }
        return this._epdcFile.isVerifiedLocally();
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        return this.getBaseFileName().compareTo(((ViewFile)o).getBaseFileName());
    }

    @Override
    public PDTDebugElement[] getChildren() {
        return this.getFunctions();
    }

    public boolean isSourceView() {
        return this.getView().isSourceView();
    }

    public boolean isMixedView() {
        return this.getView().isMixedView();
    }

    public boolean isListingView() {
        return this.getView().isListingView();
    }

    public boolean isSourceRequired() {
        return this.isSourceView() || this.isMixedView();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getLabel() {
        String name = this.getBaseFileName();
        if (name == null || name.length() == 0) {
            return PICLLabels.picl_file_no_source;
        }
        if (this.isSourceView() || this.isListingView()) {
            return name;
        }
        return NLS.bind((String)PICLLabels.picl_file_no_source_label2, (Object)name);
    }

    @Override
    protected void doCleanupDetails() {
        this._epdcFile = null;
        if (this.fLineCache != null) {
            this.fLineCache.clear();
            this.fLineCache = null;
        }
        if (this._breakpoints != null) {
            this._breakpoints.clear();
        }
        this.removeAllEventListeners();
        this._searchString = null;
        this._lastFindLocation = null;
        if (this.fEditorFile != null) {
            this.fEditorFile.close();
            this.fEditorFile = null;
        }
    }

    @Override
    public ViewFile getViewFile() {
        return this;
    }

    public Function[] getFunctions() {
        this.retrieveFunctions();
        ArrayList<Function> merged = new ArrayList<Function>();
        for (ArrayList<Function> functionEntries : this.fFunctions.values()) {
            merged.addAll(functionEntries);
        }
        return merged.toArray(new Function[merged.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFunctions() {
        TreeMap<Integer, ArrayList<Function>> treeMap = this.fFunctions;
        synchronized (treeMap) {
            if (!this.fFunctionsRetrieved) {
                this.fFunctionsRetrieved = true;
                Function[] fns = this.getPart().getFunctions();
                ViewInformation vi = this.getView().getViewInformation();
                Function[] functionArray = fns;
                int n = fns.length;
                int n2 = 0;
                while (n2 < n) {
                    Function function = functionArray[n2];
                    if (function.getViewFile(vi) == this && (this.fIncludeInternalEntryPoints || !function.isHidden())) {
                        ArrayList<Function> oldList = this.fFunctions.get(function.getLineNumber());
                        if (oldList == null) {
                            oldList = new ArrayList();
                        }
                        oldList.add(function);
                        this.fFunctions.put(function.getLineNumber(), oldList);
                    }
                    ++n2;
                }
            }
        }
    }

    public Function[] getFunctions(int lineNumber) {
        this.retrieveFunctions();
        Integer key = this.fFunctions.floorKey(lineNumber);
        if (key == null) {
            return EMPTYFUNCTIONS;
        }
        ArrayList<Function> functions = this.fFunctions.get(key);
        return functions.toArray(new Function[functions.size()]);
    }

    Function getNextFunction(Function function) {
        this.retrieveFunctions();
        Integer nextKey = this.fFunctions.higherKey(function.getLineNumber());
        if (nextKey == null) {
            return null;
        }
        ArrayList<Function> functions = this.fFunctions.get(nextKey);
        return functions.get(0);
    }

    public void setLookupOverride(PDTLookupResult override) {
        this.fOverride = override;
    }

    public PDTLookupResult getLookupOverride() {
        return this.fOverride;
    }

    public boolean isLookupOverride() {
        return this.fOverride != null;
    }

    public void clearLookupOverride() {
        this.fOverride = null;
    }

    public void setContext(Object context) {
        this.fContext = context;
    }

    public Object getContext() {
        return this.fContext;
    }

    public void setIncludeInternalEntryPoints(boolean includeInternalEntryPoints) {
        if (this.fIncludeInternalEntryPoints != includeInternalEntryPoints) {
            this.fIncludeInternalEntryPoints = includeInternalEntryPoints;
            this.fFunctions.clear();
            this.fFunctionsRetrieved = false;
        }
    }

    public boolean isDynamic() {
        if (this._epdcFile == null) {
            return false;
        }
        return this._epdcFile.isDynamic();
    }

    public boolean isEmpty() {
        return this.fLineCache.fLines.values().size() == 0;
    }

    public boolean isIncludeFile() {
        return this._epdcFile.isIncludeFile();
    }

    public static class InvalidLineRequestException
    extends Exception {
        private static final long serialVersionUID = -7976608909866653139L;

        InvalidLineRequestException(String string) {
            super(string);
        }
    }

    private class LineCache {
        private int fMaxLinesToRetrieve;
        private static final int CHUNK_SIZE = 200;
        private HashMap<Integer, Line> fLines;

        LineCache() {
            this.fMaxLinesToRetrieve = ViewFile.this.getDebugEngine().getMaxRetrieveLines();
            this.fLines = new HashMap();
        }

        synchronized Line[] getLines(int start, int count) throws InvalidLineRequestException {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, String.format("Request lines : start %d count %d", start, count));
            }
            if (start > ViewFile.this.getLastLineNumber()) {
                throw new InvalidLineRequestException(String.format("Start value %d larger than file size %d", start, ViewFile.this.getLastLineNumber()));
            }
            if (start + count - 1 > ViewFile.this.getLastLineNumber()) {
                throw new InvalidLineRequestException(String.format("Number of lines %d starting at %d greater than available in file of size %d", count, start, ViewFile.this.getLastLineNumber()));
            }
            if (!this.ensureLines(start, count)) {
                return EMPTYLINES;
            }
            Line[] lines = new Line[count];
            int i = 0;
            int idx = start;
            while (i < count) {
                lines[i] = this.fLines.get(idx);
                ++i;
                ++idx;
            }
            return lines;
        }

        synchronized Line getLine(int lineNumber) throws InvalidLineRequestException {
            Line[] lines = this.getLines(lineNumber, 1);
            return lines.length > 0 ? lines[0] : null;
        }

        synchronized Line[] getLinesInCache() {
            return this.fLines.values().toArray(new Line[this.fLines.size()]);
        }

        boolean isExecutable(int lineNumber) {
            if (this.fLines.containsKey(lineNumber)) {
                return this.fLines.get(lineNumber).isExecutable();
            }
            try {
                Line line = this.getLine(lineNumber);
                if (line != null) {
                    return line.isExecutable();
                }
            }
            catch (InvalidLineRequestException e) {
                PDTCoreUtils.logError(e);
            }
            return false;
        }

        private void loadLinesFromEngine(int start, int count) throws EngineRequestException {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, String.format("Load %d lines from engine: %d -> %d available %d", count, start, start + count - 1, ViewFile.this.getNumberOfLines()));
            }
            count = Math.min(count, ViewFile.this.getLastLineNumber() - start + 1);
            int partId = ViewFile.this.getPart().getId();
            short viewId = ViewFile.this.getView().getId();
            int id = ViewFile.this.getId();
            EPDC_EngineSession engineSession = ViewFile.this.getEngineSession();
            DebugEngine debugEngine = ViewFile.this.getDebugEngine();
            int prefix = ViewFile.this.getPrefixLength();
            int left = count;
            int posn = start;
            boolean needsGroup = count > this.fMaxLinesToRetrieve;
            boolean groupSuccessful = !needsGroup;
            try {
                int num;
                if (needsGroup) {
                    groupSuccessful = debugEngine.startGroupRequest(this.hashCode());
                }
                do {
                    num = Math.min(left, this.fMaxLinesToRetrieve);
                    EReqPartGet request = new EReqPartGet(partId, viewId, id, posn, num, engineSession);
                    request.setGroupId(this.hashCode());
                    if (!groupSuccessful) {
                        throw new EngineBusyException(request, debugEngine.getCurrentGroupRequestId());
                    }
                    ERepPartGet reply = (ERepPartGet)debugEngine.processRequest(request);
                    EStdSourceLine[] sourceLines = reply.getSourceLines();
                    int i = 0;
                    int j = posn;
                    while (i < sourceLines.length) {
                        this.fLines.put(j, new Line(j, sourceLines[i], prefix));
                        ++i;
                        ++j;
                    }
                    posn += num;
                } while ((left -= num) > 0);
            }
            finally {
                if (needsGroup && groupSuccessful) {
                    debugEngine.endGroupRequest(this.hashCode());
                }
            }
        }

        private boolean ensureLines(int start, int count) {
            if (!ViewFile.this.isDynamic() && this.fLines.size() == ViewFile.this.getNumberOfLines()) {
                return true;
            }
            int chunckSize = ViewFile.this.isDynamic() ? Math.min(count, 200) : 200;
            int startRequest = ViewFile.this.getFirstLineNumber();
            if (start > chunckSize) {
                startRequest = start - (start - 1) % chunckSize;
            }
            int countRequest = count + start - startRequest;
            int numChunks = countRequest / chunckSize;
            if (countRequest % chunckSize > 0) {
                ++numChunks;
            }
            int chunksToGet = 0;
            int chunkStart = 0;
            try {
                int i = 0;
                int chunkPosn = startRequest;
                while (i < numChunks) {
                    if (!ViewFile.this.isDynamic() && this.fLines.containsKey(chunkPosn)) {
                        if (chunksToGet > 0) {
                            this.loadLinesFromEngine(chunkStart, chunckSize * chunksToGet);
                            chunksToGet = 0;
                            chunkStart = 0;
                        }
                    } else {
                        if (chunksToGet == 0) {
                            chunkStart = chunkPosn;
                        }
                        ++chunksToGet;
                    }
                    ++i;
                    chunkPosn += chunckSize;
                }
                if (chunksToGet > 0) {
                    this.loadLinesFromEngine(chunkStart, chunckSize * chunksToGet);
                }
            }
            catch (EngineConnectionException ece) {
                return false;
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
                return false;
            }
            return true;
        }

        synchronized void clear() {
            this.fLines.clear();
            ViewFile.this.fFirstLineNumber = -1;
            ViewFile.this.fLastLineNumber = -1;
        }
    }
}

