/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EViewData;
import com.ibm.debug.pdt.internal.epdc.EViewFile;
import java.util.Collection;
import java.util.HashMap;

public class View
extends DebugModelObject {
    private static final ViewFile[] EMPTYVIEWFILES = new ViewFile[0];
    private HashMap<Integer, ViewFile> _viewFiles = new HashMap();
    private Part _owningPart;
    private EViewData _epdcView;
    private short _index;
    private boolean _filesHaveBeenRetrieved = false;
    private ViewInformation _viewInformation;

    View(Part owningPart, short index, EViewData epdcView, DebugEngine debugEngine) {
        super(debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating View : OwningPart=" + owningPart.getName() + " Index=" + index);
        }
        this._owningPart = owningPart;
        this._index = index;
        this._viewInformation = this.getDebugEngine().getViewInformation(this._index);
        this.change(epdcView);
    }

    void change(EViewData epdcView) {
        this._epdcView = epdcView;
        EViewFile[] epdcFiles = epdcView.getViewFiles();
        int i = 0;
        int fileIdx = 1;
        while (i < epdcFiles.length) {
            if (this._viewFiles.containsKey(fileIdx)) {
                this._viewFiles.get(fileIdx).setViewFile(epdcFiles[i]);
            } else {
                this._viewFiles.put(fileIdx, new ViewFile(this, fileIdx, epdcFiles[i], this.getDebugEngine()));
            }
            ++i;
            ++fileIdx;
        }
        if (epdcFiles.length > 0) {
            this._filesHaveBeenRetrieved = true;
        }
    }

    void breakpointAdded(LocationBreakpoint bkp) {
        EStdView epdcLocation = bkp.getEPDCLocation(this);
        if (epdcLocation == null) {
            return;
        }
        int viewID = epdcLocation.getViewNum();
        int fileIndex = epdcLocation.getSrcFileIndex();
        if (viewID != this._index || fileIndex < 1) {
            return;
        }
        ViewFile file = this._viewFiles.get(fileIndex);
        if (file == null) {
            file = new ViewFile(this, fileIndex, this.getDebugEngine());
            this._viewFiles.put(fileIndex, file);
        }
        file.breakpointAdded(bkp, epdcLocation.getLineNumber());
    }

    void breakpointRemoved(LocationBreakpoint bkp) {
        ViewFile viewFile = this.getViewFile(bkp);
        if (viewFile != null) {
            EStdView epdcLocation = bkp.getEPDCLocation(this);
            viewFile.breakpointRemoved(bkp, epdcLocation.getLineNumber());
        }
    }

    void breakpointChanged(LocationBreakpoint bkp) {
        ViewFile viewFile = this.getViewFile(bkp);
        if (viewFile != null) {
            EStdView epdcLocation = bkp.getEPDCLocation(this);
            viewFile.breakpointChanged(bkp, epdcLocation.getLineNumber());
        }
    }

    private ViewFile getViewFile(LocationBreakpoint bkp) {
        EStdView epdcLocation = bkp.getEPDCLocation(this);
        if (epdcLocation == null) {
            return null;
        }
        int viewID = epdcLocation.getViewNum();
        int fileIndex = epdcLocation.getSrcFileIndex();
        if (viewID != this._index || fileIndex < 1) {
            return null;
        }
        return this._viewFiles.get(fileIndex);
    }

    public short getId() {
        return this._index;
    }

    public ViewFile[] getViewFiles() {
        if (!this._filesHaveBeenRetrieved) {
            try {
                this._owningPart.verify();
            }
            catch (EngineRequestException e) {
                return EMPTYVIEWFILES;
            }
        }
        if (this._viewFiles == null) {
            return EMPTYVIEWFILES;
        }
        return this._viewFiles.values().toArray(new ViewFile[this._viewFiles.size()]);
    }

    ViewFile getViewFile(int index) {
        if (!this._filesHaveBeenRetrieved) {
            try {
                this._owningPart.verify();
            }
            catch (EngineRequestException e) {
                return null;
            }
        }
        return this.getFileNoVerify(index);
    }

    ViewFile getFileNoVerify(int index) {
        return this._viewFiles.get(index);
    }

    @Override
    public String getLabel() {
        try {
            String label = this.getViewInformation().getName().trim();
            if (label != null) {
                return label;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return PICLLabels.picl_stack_frame_label_unknown;
    }

    void addViewFile(ViewFile viewFile) {
        this._viewFiles.put(viewFile.getId(), viewFile);
    }

    public int getPrefixLength() {
        return this.getPrefixLength(true);
    }

    int getPrefixLength(boolean debugEngineValue) {
        if (!this.getViewInformation().hasPrefixArea()) {
            return 0;
        }
        int enginePrefixValue = this._epdcView.getPrefixLength();
        if (debugEngineValue) {
            return enginePrefixValue;
        }
        if (this.getEngineSession().isDebugTool() || this.getEngineSession().isSLD()) {
            Language lang = this._owningPart.getLanguage();
            if (lang.isCOBOL() || lang.isPLI() || lang.isASM() || lang.isPLX() || this.getEngineSession().isSLD() && this.isListingView()) {
                return enginePrefixValue;
            }
        } else {
            if (this.getEngineSession().isiSeriesEngine()) {
                return enginePrefixValue;
            }
            if (this.getEngineSession().isDBX()) {
                return enginePrefixValue;
            }
        }
        return enginePrefixValue + 1;
    }

    public Part getPart() {
        return this._owningPart;
    }

    public ViewInformation getViewInformation() {
        return this._viewInformation;
    }

    public short getViewKind() {
        return this._viewInformation.getKind();
    }

    public boolean isSourceView() {
        return this._viewInformation.isSourceView();
    }

    public boolean isDisassemblyView() {
        return this._viewInformation.isDisassemblyView();
    }

    public boolean isMixedView() {
        return this._viewInformation.isMixedView();
    }

    public boolean isListingView() {
        return this._viewInformation.isListingView();
    }

    public boolean isMonitorCapable() {
        return this._viewInformation.isMonitorCapable();
    }

    public boolean isLineBreakpointCapable() {
        return this._viewInformation.isLineBreakpointCapable();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public PDTDebugElement[] getChildren() {
        return this.getViewFiles();
    }

    @Override
    protected void doCleanupDetails() {
        this._owningPart = null;
        this._epdcView = null;
        if (this._viewFiles != null) {
            Collection<ViewFile> values = this._viewFiles.values();
            for (ViewFile viewFile : values) {
                viewFile.doCleanup();
            }
            this._viewFiles.clear();
            this._viewFiles = null;
        }
    }
}

