/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.epdc.ERepTypesAndRepsGetNext;
import com.ibm.debug.pdt.internal.epdc.EReqRepForTypeSet;
import java.io.Serializable;
import java.util.Vector;

public class Type
extends DebugModelObject
implements Serializable {
    private transient Vector<Representation> _representations;
    private transient String _name;
    private int _typeIndex;
    private int _defaultRepIndex;
    private int _owningLanguageId;
    private static final long serialVersionUID = 20050124L;

    Type(int typeIndex, int defaultRepIndex) {
        this._typeIndex = typeIndex;
        this._defaultRepIndex = defaultRepIndex;
    }

    Type(ERepTypesAndRepsGetNext epdcTypes, DebugEngine debugEngine, int owningLanguageId) {
        super(debugEngine);
        this._name = epdcTypes.getTypeName();
        this._typeIndex = epdcTypes.getTypeIndex();
        this._defaultRepIndex = epdcTypes.getDefaultRep();
        int[] reps = epdcTypes.getReps();
        this._representations = new Vector(reps.length);
        this._owningLanguageId = owningLanguageId;
        int i = 0;
        while (i < reps.length) {
            this._representations.addElement(debugEngine.getRepresentation(reps[i]));
            ++i;
        }
    }

    public void setDefaultRepresentation(Representation rep) throws EngineRequestException {
        int repIndex = -1;
        if (rep == null || this._representations == null || (repIndex = this._representations.indexOf(rep)) == -1) {
            return;
        }
        this.setDefaultRepresentation(repIndex);
    }

    private void setDefaultRepresentation(int repIndex) throws EngineRequestException {
        if (repIndex == this._defaultRepIndex) {
            return;
        }
        EReqRepForTypeSet request = new EReqRepForTypeSet(this._owningLanguageId, this._typeIndex, repIndex, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
        this._defaultRepIndex = repIndex;
    }

    public Representation getDefaultRep() {
        return this._representations.elementAt(this._defaultRepIndex);
    }

    public Representation[] getRepresentationsArray() {
        Object[] reps = new Representation[this._representations.size()];
        this._representations.copyInto(reps);
        return reps;
    }

    public String getName() {
        return this._name;
    }

    protected int getTypeIndex() {
        return this._typeIndex;
    }

    int getDefaultRepIndex() {
        return this._defaultRepIndex;
    }

    void restore(Language targetLanguage) throws EngineRequestException {
        Type targetType = targetLanguage.getType(this._typeIndex);
        if (targetType == null) {
            return;
        }
        targetType.setDefaultRepresentation(this._defaultRepIndex);
    }

    @Override
    protected void doCleanupDetails() {
    }
}

