/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.Storage;
import com.ibm.debug.pdt.internal.core.model.StorageColumn;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextMonitorStorageLine;

public class StorageLine
extends DebugModelObject {
    private ERepGetNextMonitorStorageLine _epdcStorageLine;
    private Storage _owningStorage;
    private StorageColumn[] _storageColumns;

    StorageLine(Storage owningStorage, ERepGetNextMonitorStorageLine epdcStorageLine, int offset, DebugEngine debugEngine) {
        super(debugEngine);
        this._owningStorage = owningStorage;
        this.change(epdcStorageLine, true);
    }

    void change(ERepGetNextMonitorStorageLine epdcStorageLine, boolean isNew) {
        this._epdcStorageLine = epdcStorageLine;
        String[] storage = this.getStorage();
        String mainStorageString = storage[0];
        int numberOfStrings = storage.length;
        int numberOfUnitsPerLine = this._owningStorage.getNumberOfUnitsPerLine();
        this._storageColumns = new StorageColumn[numberOfUnitsPerLine + (numberOfStrings > 1 ? 1 : 0)];
        int charsPerColumn = mainStorageString.length() / numberOfUnitsPerLine;
        int i = 0;
        int j = 0;
        while (i < numberOfUnitsPerLine) {
            this._storageColumns[i] = new StorageColumn(this, mainStorageString.substring(j, j + charsPerColumn), i, 1, 1, this.getDebugEngine());
            ++i;
            j += charsPerColumn;
        }
        if (numberOfStrings > 1) {
            this._storageColumns[this._storageColumns.length - 1] = new StorageColumn(this, storage[1], 0, 2, numberOfUnitsPerLine, this.getDebugEngine());
        }
    }

    public int getLineNumber() {
        return this._epdcStorageLine.getLineNumber();
    }

    public String getAddress() {
        return this._epdcStorageLine.getAddress();
    }

    public String[] getStorage() {
        return this._epdcStorageLine.getStorage();
    }

    void cleanup() {
        this._epdcStorageLine = null;
        this._owningStorage = null;
        if (this._storageColumns != null) {
            int cnt = this._storageColumns.length;
            int i = 0;
            while (i < cnt) {
                this._storageColumns[i] = null;
                ++i;
            }
            this._storageColumns = null;
        }
        this.removeAllEventListeners();
    }

    @Override
    protected void doCleanupDetails() {
    }
}

