/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.StorageLine;
import com.ibm.debug.pdt.internal.epdc.ECPStorage;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextMonitorStorageLine;
import com.ibm.debug.pdt.internal.epdc.EReqStorageFree;
import java.util.Collection;
import java.util.TreeMap;

public class Storage
extends DebugModelObject {
    private transient DebuggeeProcess _owningProcess;
    private transient int _id;
    private transient TreeMap<Integer, StorageLine> _storageLines = new TreeMap();
    private int _numberOfUnitsPerLine;
    private int _firstLineOffset;

    Storage(DebuggeeProcess owningProcess, ECPStorage epdcStorage, DebugEngine debugEngine) {
        super(debugEngine);
        this._owningProcess = owningProcess;
        this._id = epdcStorage.id();
        this.change(epdcStorage, true);
    }

    void change(ECPStorage epdcStorage, boolean isNew) {
        this._firstLineOffset = epdcStorage.getFirstLineOffset();
        this._numberOfUnitsPerLine = epdcStorage.unitCount();
        ERepGetNextMonitorStorageLine[] lines = epdcStorage.getLines();
        if (!isNew && (epdcStorage.styleChanged() || epdcStorage.addressChanged())) {
            this._storageLines.clear();
        }
        if (lines == null) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            int lineNumber = lines[i].getLineNumber();
            if (this._storageLines.containsKey(lineNumber)) {
                this._storageLines.get(lineNumber).change(lines[i], false);
            } else {
                this._storageLines.put(lineNumber, new StorageLine(this, lines[i], this._firstLineOffset + lineNumber, this.getDebugEngine()));
            }
            ++i;
        }
    }

    public int getNumberOfUnitsPerLine() {
        return this._numberOfUnitsPerLine;
    }

    public DebuggeeProcess getOwningProcess() {
        return this._owningProcess;
    }

    public StorageLine[] getStorageLines() {
        return this._storageLines.values().toArray(new StorageLine[this._storageLines.size()]);
    }

    public void remove() throws EngineRequestException {
        this.getDebugEngine().processRequest(new EReqStorageFree(this._id, this.getEngineSession()));
    }

    int getId() {
        return this._id;
    }

    public void cleanup() {
        this.removeAllEventListeners();
        this._owningProcess = null;
        if (this._storageLines != null && this._storageLines.size() > 0) {
            Collection<StorageLine> values = this._storageLines.values();
            for (StorageLine storageLine : values) {
                storageLine.cleanup();
            }
            this._storageLines.clear();
            this._storageLines = null;
        }
    }

    @Override
    protected void doCleanupDetails() {
    }
}

