/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.IAddressable;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.Stack;
import com.ibm.debug.pdt.internal.core.model.StackColumnDetails;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import com.ibm.debug.pdt.internal.epdc.ERepStackBuildView;
import com.ibm.debug.pdt.internal.epdc.EReqStackBuildView;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.osgi.util.NLS;

public class StackFrame
extends DebugModelObject
implements IStackFrame,
IDisconnect,
IStepFilters,
IAddressable,
IDebugLocationProvider {
    private static final IVariable[] EMPTYVARIABLES = new IVariable[0];
    private static final IRegisterGroup[] EMPTYREGISTERGROUPS = new IRegisterGroup[0];
    private Stack _stack;
    private DebuggeeThread _thread;
    private ERepGetNextStackEntry _epdcStackEntry;
    private Location[] _currentLocations;
    private Part fCurrentPart;
    private Location fCurrentLocation;
    private boolean fSupportsVariables;
    private String fCachedAddress = null;

    protected StackFrame(DebuggeeThread thread, Stack owningStack, ERepGetNextStackEntry epdcStackEntry, DebugEngine debugEngine) {
        super(debugEngine);
        this._stack = owningStack;
        this._epdcStackEntry = epdcStackEntry;
        this._thread = thread;
        this.fSupportsVariables = debugEngine.getEngineSession().supportsLocalVariables();
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating StackFrame ID:" + this.getId());
        }
    }

    void change(ERepGetNextStackEntry epdcStackEntry) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".change()");
        }
        this._epdcStackEntry = epdcStackEntry;
        this._currentLocations = null;
        this.fCurrentPart = null;
    }

    boolean canRepresent(ERepGetNextStackEntry stackEntry) {
        if (this._epdcStackEntry == null || stackEntry == null) {
            return false;
        }
        if (this._epdcStackEntry == stackEntry) {
            return true;
        }
        EStdView[] ourViews = this._epdcStackEntry.getViewInfo();
        EStdView[] newViews = stackEntry.getViewInfo();
        if (ourViews == null || newViews == null || ourViews.length != newViews.length) {
            return false;
        }
        int i = 1;
        while (i < ourViews.length) {
            if (!(ourViews[i] != null && ourViews[i].isEquivalentView(newViews[i]) || newViews[i] == null)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getColumns() {
        return this._epdcStackEntry.getColumns();
    }

    public String getRemStkSize() {
        return this._epdcStackEntry.getRemStkSize();
    }

    public int getNumOfParms() {
        return this._epdcStackEntry.getNumOfParms();
    }

    private Location getStackFrameLocation() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, " getCurrentLocation()");
        }
        if (this._currentLocations == null) {
            Location loc;
            EStdView sfView;
            EStdView[] sfViews = this._epdcStackEntry.getViewInfo();
            this._currentLocations = new Location[sfViews.length];
            EStdView[] eStdViewArray = sfViews;
            int n = sfViews.length;
            int n2 = 0;
            while (n2 < n) {
                sfView = eStdViewArray[n2];
                if (sfView != null) {
                    loc = this.updateCurrentLocation(sfView);
                    if (this.fCurrentPart == null) {
                        this.fCurrentPart = loc.getPart();
                    }
                }
                ++n2;
            }
            if (this.fCurrentPart == null && (sfView = this.getViewFromEngine()) != null) {
                loc = this.updateCurrentLocation(sfView);
                this.fCurrentPart = loc.getPart();
            }
        }
        if (this.fCurrentPart == null) {
            return null;
        }
        View view = this.fCurrentPart.getCurrentView();
        Location requestedLoc = this._currentLocations[view.getId()];
        if (requestedLoc == null || !requestedLoc.isComplete()) {
            EStdView updatedViewLoc = this.getViewFromEngine();
            if (updatedViewLoc == null) {
                return null;
            }
            Location loc = this.updateCurrentLocation(updatedViewLoc);
            if (updatedViewLoc.getViewNum() != view.getId()) {
                try {
                    requestedLoc = this.getDebugEngine().switchView(loc, view.getViewInformation());
                }
                catch (EngineRequestException e) {
                    PDTCoreUtils.logError(e);
                }
                if (requestedLoc != null && requestedLoc.getView() != null) {
                    this._currentLocations[requestedLoc.getView().getId()] = requestedLoc;
                } else {
                    requestedLoc = null;
                }
            } else {
                requestedLoc = loc;
            }
        }
        return requestedLoc;
    }

    private EStdView getViewFromEngine() {
        ERepStackBuildView reply;
        EReqStackBuildView request = new EReqStackBuildView(this._thread.getId(), this._epdcStackEntry, this.getEngineSession());
        try {
            reply = (ERepStackBuildView)this.getDebugEngine().processRequest(request);
        }
        catch (EngineRequestErrorException ere) {
            if (ere.getReturnCode() != 325) {
                PDTCoreUtils.logError(ere);
            }
            return null;
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logError(e);
            return null;
        }
        return reply.getView();
    }

    private Location updateCurrentLocation(EStdView newView) {
        Location loc = null;
        try {
            loc = new Location(this.getDebugEngine().getProcess(), newView);
        }
        catch (LocationConstructionException e1) {
            loc = e1.getErrorLocation();
        }
        this._currentLocations[newView.getViewNum()] = loc;
        return loc;
    }

    public int getId() {
        return this._epdcStackEntry.getId();
    }

    public int getIndex() {
        return this._epdcStackEntry.getIndex();
    }

    public boolean isTopStackFrame() {
        try {
            return this.getId() == this._stack.getTopStackFrame().getId();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public ERepGetNextStackEntry getEpdcStackEntry() {
        return this._epdcStackEntry;
    }

    @Override
    protected void doCleanupDetails() {
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        if (this.haveDoneCleanup()) {
            return -1;
        }
        int lineNumber = 0;
        Location stackLocation = this.getLocation();
        if (stackLocation != null) {
            lineNumber = stackLocation.getLineNumber();
        }
        return lineNumber;
    }

    public Location getLocation() {
        if (this.getDebugTarget().isTerminated()) {
            return null;
        }
        if (this.isTopStackFrame()) {
            this.fCurrentLocation = this._thread.getLocation();
            return this.fCurrentLocation;
        }
        this.fCurrentLocation = this.getStackFrameLocation();
        return this.fCurrentLocation;
    }

    @Override
    public ViewFile getViewFile() {
        Location loc = this.getLocation();
        if (loc == null) {
            return null;
        }
        return loc.getViewFile();
    }

    public String getName() throws DebugException {
        return this.getLabel();
    }

    @Override
    public String getLabel() {
        if (this.getDebugEngine() == null) {
            return PICLLabels.picl_stack_frame_label_unknown;
        }
        StringBuffer label = new StringBuffer();
        String[] columns = this.getColumns();
        int[] defaultCols = this.getDebugEngine().getDefaultColumnIds();
        if (defaultCols == null) {
            label.append(PICLLabels.picl_stack_frame_label_unknown);
        } else if (columns != null && defaultCols.length > 0) {
            int i = 0;
            while (i < defaultCols.length) {
                label.append(columns[defaultCols[i] - 1]);
                if (i < defaultCols.length - 1) {
                    label.append(" : ");
                }
                ++i;
            }
        } else {
            label.append(PICLLabels.picl_stack_frame_label_unknown);
        }
        return label.toString();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        if (this._thread == null || this.isTerminated()) {
            return EMPTYREGISTERGROUPS;
        }
        return this._thread.getRegisterGroups();
    }

    public IThread getThread() {
        return this._thread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.haveDoneCleanup() || !this.isSuspended() || !this.hasVariables() || this.isTerminated()) {
            return EMPTYVARIABLES;
        }
        if (PDTCorePlugin.getInstance().getCurrentSelection() == this) {
            try {
                return this._thread.getLocals(this);
            }
            catch (EngineRequestException e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), (Throwable)e));
            }
        }
        return EMPTYVARIABLES;
    }

    public boolean hasRegisterGroups() throws DebugException {
        if (this.getDebugTarget() instanceof PDTDebugTarget) {
            return ((PDTDebugTarget)this.getDebugTarget()).supportsRegisters();
        }
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.fSupportsVariables;
    }

    public boolean hasDifferentViewFileThanThread() {
        if (this.fCurrentLocation == null) {
            return false;
        }
        try {
            ViewFile threadFile;
            Location loc = this._thread.getLocation();
            ViewFile viewFile = threadFile = loc == null ? null : loc.getViewFile();
            if (this.fCurrentLocation.getViewFile() != threadFile) {
                return true;
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
        return false;
    }

    public boolean isDebuggable() {
        EStdView[] eviews;
        EStdView[] eStdViewArray = eviews = this._epdcStackEntry.getViewInfo();
        int n = eviews.length;
        int n2 = 0;
        while (n2 < n) {
            EStdView eStdView = eStdViewArray[n2];
            if (eStdView != null) {
                return eStdView.getPartID() != 0;
            }
            ++n2;
        }
        return true;
    }

    public boolean canStepInto() {
        return this._thread.canStepInto();
    }

    public boolean canStepOver() {
        return this._thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this._thread.canStepReturn();
    }

    public boolean isStepping() {
        return this._thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this._thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this._thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this._thread.stepReturn();
    }

    public boolean canResume() {
        return this._thread.canResume();
    }

    public boolean canSuspend() {
        return this._thread.canSuspend();
    }

    public boolean isSuspended() {
        return this._thread.isSuspended();
    }

    public void resume() throws DebugException {
        this._thread.resume();
    }

    public void suspend() throws DebugException {
        this._thread.suspend();
    }

    public boolean canTerminate() {
        return this._thread.canTerminate();
    }

    public boolean isTerminated() {
        return this._thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this._thread.terminate();
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean canDisconnect() {
        return this._thread.canDisconnect();
    }

    public void disconnect() throws DebugException {
        this._thread.disconnect();
    }

    public boolean isDisconnected() {
        return this._thread.isDisconnected();
    }

    public boolean isStepFiltersEnabled() {
        return this._thread.isStepFiltersEnabled();
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this._thread.setStepFiltersEnabled(enabled);
    }

    public boolean supportsStepFilters() {
        return this._thread.supportsStepFilters();
    }

    @Override
    public long getMemoryStartAddress() {
        this.fCachedAddress = null;
        int addrCol = this.findAddressColumnNumber();
        if (addrCol < 0) {
            return addrCol;
        }
        this.fCachedAddress = this.getColumns()[addrCol];
        try {
            return PDTCoreUtils.getAddress(this.fCachedAddress);
        }
        catch (NumberFormatException ex) {
            this.fCachedAddress = null;
            return -3L;
        }
    }

    private int findAddressColumnNumber() {
        String ADDRESS_COLUMN_NAME = "Stack Frame";
        int EXPECTED_COLUMN_NUMBER = 6;
        StackColumnDetails[] coldets = this.getDebugEngine().getStackDetails();
        if (coldets.length > 6 && "Stack Frame".equalsIgnoreCase(coldets[6].getColumnName())) {
            return 6;
        }
        int i = 0;
        while (i < coldets.length) {
            if ("Stack Frame".equalsIgnoreCase(coldets[i].getColumnName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getMemoryAddressLabel() {
        String MapMemoryElement_label_StackFrame = "({0} @ {1})";
        if (PDTCoreUtils.isEmpty(this.fCachedAddress)) {
            int addrCol = this.findAddressColumnNumber();
            if (addrCol < 0) {
                return null;
            }
            this.fCachedAddress = this.getColumns()[addrCol];
        }
        return NLS.bind((String)"({0} @ {1})", (Object)this.getLabel(), (Object)this.fCachedAddress);
    }

    public void stepSkipNext() throws DebugException, EngineRequestUnsupportedException {
        this._thread.stepSkipNext();
    }
}

