/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.EmptyStackFrame;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPStack;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import com.ibm.debug.pdt.internal.epdc.EReqStackFree;
import java.util.LinkedList;
import java.util.List;

public class Stack
extends DebugModelObject {
    private final DebuggeeThread _owningThread;
    private final List<StackFrame> _stackFrames = new LinkedList<StackFrame>();
    private final StackFrame[] EMPTYSTACKFRAMES = new StackFrame[1];

    Stack(DebuggeeThread owningThread, ECPStack epdcStack, DebugEngine debugEngine) {
        super(debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating Stack : DUID=" + owningThread.getId());
        }
        this._owningThread = owningThread;
        this.change(epdcStack);
    }

    public DebuggeeThread getThread() {
        return this._owningThread;
    }

    synchronized void change(ECPStack epdcStack) {
        ERepGetNextStackEntry[] stackEntries;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".change()");
        }
        if ((stackEntries = epdcStack.getStackEntries()).length == 0) {
            this.EMPTYSTACKFRAMES[0] = new EmptyStackFrame(this._owningThread, this.getDebugEngine());
            return;
        }
        int firstChange = epdcStack.getOldestChangedEntry() - 1;
        int stackSize = firstChange + stackEntries.length;
        this.setStackSize(stackSize);
        int depth = firstChange;
        ERepGetNextStackEntry[] eRepGetNextStackEntryArray = stackEntries;
        int n = stackEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ERepGetNextStackEntry stackEntry = eRepGetNextStackEntryArray[n2];
            StackFrame current = depth < this._stackFrames.size() ? this._stackFrames.get(depth) : null;
            this.updateStackFrame(current, stackEntry, depth, depth == stackSize - 1);
            ++depth;
            ++n2;
        }
    }

    public void updateStackFrame(StackFrame sf, ERepGetNextStackEntry stkEntry, int depth, boolean top) {
        if (top) {
            stkEntry.setViewInfo(this._owningThread.getEStdViews());
        }
        if (sf == null || !sf.canRepresent(stkEntry)) {
            this.setStackFrame(depth, new StackFrame(this._owningThread, this, stkEntry, this.getDebugEngine()));
        } else {
            sf.change(stkEntry);
        }
    }

    public synchronized void updateTopStackFrame() {
        StackFrame tsf = this.getTopStackFrame();
        if (tsf instanceof EmptyStackFrame) {
            this.EMPTYSTACKFRAMES[0] = new EmptyStackFrame(this._owningThread, this.getDebugEngine());
            return;
        }
        ERepGetNextStackEntry newStkEntry = new ERepGetNextStackEntry(tsf.getEpdcStackEntry());
        this.updateStackFrame(tsf, newStkEntry, this._stackFrames.size() - 1, true);
    }

    private synchronized void setStackSize(int size) {
        while (size < this._stackFrames.size()) {
            this.removeStackFrame(this._stackFrames.size() - 1);
        }
    }

    private synchronized int removeStackFrame(int depth) {
        StackFrame removed;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, String.format(".removeStackFrame(<index> %d)", depth));
        }
        if (this._stackFrames.size() > depth && (removed = this._stackFrames.remove(depth)) != null) {
            removed.doCleanup();
        }
        return this._stackFrames.size();
    }

    private synchronized int setStackFrame(int depth, StackFrame to) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, String.format(".setStackFrame(<index> %d, <StackFrame> %d)", depth, to.getId()));
        }
        if (depth >= this._stackFrames.size()) {
            this._stackFrames.add(to);
            return this._stackFrames.size() - 1;
        }
        StackFrame replaced = this._stackFrames.set(depth, to);
        if (replaced != null) {
            replaced.doCleanup();
        }
        return depth;
    }

    public void freeStack() throws EngineRequestException {
        EReqStackFree request = new EReqStackFree(this._owningThread.getId(), this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    public synchronized StackFrame getTopStackFrame() {
        return this._stackFrames.isEmpty() ? this.EMPTYSTACKFRAMES[0] : this._stackFrames.get(this._stackFrames.size() - 1);
    }

    public synchronized StackFrame[] getStackFrames() {
        return this._stackFrames.isEmpty() ? this.EMPTYSTACKFRAMES : this._stackFrames.toArray(new StackFrame[this._stackFrames.size()]);
    }

    @Override
    protected void doCleanupDetails() {
        this._stackFrames.clear();
    }
}

