/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.saverestore.ISaveRestore;
import com.ibm.debug.pdt.core.saverestore.ISaveRestoreConstants;
import com.ibm.debug.pdt.core.saverestore.SaveRestoreVersion;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggerPersistentProfile;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.ZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgramProfile2
extends DebuggerPersistentProfile
implements ISaveRestore,
ISaveRestoreConstants {
    public static final int CURRENT_VERSION = 20110620;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static final int SERVICE_VERSION = 0;
    private transient DebuggeeProcess fDebuggeeProcess = null;
    protected HashMap<Integer, Breakpoint> fBreakpoints;
    protected HashMap<Integer, ExpressionBase> fMonitoredExpressions;
    protected DebuggeeException[] fExceptions;
    protected HashMap<Integer, Language> fLanguages;
    protected boolean fHeapCheckEnabled;
    protected List<ERepGetPlaybackOptions> fPlaybackOptions;

    public ProgramProfile2() {
        super(20110620);
    }

    public ProgramProfile2(int version) {
        super(version);
    }

    public ProgramProfile2(DebuggeeProcess from) {
        super(20110620);
        this.fDebuggeeProcess = from;
        this.fBreakpoints = this.cleanBreakpoints(from.fBreakpoints);
        this.fMonitoredExpressions = new HashMap<Integer, ExpressionBase>(from.fMonitoredExpressions);
        this.fExceptions = from.getDebugEngine().getExceptions();
        this.fLanguages = from.getDebugEngine()._languages;
        this.fHeapCheckEnabled = from.isHeapCheckEnabled();
        this.fPlaybackOptions = ERepGetPlaybackOptions.getProgramOptions(from.getEngineSession().getPlaybackOptions());
    }

    private HashMap<Integer, Breakpoint> cleanBreakpoints(Map<Integer, Breakpoint> original) {
        HashMap<Integer, Breakpoint> bkpts = new HashMap<Integer, Breakpoint>(original);
        for (Map.Entry<Integer, Breakpoint> entry : original.entrySet()) {
            if (!(entry.getValue() instanceof ZeroAddressBreakpoint)) continue;
            bkpts.remove(entry.getKey());
        }
        return bkpts;
    }

    public boolean restore(DebuggeeProcess to, int flags) {
        if (!this.isReadComplete()) {
            return false;
        }
        boolean completeSuccess = true;
        if ((flags & 0x20000000) != 0) {
            boolean bl = completeSuccess = this.restoreBreakpoints(to) && completeSuccess;
        }
        if ((flags & 0x2000000) != 0) {
            boolean bl = completeSuccess = this.restoreLanguages(to) && completeSuccess;
        }
        if ((flags & 0x10000000) != 0) {
            boolean bl = completeSuccess = this.restoreMonitoredExpressions(to) && completeSuccess;
        }
        if ((flags & 0x1000000) != 0) {
            boolean bl = completeSuccess = this.restoreExceptions(to) && completeSuccess;
        }
        if ((flags & 0x800000) != 0) {
            boolean bl = completeSuccess = this.restoreSpecialOptions(to) && completeSuccess;
        }
        if ((flags & 0x200000) != 0) {
            completeSuccess = completeSuccess ? this.restorePlaybackOptions(to) : false;
        }
        return completeSuccess;
    }

    protected boolean restorePlaybackOptions(DebuggeeProcess to) {
        if (this.fPlaybackOptions != null && to.getEngineSession().getPlaybackOptions() != null) {
            to.getEngineSession().updatePlaybackOptions(this.fPlaybackOptions);
        }
        return true;
    }

    protected boolean restoreBreakpoints(DebuggeeProcess to) {
        int size;
        if (this.fBreakpoints == null || (size = this.fBreakpoints.size()) == 0) {
            return true;
        }
        boolean bpok = true;
        boolean supportsMultiRequests = to.getDebugEngine().getEngineSession().supportsMultipleRequests();
        if (supportsMultiRequests) {
            to.getDebugEngine().startMultipleRequest();
        }
        Breakpoint[] breakpointArray = this.fBreakpoints.values().toArray(new Breakpoint[size]);
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint bp = breakpointArray[n2];
            if (bp != null) {
                bpok = bp.restore(to) && bpok;
            }
            ++n2;
        }
        if (supportsMultiRequests) {
            EPDC_Reply reply = to.getDebugEngine().endMultipleRequest(false);
            bpok = reply != null && reply.getReturnCode() == 0;
        }
        return bpok;
    }

    protected boolean restoreLanguages(DebuggeeProcess to) {
        int size;
        if (this.fLanguages == null || (size = this.fLanguages.size()) == 0) {
            return true;
        }
        boolean lok = true;
        Language[] languageArray = this.fLanguages.values().toArray(new Language[size]);
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            try {
                lang.restore(to);
            }
            catch (EngineRequestException e) {
                lok = false;
            }
            ++n2;
        }
        return lok;
    }

    protected boolean restoreMonitoredExpressions(DebuggeeProcess to) {
        int size;
        if (this.fMonitoredExpressions == null || (size = this.fMonitoredExpressions.size()) == 0) {
            return true;
        }
        boolean meok = true;
        ExpressionBase[] expressionBaseArray = this.fMonitoredExpressions.values().toArray(new ExpressionBase[size]);
        int n = expressionBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionBase expr = expressionBaseArray[n2];
            if (expr != null) {
                try {
                    expr.restore(to);
                }
                catch (EngineRequestException e) {
                    meok = false;
                }
            }
            ++n2;
        }
        return meok;
    }

    protected static ExpressionBase getMonitoredExpression(DebuggeeProcess activating, ECPMonitorExprBase testExpr) {
        ExpressionBase[] mons = activating.getMonitoredExpressions();
        if (mons == null) {
            return null;
        }
        int i = 0;
        while (i < mons.length) {
            if (mons[i] != null && testExpr.isSame(mons[i].getEPDCMonitoredExpression())) {
                return mons[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean restoreExceptions(DebuggeeProcess to) {
        if (this.fExceptions == null || this.fExceptions.length == 0) {
            return true;
        }
        if (this.fExceptions.length != to.getDebugEngine().getExceptions().length) {
            return false;
        }
        boolean eok = true;
        DebuggeeException[] newExceptions = new DebuggeeException[this.fExceptions.length];
        int i = 0;
        while (i < this.fExceptions.length) {
            newExceptions[i] = new DebuggeeException(this.fExceptions[i], to.getDebugEngine());
            ++i;
        }
        to.getDebugEngine().setExceptions(newExceptions);
        try {
            to.getDebugEngine().changeExceptionStatus();
        }
        catch (EngineRequestException e1) {
            eok = false;
        }
        return eok;
    }

    protected boolean restoreSpecialOptions(DebuggeeProcess to) {
        if (this.fHeapCheckEnabled != to.isHeapCheckEnabled()) {
            try {
                to.setHeapCheckEnabled(this.fHeapCheckEnabled);
            }
            catch (EngineRequestException e1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getFileName() {
        StringBuilder baseName = new StringBuilder();
        String validFileName = PDTCoreUtils.getValidFileName(this.fDebuggeeProcess.getBasePgmProfileName());
        String uniqueEngineKey = this.fDebuggeeProcess.getEngineSession().getUniqueEngineKey();
        char languageMnemonic = Language.getLanguageMnemonic(this.fDebuggeeProcess.getDebugEngine().getDominantLanguage());
        String version = this.getSaveRestoreVersion().toString();
        baseName.append(validFileName).append('@').append(uniqueEngineKey).append(languageMnemonic).append('.').append(version).append('.').append("xml");
        return baseName.toString();
    }

    @Override
    public SaveRestoreVersion getSaveRestoreVersion() {
        return new SaveRestoreVersion(1, 0, 0);
    }

    @Override
    protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    protected void writeObjects(ObjectOutputStream out) throws IOException {
    }
}

