/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.ICCEventListener;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.ProcessEvent;
import com.ibm.debug.pdt.internal.epdc.EStdFileFlowPoints;
import com.ibm.debug.pdt.internal.epdc.EStdFlowPointsHit;
import com.ibm.debug.pdt.internal.epdc.EStdNumberList;
import com.ibm.debug.pdt.internal.epdc.EStdTraceEntry;
import java.util.ArrayList;

public class ProcessCCEvent
extends ProcessEvent {
    private static final long serialVersionUID = 20150428L;
    private ArrayList<EStdNumberList> fExecutableLines = new ArrayList();
    private ArrayList<EStdNumberList> fHitLines = new ArrayList();
    private ArrayList<EStdFileFlowPoints> fFileFlowPoints = new ArrayList();
    private ArrayList<EStdFlowPointsHit> fFlowPointsHit = new ArrayList();
    private ArrayList<EStdTraceEntry> fTraceEntries = new ArrayList();

    ProcessCCEvent(Object source, DebuggeeProcess process) {
        super(source, process);
    }

    void addExecutableLines(EStdNumberList[] lines) {
        EStdNumberList[] eStdNumberListArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNumberList item = eStdNumberListArray[n2];
            this.fExecutableLines.add(item);
            ++n2;
        }
    }

    void addHitLines(EStdNumberList[] lines) {
        EStdNumberList[] eStdNumberListArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNumberList item = eStdNumberListArray[n2];
            this.fHitLines.add(item);
            ++n2;
        }
    }

    void addFlowPoints(EStdFileFlowPoints[] fileFlowPoints) {
        EStdFileFlowPoints[] eStdFileFlowPointsArray = fileFlowPoints;
        int n = fileFlowPoints.length;
        int n2 = 0;
        while (n2 < n) {
            EStdFileFlowPoints item = eStdFileFlowPointsArray[n2];
            this.fFileFlowPoints.add(item);
            ++n2;
        }
    }

    void addFlowPointsHit(EStdFlowPointsHit[] pointsHit) {
        EStdFlowPointsHit[] eStdFlowPointsHitArray = pointsHit;
        int n = pointsHit.length;
        int n2 = 0;
        while (n2 < n) {
            EStdFlowPointsHit item = eStdFlowPointsHitArray[n2];
            this.fFlowPointsHit.add(item);
            ++n2;
        }
    }

    void addTraceEntries(EStdTraceEntry[] traceEntries) {
        EStdTraceEntry[] eStdTraceEntryArray = traceEntries;
        int n = traceEntries.length;
        int n2 = 0;
        while (n2 < n) {
            EStdTraceEntry item = eStdTraceEntryArray[n2];
            this.fTraceEntries.add(item);
            ++n2;
        }
    }

    @Override
    void fire(IModelEventListener listener) {
        if (listener instanceof ICCEventListener) {
            if (!this.fExecutableLines.isEmpty() || !this.fHitLines.isEmpty()) {
                ((ICCEventListener)listener).addLines(this.fExecutableLines.toArray(new EStdNumberList[this.fExecutableLines.size()]), this.fHitLines.toArray(new EStdNumberList[this.fHitLines.size()]));
            }
            if (!this.fFileFlowPoints.isEmpty()) {
                ((ICCEventListener)listener).addFlowPoints(this.fFileFlowPoints.toArray(new EStdFileFlowPoints[this.fFileFlowPoints.size()]));
            }
            if (!this.fFlowPointsHit.isEmpty()) {
                ((ICCEventListener)listener).addFlowPointsHit(this.fFlowPointsHit.toArray(new EStdFlowPointsHit[this.fFlowPointsHit.size()]));
            }
            if (!this.fTraceEntries.isEmpty()) {
                ((ICCEventListener)listener).addTraceEntries(this.fTraceEntries.toArray(new EStdTraceEntry[this.fTraceEntries.size()]));
            }
        }
    }
}

