/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.PartChangedEvent;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPPart;
import com.ibm.debug.pdt.internal.epdc.ERepEntrySearch;
import com.ibm.debug.pdt.internal.epdc.EReqEntrySearch;
import com.ibm.debug.pdt.internal.epdc.EReqViewsVerify;
import com.ibm.debug.pdt.internal.epdc.EViewData;
import java.util.Arrays;
import java.util.HashMap;

public class Part
extends DebugModelObject {
    private static final Function[] EMPTYFUNCTIONS = new Function[0];
    private Module _owningModule;
    private ECPPart _epdcPart;
    private View[] fViews;
    private View fCurrentView = null;
    private View fDefaultView = null;
    private boolean fFilesRetrieved;
    private boolean fFunctionsRetrieved = false;
    private final HashMap<Integer, Function> fFunctions = new HashMap();
    private boolean fCleanup = true;

    Part(Module owningModule, ECPPart chgPkt, DebugEngine debugEngine) {
        super(debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating Part : Name=" + chgPkt.getName() + " ID=" + chgPkt.getId());
        }
        this._owningModule = owningModule;
        this.updateFields(chgPkt);
    }

    void change(ECPPart chgPkt) {
        this.updateFields(chgPkt);
        this.addEvent(new PartChangedEvent(this, this));
    }

    private void updateFields(ECPPart chgPkt) {
        this._epdcPart = chgPkt;
        if (this.fViews != null) {
            this.updateViews();
        }
    }

    private void updateViews() {
        EViewData[] epdcViews = this._epdcPart.getViews();
        if (this.fViews == null) {
            this.fViews = new View[epdcViews.length];
            this.fViews[0] = null;
        }
        int i = 1;
        while (i < epdcViews.length) {
            if (epdcViews[i] != null) {
                if (epdcViews[i].isValidated()) {
                    if (this.fViews[i] == null) {
                        this.fViews[i] = new View(this, (short)i, epdcViews[i], this.getDebugEngine());
                    } else {
                        this.fViews[i].change(epdcViews[i]);
                    }
                    if (this.fDefaultView == null) {
                        this.fDefaultView = this.fViews[i];
                    }
                    if (this.fCurrentView == null && this.isVerified()) {
                        this.fCurrentView = this.fViews[i];
                    }
                } else {
                    this.fViews[i] = null;
                }
            }
            ++i;
        }
    }

    public View[] getViews() {
        if (this.fViews == null) {
            this.updateViews();
        }
        return Arrays.copyOf(this.fViews, this.fViews.length);
    }

    void delete(ECPPart epdcPart) {
        this._epdcPart = epdcPart;
    }

    void delete() {
        this._epdcPart.setDeleted();
    }

    void breakpointAdded(LocationBreakpoint bkp) {
        if (bkp instanceof EntryBreakpoint) {
            Function function = ((EntryBreakpoint)bkp).getFunction();
            if (function == null && ((EntryBreakpoint)bkp).getFileName() != null) {
                ((EntryBreakpoint)bkp).getProcess().getFunctions(((EntryBreakpoint)bkp).getFunctionName(), ((EntryBreakpoint)bkp).getPart().getId(), ((EntryBreakpoint)bkp).getEntryID());
                function = ((EntryBreakpoint)bkp).getFunction();
            }
            if (function != null) {
                function.setBrkId(bkp.getId());
            }
        }
        View[] views = this.getViews();
        int i = 0;
        while (i < views.length) {
            View view = views[i];
            if (view != null) {
                view.breakpointAdded(bkp);
            }
            ++i;
        }
    }

    void breakpointRemoved(LocationBreakpoint bkp) {
        Function function;
        if (bkp instanceof EntryBreakpoint && (function = ((EntryBreakpoint)bkp).getFunction()) != null) {
            function.removeBrkId();
        }
        View[] views = this.getViews();
        int i = 0;
        while (i < views.length) {
            View view = views[i];
            if (view != null) {
                view.breakpointRemoved(bkp);
            }
            ++i;
        }
    }

    void breakpointChanged(LocationBreakpoint bkp) {
        View[] views = this.getViews();
        int i = 0;
        while (i < views.length) {
            View view = views[i];
            if (view != null) {
                view.breakpointChanged(bkp);
            }
            ++i;
        }
    }

    public Module getModule() {
        return this._owningModule;
    }

    public int getId() {
        return this._epdcPart.getId();
    }

    public String getName() {
        if (this._epdcPart.getName() != null) {
            return this._epdcPart.getName();
        }
        return "";
    }

    @Override
    public String getLabel() {
        return this._epdcPart.getName();
    }

    public boolean isDebuggable() {
        return this._epdcPart.isDebuggable();
    }

    public Language getLanguage() {
        try {
            this.verify();
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        byte langID = this._epdcPart.getLanguage();
        return this.getDebugEngine().getLanguageInfo(langID);
    }

    View getView(int id) {
        View[] views = this.getViews();
        if (views == null) {
            return null;
        }
        return views[id];
    }

    public View getView(ViewInformation viewInformation) {
        return this.getViews()[viewInformation.getViewNum()];
    }

    public boolean isVerified() {
        return this._epdcPart.hasBeenVerified();
    }

    public void verify() throws EngineRequestException {
        if (this.isVerified()) {
            return;
        }
        this.verify(1);
    }

    void verify(int index) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".verify(Part[" + this.getName() + "].verify(" + index + ")");
        }
        EReqViewsVerify request = new EReqViewsVerify(this._epdcPart.getId(), index, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    @Override
    protected void doCleanupDetails() {
        if (this.fCleanup) {
            this._owningModule = null;
            if (this.fViews != null) {
                int i = 0;
                while (i < this.fViews.length) {
                    View view = this.fViews[i];
                    if (view != null) {
                        view.doCleanup();
                    }
                    this.fViews[i] = null;
                    ++i;
                }
                this.fViews = null;
            }
        }
    }

    public boolean isDeleted() {
        return this._epdcPart.isDeletedPart();
    }

    public View getCurrentView() {
        if (this.fCurrentView == null) {
            try {
                this.verify();
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logString(this, "Failed to verify this Part", 1, e);
            }
            this.updateViews();
        }
        return this.fCurrentView != null ? this.fCurrentView : this.fDefaultView;
    }

    public void setCurrentView(View view) {
        this.fCurrentView = view;
    }

    public View getNextView() {
        if (this.getDebugEngine().getNumberSupportedViews() == 1) {
            return null;
        }
        short idx = this.fCurrentView == null ? (short)0 : this.fCurrentView.getId();
        View[] views = this.getViews();
        do {
            if ((idx = (short)(idx + 1)) == views.length) {
                idx = 1;
            }
            if (this.fCurrentView == null || idx != this.fCurrentView.getId()) continue;
            return null;
        } while (views[idx] == null);
        return views[idx];
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public PDTDebugElement[] getChildren() throws EngineRequestException {
        if (!this.fFilesRetrieved) {
            if (!this.isVerified()) {
                try {
                    this.verify();
                }
                catch (EngineRequestException engineRequestException) {
                    // empty catch block
                }
            }
            View[] views = this.getViews();
            int i = 0;
            while (i < views.length) {
                if (views[i] != null) {
                    ViewFile[] viewFiles = views[i].getViewFiles();
                    int j = 0;
                    while (j < viewFiles.length) {
                        this.addChild(viewFiles[j], false);
                        ++j;
                    }
                    this.fFilesRetrieved = true;
                    break;
                }
                ++i;
            }
        }
        return super.getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function[] getFunctions() {
        HashMap<Integer, Function> hashMap = this.fFunctions;
        synchronized (hashMap) {
            if (!this.fFunctionsRetrieved) {
                this.fFunctionsRetrieved = true;
                try {
                    Function[] fns;
                    EReqEntrySearch request = new EReqEntrySearch(this.getId(), null, 0, 1, this.getEngineSession());
                    DebugEngine engine = this.getDebugEngine();
                    ERepEntrySearch reply = (ERepEntrySearch)engine.processRequest(request);
                    Function[] functionArray = fns = engine.getProcess().processEntrySearch(reply);
                    int n = fns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Function function = functionArray[n2];
                        this.fFunctions.put(function.getId(), function);
                        ++n2;
                    }
                }
                catch (EngineRequestException ere) {
                    return EMPTYFUNCTIONS;
                }
            }
            if (this.fFunctions.isEmpty()) {
                return EMPTYFUNCTIONS;
            }
            return this.fFunctions.values().toArray(new Function[this.fFunctions.size()]);
        }
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        if (o instanceof Part) {
            return this.getName().compareTo(((Part)o).getName());
        }
        return 0;
    }

    public void disableCleanup() {
        this.fCleanup = false;
    }

    public boolean isViewValid(int viewNum) {
        if (viewNum >= this.fViews.length) {
            return false;
        }
        return this.fViews[viewNum] != null;
    }
}

