/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointOccurrence;
import com.ibm.debug.pdt.internal.epdc.EStdOccurrenceBPData;
import java.util.Map;

public class OccurrenceBreakpoint
extends EventBreakpoint {
    private static final long serialVersionUID = 20110131L;

    public OccurrenceBreakpoint() {
    }

    public OccurrenceBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(owningProcess, epdcBkp, properties);
    }

    public String getCondition() {
        return this._epdcBkp.getOccurrenceCondition();
    }

    public void modify(String condition, OptionalBreakpointData optData) throws EngineRequestException {
        if (!this.getEngineSession().supportsModifyingBreakpoints() || this.isReadOnly() || !optData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = this.getRequestAttributes();
        attributes = (short)(attributes | optData.getSyncStopControlAttribute());
        EEveryClause everyClause = optData.getEEveryClause();
        EStdOccurrenceBPData bkpData = new EStdOccurrenceBPData(condition, this.getEngineSession());
        bkpData.setAction(optData.getBreakpointAction());
        EReqBreakpointOccurrence request = new EReqBreakpointOccurrence(this._epdcBkp.getId(), attributes, everyClause, optData.getThreadId(), bkpData, this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        try {
            targetProcess.setOccurrenceBreakpoint(this.isEnabled(), this.getCondition(), new OptionalBreakpointData(this), property);
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }

    @Override
    protected void doCleanupDetails() {
    }
}

