/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.IValueDetail;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;

public class NodeValue
implements IIndexedValue,
IValueDetail {
    private static final int VALUE_MAX_DISPLAY_LENGTH = 2048;
    private int VALUE_TRUNCATE_LENGTH = 2045;
    private ExprNodeBase fNode;
    private static final IVariable[] EMPTYVARIABLES = new IVariable[0];

    public NodeValue(ExprNodeBase node) {
        this.fNode = node;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fNode.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        String fullValue = this.getDetailsValue();
        if (fullValue.length() <= 2048) {
            return fullValue;
        }
        return fullValue.substring(0, this.VALUE_TRUNCATE_LENGTH) + "...";
    }

    public boolean isAllocated() throws DebugException {
        return this.fNode.isAllocated();
    }

    public IVariable[] getVariables() throws DebugException {
        PDTDebugElement[] children;
        try {
            children = this.fNode.getChildren();
        }
        catch (EngineRequestException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", e.getMessage(), (Throwable)e));
        }
        if (children.length == 0) {
            return EMPTYVARIABLES;
        }
        IVariable[] vars = new IVariable[children.length];
        int i = 0;
        while (i < vars.length) {
            vars[i] = (IVariable)children[i];
            ++i;
        }
        return vars;
    }

    public boolean hasVariables() throws DebugException {
        return this.fNode.hasChildren();
    }

    public String getModelIdentifier() {
        return this.fNode.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fNode.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fNode.getLaunch();
    }

    public Object getAdapter(Class adapter) {
        return this.fNode.getAdapter(adapter);
    }

    public IVariable getVariable(int offset) throws DebugException {
        return (IVariable)this.fNode.getChild(offset);
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        PDTDebugElement[] children = this.fNode.getChildren(offset, length);
        if (children.length == 0) {
            return EMPTYVARIABLES;
        }
        IVariable[] vars = new IVariable[children.length];
        int i = 0;
        while (i < vars.length) {
            vars[i] = (IVariable)children[i];
            ++i;
        }
        return vars;
    }

    public int getSize() throws DebugException {
        return this.fNode.getNumChildren();
    }

    public int getInitialOffset() {
        return this.fNode.getBaseIndex();
    }

    public boolean isVariablesRetrieved() {
        if (this.fNode != null) {
            return this.fNode.isChildrenRetrieved();
        }
        return false;
    }

    @Override
    public String getDetailsValue() {
        String valueString = this.fNode.getRawValueString();
        try {
            if (this.fNode.getEngineSession().hostBIDIStringsAreInVisualFormat()) {
                valueString = PDTCorePlugin.getBIDIEngine().convertVisualToLogical(valueString, true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return PDTCoreUtils.getNullFreeDisplayString(valueString);
    }
}

