/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.GlobalRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.IRegisterGroupEventListener;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegister;
import com.ibm.debug.pdt.internal.core.model.RegisterAddedEvent;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EReqRegisters2;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersFree2;
import java.util.Collection;
import java.util.TreeMap;

public class MonitoredRegisterGroup
extends DebugModelObject {
    private DebuggeeThread _owningThread;
    private GlobalRegisterGroup _owningGroup;
    private TreeMap<Integer, MonitoredRegister> _monRegisters;

    MonitoredRegisterGroup(DebuggeeThread owningThread, GlobalRegisterGroup owningGroup, DebugEngine debugEngine) {
        super(debugEngine);
        this._owningThread = owningThread;
        this._owningGroup = owningGroup;
    }

    public int getId() {
        return this._owningGroup.getGroupID();
    }

    public String getName() {
        return this._owningGroup.getGroupName();
    }

    synchronized void add(MonitoredRegister monReg) {
        this._monRegisters.put(monReg.getId(), monReg);
        this.addEvent(new RegisterAddedEvent(this, monReg));
    }

    MonitoredRegister getRegister(int id) {
        if (this._monRegisters == null) {
            this.getRegisters();
        }
        return this._monRegisters.get(id);
    }

    synchronized void remove(MonitoredRegister monReg) {
        monReg.prepareToDie();
        this._monRegisters.remove(monReg.getId());
        if (this._monRegisters.isEmpty()) {
            this._monRegisters = null;
        }
    }

    public MonitoredRegister[] getRegisters() {
        if (this._monRegisters == null) {
            this._monRegisters = new TreeMap();
            EReqRegisters2 request = new EReqRegisters2(this._owningThread.getId(), this.getId(), Integer.MIN_VALUE, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
            }
        }
        Collection<MonitoredRegister> temp = this._monRegisters.values();
        return temp.toArray(new MonitoredRegister[temp.size()]);
    }

    public void addEventListener(IRegisterGroupEventListener eventListener) {
        this.addListener(eventListener);
    }

    public DebuggeeThread owningThread() {
        return this._owningThread;
    }

    void prepareToDie() {
    }

    public void stopMonitoring() {
        if (this._monRegisters == null) {
            return;
        }
        EReqRegistersFree2 request = new EReqRegistersFree2(this._owningThread.getId(), this.getId(), this.getEngineSession());
        try {
            this.getDebugEngine().processRequest(request);
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logError(e);
        }
        this._monRegisters.clear();
        this._monRegisters = null;
    }

    @Override
    protected void doCleanupDetails() {
    }
}

