/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IRegisterEventListener;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.RegisterChangedEvent;
import com.ibm.debug.pdt.internal.core.model.RegisterEndedEvent;
import com.ibm.debug.pdt.internal.epdc.ECPRegister;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersValueSet;

public class MonitoredRegister
extends DebugModelObject {
    private MonitoredRegisterGroup _owningGroup;
    private ECPRegister _epdcRegister;

    MonitoredRegister(MonitoredRegisterGroup owningGroup, ECPRegister epdcRegister, DebugEngine debugEngine) {
        super(debugEngine);
        this._owningGroup = owningGroup;
        this._epdcRegister = epdcRegister;
    }

    void change(ECPRegister epdcRegister) {
        ECPRegister oldRegister = this._epdcRegister;
        this._epdcRegister = epdcRegister;
        if (this.getValue().equals(oldRegister.getValue())) {
            return;
        }
        this.addEvent(new RegisterChangedEvent(this, this));
    }

    public void modifyValue(String value) throws EngineRequestException {
        EReqRegistersValueSet request = new EReqRegistersValueSet(this._epdcRegister.getThreadID(), this._owningGroup.getId(), this.getId(), value, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    public int getId() {
        return this._epdcRegister.getRegisterID();
    }

    public MonitoredRegisterGroup getRegisterGroup() {
        return this._owningGroup;
    }

    public String getName() {
        return this._epdcRegister.getName();
    }

    public String getValue() {
        return this._epdcRegister.getValue();
    }

    void prepareToDie() {
        this.addEvent(new RegisterEndedEvent(this, this));
    }

    public void addEventListener(IRegisterEventListener eventListener) {
        this.addListener(eventListener);
    }

    public boolean supportsModifying() {
        return (this._epdcRegister.getType() & 0x40000000) == 0;
    }

    @Override
    protected void doCleanupDetails() {
    }
}

