/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EReqBreakpointModuleLoadRunToEntry;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEvent;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointModuleLoad;
import com.ibm.debug.pdt.internal.epdc.EStdModuleLoadData;
import java.util.Map;

public class ModuleLoadBreakpoint
extends EventBreakpoint {
    private static final long serialVersionUID = 20050525L;
    private boolean fRunToEntry;

    ModuleLoadBreakpoint() {
    }

    public ModuleLoadBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties, boolean runToEntry) {
        super(owningProcess, epdcBkp, properties);
        this.fRunToEntry = runToEntry;
    }

    public String getModuleName() {
        return this._epdcBkp.getEntryName();
    }

    public void modify(String moduleName, OptionalBreakpointData optData) throws EngineRequestException {
        if (!this.getEngineSession().supportsModifyingBreakpoints() || this.isReadOnly() || !optData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = this.getRequestAttributes();
        attributes = (short)(attributes | optData.getSyncStopControlAttribute());
        EEveryClause everyClause = optData.getEEveryClause();
        EStdModuleLoadData bkpData = new EStdModuleLoadData(moduleName, this.getEngineSession(), this.fRunToEntry);
        EReqBreakpointEvent request = null;
        request = this.fRunToEntry ? new EReqBreakpointModuleLoadRunToEntry(this._epdcBkp.getId(), attributes, everyClause, optData.getThreadId(), bkpData, this.getEngineSession()) : new EReqBreakpointModuleLoad(this._epdcBkp.getId(), attributes, everyClause, optData.getThreadId(), bkpData, this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        try {
            targetProcess.setModuleLoadBreakpoint(this.isEnabled(), this._epdcBkp.getEntryName(), new OptionalBreakpointData(this), property, this.fRunToEntry);
            return true;
        }
        catch (EngineRequestErrorException ere) {
            return ere.getReturnCode() == 328;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }

    @Override
    public String getConditionalExpression() {
        return null;
    }

    @Override
    protected void doCleanupDetails() {
    }

    public boolean isRunToEntry() {
        return this.fRunToEntry;
    }
}

