/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.IModuleEventListener;
import com.ibm.debug.pdt.internal.core.model.ModuleChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ModuleUnloadedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.PartAddedEvent;
import com.ibm.debug.pdt.internal.core.model.PartDeletedEvent;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPModule;
import com.ibm.debug.pdt.internal.epdc.ECPPart;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Module
extends DebugModelObject {
    private static final Part[] EMPTYPARTS = new Part[0];
    private DebuggeeProcess _process;
    private String _name;
    private String _qualifiedName;
    private int _id;
    private Hashtable<Integer, Part> _parts;
    private boolean _hasDebugInfo;
    private boolean _hasSideFileDataSet;
    private String _informationalMsg;

    Module(DebuggeeProcess owningProcess, ECPModule chgPkt, DebugEngine debugEngine) {
        super(debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, String.format("Creating Module : ID= %s  Name= %s QualifiedName= %s HasDebugInfo= %b HasSideFileSet= %b InformationalMsg= %s", chgPkt.moduleID(), chgPkt.moduleName(), chgPkt.fullPathModuleName(), chgPkt.hasDebugData(), chgPkt.hasSidefileDataSet(), chgPkt.moduleInformationalMessage()));
        }
        this._process = owningProcess;
        this.updateFields(chgPkt);
    }

    void change(ECPModule chgPkt) {
        this.updateFields(chgPkt);
        this.addEvent(new ModuleChangedEvent(this, this));
    }

    private void updateFields(ECPModule chgPkt) {
        this._name = chgPkt.moduleName();
        this._qualifiedName = chgPkt.fullPathModuleName();
        this._id = chgPkt.moduleID();
        this._hasDebugInfo = chgPkt.hasDebugData();
        this._hasSideFileDataSet = chgPkt.hasSidefileDataSet();
        this._informationalMsg = chgPkt.moduleInformationalMessage();
    }

    public void addEventListener(IModuleEventListener eventListener) {
        this.addListener(eventListener);
    }

    public DebuggeeProcess getProcess() {
        return this._process;
    }

    public boolean hasDebugInfo() {
        return this._hasDebugInfo;
    }

    public String getName() {
        return this._name;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    public boolean hasSideFileDataSet() {
        return this._hasSideFileDataSet;
    }

    public String getInformationalMsg() {
        return this._informationalMsg;
    }

    @Override
    public String getLabel() {
        return this._name;
    }

    public Part[] getParts() {
        if (this._parts == null) {
            return EMPTYPARTS;
        }
        return this._parts.values().toArray(new Part[this._parts.size()]);
    }

    public Part[] getParts(boolean hasDebugInfo) {
        if (hasDebugInfo) {
            if (this._parts == null) {
                return EMPTYPARTS;
            }
            ArrayList<Part> partsWithDebug = new ArrayList<Part>();
            for (Part part : this._parts.values()) {
                if (part == null || !part.isDebuggable()) continue;
                partsWithDebug.add(part);
            }
            return partsWithDebug.toArray(new Part[partsWithDebug.size()]);
        }
        return this.getParts();
    }

    public int getId() {
        return this._id;
    }

    void add(Part part) {
        this._process.add(part);
        if (this._parts == null) {
            this._parts = new Hashtable();
        }
        this._parts.put(part.getId(), part);
        this.addEvent(new PartAddedEvent(this, part));
    }

    void delete(ECPPart epdcPart) {
        Part part = this.getPart(epdcPart.getId());
        if (part != null) {
            part.delete(epdcPart);
            this.delete(part);
        }
    }

    void delete(Part part) {
        this._process.delete(part);
        this._parts.remove(part.getId());
        part.delete();
        this.addEvent(new PartDeletedEvent(this, part));
    }

    void prepareToDie() {
        this.addEvent(new ModuleUnloadedEvent(this, this));
    }

    @Override
    protected void doCleanupDetails() {
        this._process = null;
        if (this._parts != null) {
            Enumeration<Part> elements = this._parts.elements();
            while (elements.hasMoreElements()) {
                Part p = elements.nextElement();
                p.doCleanup();
            }
            this._parts.clear();
            this._parts = null;
        }
        this.removeAllEventListeners();
    }

    private Part getPart(int partID) {
        if (this._parts == null) {
            return null;
        }
        return this._parts.get(partID);
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        if (o instanceof Module) {
            return this.getName().compareTo(((Module)o).getName());
        }
        return 0;
    }
}

