/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

public abstract class Model {
    public static final int HANDLE_AMBIGUOUS_BREAKPOINTS = 1;
    public static final int SUPPRESS_ERROR_EVENTS_DURING_RESTORE = 2;
    public static final int SUPPRESS_MESSAGE_EVENTS_DURING_RESTORE = 4;
    public static final int HANDLE_AMBIGUOUS_MONITORED_EXPRESSIONS = 8;
    public static final int REUSE_DEBUG_ENGINES = 16;
    private static int _behaviourFlags = 15;

    public static int getModelBehaviour() {
        return _behaviourFlags;
    }

    public static void handleAmbiguousBreakpoints(boolean handle) {
        if (handle) {
            _behaviourFlags |= 1;
        } else if (Model.willHandleAmbiguousBreakpoints()) {
            _behaviourFlags ^= 1;
        }
    }

    public static void handleAmbiguousMonitoredExpressions(boolean handle) {
        if (handle) {
            _behaviourFlags |= 8;
        } else if (Model.willHandleAmbiguousMonitoredExpressions()) {
            _behaviourFlags ^= 8;
        }
    }

    public static void suppressErrorEventsDuringRestore(boolean suppress) {
        if (suppress) {
            _behaviourFlags |= 2;
        } else if (Model.willSuppressErrorEventsDuringRestore()) {
            _behaviourFlags ^= 2;
        }
    }

    public static void suppressMessageEventsDuringRestore(boolean suppress) {
        if (suppress) {
            _behaviourFlags |= 4;
        } else if (Model.willSuppressMessageEventsDuringRestore()) {
            _behaviourFlags ^= 4;
        }
    }

    public static boolean willHandleAmbiguousBreakpoints() {
        return (_behaviourFlags & 1) != 0;
    }

    public static boolean willHandleAmbiguousMonitoredExpressions() {
        return (_behaviourFlags & 8) != 0;
    }

    public static boolean willReuseDebugEngines() {
        return (_behaviourFlags & 0x10) != 0;
    }

    public static boolean willSuppressErrorEventsDuringRestore() {
        return (_behaviourFlags & 2) != 0;
    }

    public static boolean willSuppressMessageEventsDuringRestore() {
        return (_behaviourFlags & 4) != 0;
    }
}

