/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.Storage;
import com.ibm.debug.pdt.internal.core.model.StorageLine;
import com.ibm.debug.pdt.internal.epdc.EStdStorageSegment;
import org.eclipse.debug.core.model.MemoryByte;

public class Memory {
    public static final byte NOTAUTHORIZED = -128;
    public static final byte NULLVALUE = 64;
    private MemoryByte[] fMemoryBytes;
    private byte[] fRawMemory;
    private Storage fStorage;
    private String fStartingAddressFromStorageLine = null;
    private int fAddressSize = -1;
    private boolean fIsBigEndian = false;

    public Memory(Storage storage, boolean isBigEndian, int numBytesRequired) {
        this.fIsBigEndian = isBigEndian;
        this.fStorage = storage;
        StorageLine[] storageLines = storage.getStorageLines();
        MemoryByte[] temp = new MemoryByte[storageLines.length];
        int i = 0;
        while (i < storageLines.length) {
            StorageLine line = storageLines[i];
            if (this.fAddressSize == -1) {
                this.fAddressSize = line.getAddress().length() / 2;
            }
            if (this.fStartingAddressFromStorageLine == null) {
                this.fStartingAddressFromStorageLine = line.getAddress();
            }
            String byteString = line.getStorage()[0];
            try {
                temp[i] = new MemoryByte(Integer.valueOf(byteString, 16).byteValue());
                if (this.fIsBigEndian) {
                    temp[i].setBigEndian(true);
                }
            }
            catch (NumberFormatException nfe) {
                byte flag = 32;
                if (this.fIsBigEndian) {
                    flag = (byte)(flag | 0x10);
                }
                temp[i] = new MemoryByte(0, flag);
            }
            ++i;
        }
        this.fMemoryBytes = new MemoryByte[numBytesRequired];
        if (temp.length < this.fMemoryBytes.length) {
            System.arraycopy(temp, 0, this.fMemoryBytes, 0, temp.length);
            int j = temp.length;
            while (j < this.fMemoryBytes.length) {
                this.fMemoryBytes[j] = new MemoryByte(0, 0);
                ++j;
            }
        } else if (temp.length > this.fMemoryBytes.length) {
            System.arraycopy(temp, 0, this.fMemoryBytes, 0, this.fMemoryBytes.length);
        } else {
            this.fMemoryBytes = temp;
        }
    }

    public Memory(EStdStorageSegment[] segments, boolean isBigEndian, int numBytesRequired) {
        this.fIsBigEndian = isBigEndian;
        int numBytes = 0;
        int i = 0;
        while (i < segments.length) {
            numBytes += segments[i].getNumBytes();
            ++i;
        }
        MemoryByte[] temp = new MemoryByte[numBytes];
        int idx = 0;
        int i2 = 0;
        while (i2 < segments.length) {
            int numBytesInSegment = segments[i2].getNumBytes();
            byte[] segmentBytes = segments[i2].getBytes();
            int flag = 32;
            if (this.fIsBigEndian) {
                flag = (byte)(flag | 0x10);
            }
            if (segments[i2].isNotAuthorized()) {
                flag = (byte)(flag | 0xFFFFFF80);
            }
            if (segments[i2].isReadable()) {
                flag = (byte)(flag | 2);
            }
            if (segments[i2].isWriteable()) {
                flag = (byte)(flag | 1);
            }
            int j = 0;
            while (j < numBytesInSegment) {
                temp[idx++] = new MemoryByte(segmentBytes[j], (byte)(segmentBytes[j] == 0 ? flag | 0x40 : flag));
                ++j;
            }
            ++i2;
        }
        this.fMemoryBytes = new MemoryByte[numBytesRequired];
        if (temp.length < this.fMemoryBytes.length) {
            System.arraycopy(temp, 0, this.fMemoryBytes, 0, temp.length);
            i2 = temp.length;
            while (i2 < this.fMemoryBytes.length) {
                this.fMemoryBytes[i2] = new MemoryByte(0, 64);
                ++i2;
            }
        } else if (temp.length > this.fMemoryBytes.length) {
            System.arraycopy(temp, 0, this.fMemoryBytes, 0, this.fMemoryBytes.length);
        } else {
            this.fMemoryBytes = temp;
        }
    }

    public Memory(MemoryByte[] memoryBytes) {
        this.fMemoryBytes = memoryBytes;
    }

    public Memory(byte[] bytes) {
        this.fRawMemory = bytes;
    }

    public MemoryByte[] getMemory() {
        return this.fMemoryBytes;
    }

    public byte[] getRawMemory() {
        return this.fRawMemory;
    }

    public int getNumBytes() {
        if (this.fRawMemory != null) {
            return this.fRawMemory.length;
        }
        if (this.fMemoryBytes != null) {
            return this.fMemoryBytes.length;
        }
        return 0;
    }

    public Storage getStorage() {
        return this.fStorage;
    }

    public String getBaseAddress() {
        return this.fStartingAddressFromStorageLine;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }
}

