/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointMacro;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import java.util.Map;

public class MacroBreakpoint
extends LocationBreakpoint {
    private static final long serialVersionUID = 20090325L;

    public MacroBreakpoint() {
    }

    public MacroBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(owningProcess, epdcBkp, properties);
    }

    @Override
    protected void doCleanupDetails() {
    }

    public void modifyDeferred(String macroName, String moduleName, String partName, OptionalBreakpointData optData, EPDC_Request.EProperty property) throws EngineRequestException {
        EEveryClause clause = optData.getEEveryClause();
        EStdExpression2 conditionalExpr = optData.getEStdExpression2(null, this.getEngineSession());
        EReqBreakpointMacro request = new EReqBreakpointMacro(this.getRequestAttributes(), clause, macroName, moduleName, partName, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), 0, optData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        try {
            targetProcess.setDeferredMacroBreakpoint(this.isEnabled(), this.getFunctionName(), this.getModuleName(), this.getPartName(), new OptionalBreakpointData(this), property);
            return true;
        }
        catch (EngineRequestErrorException ere) {
            Breakpoint bkpt = (Breakpoint)ere.getReply().retrieveObject(4);
            if (bkpt != null) {
                try {
                    bkpt.remove();
                }
                catch (Exception exception) {}
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return false;
    }
}

