/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class LocationBreakpoint
extends Breakpoint {
    private static final long serialVersionUID = 20080213L;
    private transient EStdView[] _epdcLocations;
    public transient Set<Part> _parts;

    LocationBreakpoint() {
    }

    LocationBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint chgPkt, Map<Integer, Object> properties) {
        super(owningProcess, chgPkt, properties);
    }

    @Override
    void updateFields(ECPBreakpoint chgPkt, Map<Integer, Object> properties) {
        super.updateFields(chgPkt, properties);
        this._epdcLocations = chgPkt.getContexts();
        if (this._parts == null) {
            this._parts = new HashSet<Part>();
        }
        HashSet<Part> previousParts = new HashSet<Part>();
        previousParts.addAll(this._parts);
        this._parts.clear();
        EStdView[] eStdViewArray = this._epdcLocations;
        int n = this._epdcLocations.length;
        int n2 = 0;
        while (n2 < n) {
            int partID;
            EStdView location = eStdViewArray[n2];
            if (location != null && (partID = location.getPartID()) != 0) {
                this._parts.add(this.getProcess().getPart(partID));
            }
            ++n2;
        }
        HashSet<Part> changedParts = new HashSet<Part>();
        for (Part element : this._parts) {
            if (previousParts.contains(element)) {
                changedParts.add(element);
                continue;
            }
            element.breakpointAdded(this);
        }
        for (Part element : previousParts) {
            if (this._parts.contains(element)) continue;
            element.breakpointRemoved(this);
        }
        for (Part element : changedParts) {
            element.breakpointChanged(this);
        }
    }

    @Override
    void prepareToDie() {
        super.prepareToDie();
        if (this._parts != null) {
            Iterator<Part> iter = this._parts.iterator();
            Part iterPart = null;
            while (iter.hasNext()) {
                iterPart = iter.next();
                if (iterPart == null) continue;
                iterPart.breakpointRemoved(this);
            }
        }
    }

    public Part getPart() {
        Iterator<Part> iter;
        if (this._parts != null && (iter = this._parts.iterator()).hasNext()) {
            return iter.next();
        }
        return null;
    }

    public Location getLocationWithinView(ViewInformation viewInformation) {
        try {
            return new Location(this.getProcess(), this.getEPDCLocation(viewInformation));
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    public Location getLocationWithinView(View view) {
        try {
            return new Location(this.getProcess(), this.getEPDCLocation(view));
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    public Location getOriginalLocation() {
        try {
            return new Location(this.getProcess(), this._epdcBkp.getOriginalLocation());
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    public int getLineNumber(ViewInformation viewInfo) {
        EStdView epdcLocation = this.getEPDCLocation(viewInfo);
        if (epdcLocation == null) {
            return -1;
        }
        return epdcLocation.getLineNumber();
    }

    public ViewInformation getViewInformation() {
        Location originalLocation = this.getOriginalLocation();
        try {
            return originalLocation.getView().getViewInformation();
        }
        catch (NullPointerException npe) {
            return this.getDebugEngine().getSourceViewInformation();
        }
    }

    EStdView getEPDCLocation(ViewInformation viewInformation) {
        return this._epdcLocations[viewInformation.getViewNum()];
    }

    EStdView getEPDCLocation(View view) {
        short viewIndex = view.getId();
        int partId = view.getPart().getId();
        int i = 0;
        while (i < this._epdcLocations.length) {
            if (this._epdcLocations[i] != null && this._epdcLocations[i].getPartID() == partId && this._epdcLocations[i].getViewNum() == viewIndex) {
                return this._epdcLocations[i];
            }
            ++i;
        }
        return null;
    }

    public String getFunctionName() {
        return this._epdcBkp.getEntryName();
    }

    public String getModuleName() {
        return this._epdcBkp.getModuleName();
    }

    public String getPartName() {
        return this._epdcBkp.getPartName();
    }

    public String getFileName() {
        return this._epdcBkp.getFileName();
    }

    int getEntryID() {
        return this._epdcBkp.getEntryID();
    }

    @Override
    public String getAddress() {
        return this._epdcBkp.getAddress();
    }
}

