/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;

public class Location
implements IDebugElement,
IDebugLocationProvider {
    private int _hashCode = 0;
    private ViewFile _viewFile;
    private Part _part;
    private View _view;
    private int _lineNumber;
    private int _column;
    private EStdView _epdcLocation;

    public Location(ViewFile viewFile, int lineNumber) {
        this._viewFile = viewFile;
        this._lineNumber = lineNumber;
        this._column = 0;
        this._view = viewFile.getView();
        this._part = viewFile.getPart();
        this._epdcLocation = new EStdView(this._part.getId(), this._view.getId(), viewFile.getId(), this._lineNumber);
    }

    public Location(ViewFile viewFile, int lineNumber, int column) {
        this(viewFile, lineNumber);
        this._column = column;
    }

    protected Location(DebuggeeProcess process, EStdView epdcLocation) throws LocationConstructionException {
        if (process == null || epdcLocation == null) {
            throw new LocationConstructionException(null);
        }
        this._epdcLocation = epdcLocation;
        this._lineNumber = epdcLocation.getLineNumber();
        this._part = process.getPart(epdcLocation.getPartID());
        if (this._part == null) {
            throw new LocationConstructionException(this);
        }
        this._view = this._part.getView(epdcLocation.getViewNum());
        if (this._view == null) {
            throw new LocationConstructionException(this);
        }
    }

    protected final void finalize() {
    }

    public int getColumnNumber() {
        return this._column;
    }

    @Override
    public ViewFile getViewFile() {
        if (this._viewFile == null) {
            this._viewFile = this._view.getViewFile(this._epdcLocation.getSrcFileIndex());
        }
        return this._viewFile;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public Part getPart() {
        return this._part;
    }

    public View getView() {
        return this._view;
    }

    public EStdView getEStdView() {
        return this._epdcLocation;
    }

    public boolean isComplete() {
        return this._part != null && this._view != null && this.getViewFile() != null && this._lineNumber > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            EStdView epdcLoc = ((Location)obj)._epdcLocation;
            Location loc = (Location)obj;
            if (epdcLoc.getPartID() == this._epdcLocation.getPartID() && epdcLoc.getViewNum() == this._epdcLocation.getViewNum() && epdcLoc.getSrcFileIndex() == this._epdcLocation.getSrcFileIndex() && loc.getLineNumber() == this._lineNumber && loc.getColumnNumber() == this._column) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = 17;
            this._hashCode = 37 * this._hashCode + this._epdcLocation.getPartID();
            this._hashCode = 37 * this._hashCode + this._epdcLocation.getViewNum();
            this._hashCode = 37 * this._hashCode + this._epdcLocation.getSrcFileIndex();
            this._hashCode = 37 * this._hashCode + this._lineNumber;
            this._hashCode = 37 * this._hashCode + this._column;
        }
        return this._hashCode;
    }

    public String getModelIdentifier() {
        if (this._part != null) {
            return this._part.getModelIdentifier();
        }
        return null;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        if (this._part != null) {
            return this._part.getDebugTarget();
        }
        return null;
    }

    public ILaunch getLaunch() {
        if (this._part != null) {
            return this._part.getLaunch();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (this._part != null) {
            return this._part.getAdapter(adapter);
        }
        return null;
    }
}

