/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLine;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.Map;

public class LineBreakpoint
extends LocationBreakpoint {
    private static final long serialVersionUID = 20050525L;

    LineBreakpoint() {
    }

    public LineBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(owningProcess, epdcBkp, properties);
    }

    public void modify(boolean enabled, Location location, String stmtNumber, OptionalBreakpointData optData, EPDC_Request.EProperty property, String engineData) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".modify (non-deferred)");
        }
        if (this.isDeferred() || this.isReadOnly()) {
            return;
        }
        EStdView epdcContext = location.getEStdView();
        if (!optData.areAllOptionalDataSupported(this.getEngineSession())) {
            return;
        }
        short attributes = this.getRequestAttributes();
        attributes = (short)(attributes | optData.getSyncStopControlAttribute());
        attributes = enabled ? (short)(attributes | Short.MIN_VALUE) : (short)(attributes & Short.MAX_VALUE);
        EEveryClause clause = optData.getEEveryClause();
        EStdExpression2 conditionalExpr = optData.getEStdExpression2(epdcContext, this.getEngineSession());
        EReqBreakpointLine request = new EReqBreakpointLine(attributes, clause, null, null, null, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), stmtNumber, epdcContext, engineData, optData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void modifyDeferred(boolean enabled, int lineNumber, String stmtNumber, String moduleName, String partName, String fileName, OptionalBreakpointData optData, EPDC_Request.EProperty property, boolean forceDefer) throws EngineRequestException {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isDeferred() || forceDefer) {
            if (!optData.areAllOptionalDataSupported(this.getEngineSession())) {
                return;
            }
            short attributes = this.getRequestAttributes();
            if (forceDefer) {
                attributes = (short)(attributes | 0x4000);
            }
            attributes = (short)(attributes | optData.getSyncStopControlAttribute());
            attributes = enabled ? (short)(attributes | Short.MIN_VALUE) : (short)(attributes & Short.MAX_VALUE);
            EStdView epdcContext = new EStdView(0, 0, 0, lineNumber);
            EEveryClause clause = optData.getEEveryClause();
            EStdExpression2 conditionalExpr = optData.getEStdExpression2(epdcContext, this.getEngineSession());
            EReqBreakpointLine request = new EReqBreakpointLine(attributes, clause, moduleName, partName, fileName, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), stmtNumber, epdcContext, null, optData.getBreakpointAction(), this.getEngineSession());
            request.putProperty(property);
            request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
            this.getDebugEngine().processRequest(request);
        }
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        int lineNumber = -1;
        EStdView originalLocation = this._epdcBkp.getOriginalLocation();
        if (originalLocation != null && originalLocation.getLineNumber() > 0) {
            lineNumber = originalLocation.getLineNumber();
        } else {
            ViewInformation view = null;
            EStdView[] epdcLocations = this._epdcBkp.getContexts();
            ViewInformation[] views = targetProcess.getDebugEngine().getSupportedViews();
            int i = 0;
            while (i < views.length) {
                if (views[i] != null && views[i] != null && views[i].isLineBreakpointCapable()) {
                    view = views[i];
                    break;
                }
                ++i;
            }
            if (view == null) {
                return false;
            }
            lineNumber = epdcLocations[view.getViewNum()].getLineNumber();
        }
        if (lineNumber < 0) {
            return false;
        }
        String stmtNum = null;
        if (targetProcess.getEngineSession().supportsStatementBreakpoints()) {
            stmtNum = this._epdcBkp.getStatementNumber();
        }
        try {
            targetProcess.setDeferredLineBreakpoint(this.isEnabled(), lineNumber, stmtNum, this.getFunctionName(), this.getModuleName(), this.getPartName(), this.getFileName(), new OptionalBreakpointData(this), property);
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }

    public int getDeferredBreakpointLineNumber(ViewInformation viewInformation) {
        EStdView epdcLocation = this.getEPDCLocation(viewInformation);
        if (epdcLocation == null) {
            return 0;
        }
        return epdcLocation.getLineNumber();
    }

    public String getStatementNumber() {
        String stmtField = this._epdcBkp.getStatementNumber();
        return stmtField;
    }

    @Override
    public int getLineNumber(ViewInformation viewInfo) {
        return this._epdcBkp.getContexts()[viewInfo.getViewNum()].getLineNumber();
    }

    public boolean hasEngineData() {
        return this._epdcBkp.getEngineSpecificData() != null;
    }

    public String getEngineData() {
        return this._epdcBkp.getEngineSpecificData();
    }

    public boolean isSourceLineBreakpoint() {
        return this.getModuleName() == null || this.getModuleName().equals("*") || this.getPartName() == null || this.getPartName().equals("*");
    }

    @Override
    protected void doCleanupDetails() {
    }
}

