/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdSourceLine;

public class Line {
    private int fLineNumber;
    private String fContent;
    private byte fFlags;
    private String fPrefix;

    Line(int lineNumber, EStdSourceLine epdcLine, int minLength) {
        this.fLineNumber = lineNumber;
        this.fContent = this.trimTrailing(epdcLine.getLineText(), minLength);
        this.fFlags = epdcLine.getFlags();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public String getText(int prefixLength, EPDC_EngineSession engineSession) {
        if (engineSession.hostBIDIStringsAreInVisualFormat()) {
            return this.getPrefix(prefixLength) + this.getTextNoPrefix(prefixLength, engineSession);
        }
        return this.fContent;
    }

    public String getPrefix(int prefixLength) {
        if (prefixLength == 0) {
            return null;
        }
        if (this.fContent == null) {
            return this.fPrefix;
        }
        return this.fContent.substring(0, prefixLength);
    }

    public int getPrefixAsInt(int prefixLength) {
        String prefix = this.getPrefix(prefixLength).trim();
        try {
            return Integer.parseInt(prefix);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getTextNoPrefix(int prefixLength, EPDC_EngineSession engineSession) {
        String lineText = prefixLength == 0 ? this.fContent : this.fContent.substring(prefixLength);
        if (engineSession.hostBIDIStringsAreInVisualFormat()) {
            lineText = PDTCorePlugin.getBIDIEngine().convertVisualToLogical(lineText, true);
        }
        return lineText;
    }

    public boolean isExecutable() {
        return (this.fFlags & 0xFFFFFF80) != 0;
    }

    public boolean isLocalSource() {
        return (this.fFlags & 0x40) != 0;
    }

    public boolean isRPGFreeForm() {
        return (this.fFlags & 1) != 0;
    }

    public boolean isContinuation() {
        return (this.fFlags & 0x20) != 0;
    }

    public void removeText(int prefixLength) {
        if (prefixLength > 0) {
            this.fPrefix = new String(this.getPrefix(prefixLength).toCharArray());
        }
        this.fContent = null;
    }

    private String trimTrailing(String input, int minLength) {
        if (!input.endsWith(" ")) {
            return input;
        }
        int idx = input.length() - 1;
        while (idx > minLength) {
            if (input.charAt(idx) != ' ') break;
            --idx;
        }
        return new String(input.substring(0, idx + 1).toCharArray());
    }
}

