/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForASM;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForCL400;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForCPP;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForCobol;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForOPMRPG;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForPLI;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForPLX;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForRPG;
import com.ibm.debug.pdt.internal.core.model.Type;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ERepGetLanguages;
import com.ibm.debug.pdt.internal.epdc.ERepTypesAndRepsGetNext;
import com.ibm.debug.pdt.internal.epdc.ERepTypesNumGet;
import com.ibm.debug.pdt.internal.epdc.EReqTypesNumGet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class Language
extends DebugModelObject
implements Serializable {
    private static transient HashMap<Integer, String[]> fExtensionsByLangID = new HashMap();
    private static transient HashMap<Integer, String[]> fIncludeExtensionsByLangID;
    private static final HashMap<String, Byte> fLangIDbyExtension;
    private static final Type[] EMPTYTYPES;
    private static final String[] EMPTYSTRINGS;
    private transient int _numberOfTypes;
    private transient String _name;
    private transient IdentifierParser _parser = null;
    protected HashMap<Integer, Type> _types;
    private int _id;
    private static final long serialVersionUID = 20050124L;

    static {
        fExtensionsByLangID.put(1, new String[]{".c", ".h"});
        fExtensionsByLangID.put(2, new String[]{".cpp", ".hpp", ".h", ".c", ".t", ".inl"});
        fExtensionsByLangID.put(6, new String[]{".cob", ".cbl", ".cblle", ".sqlcbl", ".sqlcblle", ".cpy"});
        fExtensionsByLangID.put(4, new String[]{".pli", ".inc"});
        fExtensionsByLangID.put(17, new String[]{".plx"});
        fExtensionsByLangID.put(7, new String[]{".asmlst", ".asm", ".s"});
        fExtensionsByLangID.put(5, new String[]{".rpg", ".rpgle", ".sqlrpg", ".sqlrpgle"});
        fExtensionsByLangID.put(9, new String[]{".cl", ".clle"});
        fExtensionsByLangID.put(18, new String[]{".go"});
        fIncludeExtensionsByLangID = new HashMap();
        fIncludeExtensionsByLangID.put(1, new String[]{".h"});
        fIncludeExtensionsByLangID.put(2, new String[]{".hpp", ".h", ".t", ".inl"});
        fIncludeExtensionsByLangID.put(6, new String[]{".cpy"});
        fIncludeExtensionsByLangID.put(4, new String[]{".inc"});
        fIncludeExtensionsByLangID.put(17, new String[]{".plx"});
        fIncludeExtensionsByLangID.put(7, new String[]{""});
        fIncludeExtensionsByLangID.put(5, new String[]{""});
        fIncludeExtensionsByLangID.put(9, new String[]{""});
        fIncludeExtensionsByLangID.put(18, new String[]{".go"});
        fLangIDbyExtension = new HashMap();
        fLangIDbyExtension.put("c", (byte)1);
        fLangIDbyExtension.put("h", (byte)1);
        fLangIDbyExtension.put("cpp", (byte)2);
        fLangIDbyExtension.put("hpp", (byte)2);
        fLangIDbyExtension.put("t", (byte)2);
        fLangIDbyExtension.put("inl", (byte)2);
        fLangIDbyExtension.put("cob", (byte)6);
        fLangIDbyExtension.put("cbl", (byte)6);
        fLangIDbyExtension.put("cblle", (byte)6);
        fLangIDbyExtension.put("cpy", (byte)6);
        fLangIDbyExtension.put("pli", (byte)4);
        fLangIDbyExtension.put("inc", (byte)4);
        fLangIDbyExtension.put("plx", (byte)17);
        fLangIDbyExtension.put("asm", (byte)7);
        fLangIDbyExtension.put("s", (byte)7);
        fLangIDbyExtension.put("asmlst", (byte)7);
        fLangIDbyExtension.put("rpg", (byte)5);
        fLangIDbyExtension.put("rpgle", (byte)5);
        fLangIDbyExtension.put("sqlcbl", (byte)6);
        fLangIDbyExtension.put("sqlcblle", (byte)6);
        fLangIDbyExtension.put("sqlrpg", (byte)5);
        fLangIDbyExtension.put("sqlrpgle", (byte)5);
        fLangIDbyExtension.put("cl", (byte)9);
        fLangIDbyExtension.put("clle", (byte)9);
        fLangIDbyExtension.put("go", (byte)18);
        EMPTYTYPES = new Type[0];
        EMPTYSTRINGS = new String[0];
    }

    Language(ERepGetLanguages lang, DebugEngine engine) {
        super(engine);
        this._id = lang.getLanguageID();
        this._name = lang.getLanguageName();
    }

    void restore(DebuggeeProcess targetProcess) throws EngineRequestException {
        if (this._types == null || this._types.size() == 0) {
            return;
        }
        Language targetLanguage = targetProcess.getDebugEngine().getLanguageInfo(this._id);
        if (targetLanguage == null) {
            return;
        }
        Collection<Type> values = this._types.values();
        for (Type element : values) {
            element.restore(targetLanguage);
        }
    }

    public boolean isC() {
        return this._id == 1;
    }

    public boolean isCPP() {
        return this._id == 2;
    }

    public static boolean isCPP(int id) {
        return id == 2;
    }

    public boolean isCOBOL() {
        return this._id == 6;
    }

    public boolean isPLI() {
        return this._id == 4;
    }

    public boolean isPLX() {
        return this._id == 17;
    }

    public boolean isASM() {
        return this._id == 7;
    }

    public boolean isRPG() {
        return this._id == 5;
    }

    public boolean isGO() {
        return this._id == 18;
    }

    public Type getType(int index) {
        if (this._types == null) {
            this.getTypes();
        }
        return this._types == null ? null : this._types.get(index);
    }

    private Type[] getTypes() {
        if (this._types == null) {
            ERepTypesNumGet reply;
            EReqTypesNumGet request = new EReqTypesNumGet(this._id, this.getEngineSession());
            try {
                reply = (ERepTypesNumGet)this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException ere) {
                PDTCoreUtils.logError(ere);
                return EMPTYTYPES;
            }
            ERepTypesAndRepsGetNext[] epdcTypes = reply.getTypes();
            this._types = new HashMap();
            this._numberOfTypes = epdcTypes.length;
            if (this._numberOfTypes == 0) {
                return EMPTYTYPES;
            }
            int i = 0;
            while (i < this._numberOfTypes) {
                ERepTypesAndRepsGetNext item = epdcTypes[i];
                this._types.put(item.getTypeIndex(), new Type(item, this.getDebugEngine(), this.getId()));
                ++i;
            }
        }
        Collection<Type> values = this._types.values();
        return values.toArray(new Type[this._types.size()]);
    }

    public String getName() {
        return this._name;
    }

    public String appendFileExtension(String fileName) {
        String[] extensions = Language.getExtensions(this.getId());
        if (extensions.length == 0) {
            return fileName;
        }
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension;
            String extension = stringArray[n2];
            int posn = fileName.lastIndexOf(46);
            if (posn >= 0 && extension.compareToIgnoreCase(fileExtension = fileName.substring(posn)) == 0) {
                return fileName;
            }
            ++n2;
        }
        return fileName + extensions[0];
    }

    public String appendIncludeFileExtension(String fileName) {
        String[] extensions = Language.getIncludeExtensions(this.getId());
        if (extensions.length == 0) {
            return fileName;
        }
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension;
            String extension = stringArray[n2];
            int posn = fileName.lastIndexOf(46);
            if (posn >= 0 && extension.compareToIgnoreCase(fileExtension = fileName.substring(posn)) == 0) {
                return fileName;
            }
            ++n2;
        }
        return fileName + extensions[0];
    }

    public int getId() {
        return this._id;
    }

    public IdentifierParser getIdentifierParser() {
        if (this._parser == null) {
            switch (this.getId()) {
                case 1: 
                case 2: 
                case 10: 
                case 11: 
                case 18: {
                    this._parser = new IdentifierParserForCPP();
                    break;
                }
                case 4: {
                    this._parser = new IdentifierParserForPLI();
                    break;
                }
                case 7: {
                    this._parser = new IdentifierParserForASM();
                    break;
                }
                case 3: 
                case 17: {
                    this._parser = new IdentifierParserForPLX();
                    break;
                }
                case 6: {
                    this._parser = new IdentifierParserForCobol();
                    break;
                }
                case 5: {
                    this._parser = new IdentifierParserForRPG(true);
                    break;
                }
                case 8: {
                    this._parser = new IdentifierParserForOPMRPG(true);
                    break;
                }
                case 9: {
                    this._parser = new IdentifierParserForCL400();
                    break;
                }
                default: {
                    this._parser = new IdentifierParserForCPP();
                }
            }
        }
        return this._parser;
    }

    @Override
    protected void doCleanupDetails() {
    }

    public static char getLanguageMnemonic(byte languageID) {
        switch (languageID) {
            case 1: {
                return 'c';
            }
            case 2: {
                return 'd';
            }
            case 3: {
                return 'x';
            }
            case 4: {
                return 'p';
            }
            case 17: {
                return 'x';
            }
            case 5: {
                return 'r';
            }
            case 6: {
                return 'b';
            }
            case 7: {
                return 'a';
            }
            case 8: {
                return 'o';
            }
            case 9: {
                return 'l';
            }
            case 10: {
                return 'j';
            }
            case 11: {
                return 'f';
            }
            case 18: {
                return 'g';
            }
        }
        return '\u0000';
    }

    public static String[] getExtensions(int id) {
        String[] result = fExtensionsByLangID.get(id);
        if (result == null) {
            return EMPTYSTRINGS;
        }
        return result;
    }

    public static String[] getIncludeExtensions(int id) {
        String[] result = fIncludeExtensionsByLangID.get(id);
        if (result == null) {
            return EMPTYSTRINGS;
        }
        return result;
    }

    public static int getLangID(String extension) {
        String temp = extension.startsWith(".") ? extension.substring(1) : extension;
        Byte result = fLangIDbyExtension.get(temp);
        if (result == null) {
            return 0;
        }
        return result.byteValue();
    }
}

