/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.ColumnBasedIdentifierParser;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.IdentifierParserForFreeFormRPG;
import com.ibm.debug.pdt.internal.core.model.Line;
import com.ibm.debug.pdt.internal.core.model.ViewFile;

public class IdentifierParserForRPG
extends ColumnBasedIdentifierParser {
    private boolean _stringIndexIs0Based = false;
    private char _specifier;
    private boolean _is_comment = false;
    private boolean _is_indicator = false;
    private int _start_pos = 0;
    private int _end_pos = 0;
    private IdentifierParser freeFormParser = null;
    private String[] freeFormOpCodeArray = new String[]{"CALLP", "DOU", "DOW", "EVAL", "IF", "RETURN", "WHEN", "ELSEIF", "EVALR", "EVAL-CORR", "FOR", "ON-ERROR", "SORTA", "XML-INTO", "XML-SAX"};

    public IdentifierParserForRPG(boolean stringIndexIs0Based) {
        this._stringIndexIs0Based = stringIndexIs0Based;
    }

    @Override
    public int[] identifierInString(String line, int startChar) {
        return this.identifierInString(null, -1, line, startChar);
    }

    @Override
    public int[] identifierInString(ViewFile viewFile, int lineNumber, String line, int startChar) {
        int src_prefixlen;
        int oldPrefixLength = src_prefixlen = this.getfPrefixLength();
        if (this._stringIndexIs0Based) {
            ++startChar;
        }
        if (!this.isListing()) {
            src_prefixlen = IdentifierParserForRPG.getSequenceNumberLength((String)line);
            this.setPrefixLength(src_prefixlen);
        }
        int linelen = ((String)line).length();
        int char_idx = startChar;
        if (this.ifFreeForm(viewFile, lineNumber, (String)line, char_idx)) {
            if (this.freeFormParser == null) {
                this.freeFormParser = new IdentifierParserForFreeFormRPG();
                this.freeFormParser.setfPrefixLength(this.getfPrefixLength());
            }
            int[] result = this.freeFormParser.identifierInString((String)line, char_idx - 1);
            this.setPrefixLength(oldPrefixLength);
            return result;
        }
        if (src_prefixlen <= 0) {
            line = (String)line + " ";
            linelen = ((String)line).length();
        }
        char_idx = startChar - src_prefixlen;
        boolean isSourceRPGLineInfo = this.sourceRPGLineInfo((String)line, char_idx);
        this.setPrefixLength(oldPrefixLength);
        if (!isSourceRPGLineInfo) {
            return null;
        }
        if (this._start_pos == 0 && this._end_pos == 0) {
            return null;
        }
        int wordstart = this._start_pos;
        int wordend = this._end_pos;
        if (wordend + src_prefixlen > linelen) {
            wordend = linelen - src_prefixlen;
        }
        boolean colon_found = false;
        int i = char_idx;
        while (i <= this.Min(wordend, linelen - 1)) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ':') {
                wordend = i - 1;
                colon_found = true;
                break;
            }
            ++i;
        }
        if (!colon_found) {
            i = this.Min(char_idx, linelen - 1);
            while (i >= wordstart) {
                if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ':') {
                    wordstart = i + 1;
                    colon_found = true;
                    break;
                }
                --i;
            }
        }
        int bend_old = wordend;
        int bstart_old = wordstart;
        boolean right_paren_found = false;
        boolean left_paren_found = false;
        i = char_idx;
        while (i <= this.Min(bend_old, linelen - 1)) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ')') {
                wordend = i - 1;
                right_paren_found = true;
                break;
            }
            ++i;
        }
        if (right_paren_found) {
            i = this.Min(char_idx, linelen - 1);
            while (i >= bstart_old) {
                if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == '(') {
                    wordstart = i + 1;
                    left_paren_found = true;
                    break;
                }
                --i;
            }
        }
        if (!right_paren_found || !left_paren_found || char_idx < wordstart || char_idx > wordend) {
            wordstart = bstart_old;
            wordend = bend_old;
        }
        boolean nonblank = false;
        i = this.Min(wordend, linelen - 1);
        while (i >= wordstart) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) != ' ') {
                nonblank = true;
                break;
            }
            --i;
        }
        if (!nonblank) {
            return null;
        }
        wordstart += src_prefixlen;
        wordend = src_prefixlen + i - 1;
        if (!left_paren_found || ((String)line).charAt(this.Min(i, linelen - 1)) != ')') {
            ++wordend;
        }
        int[] ans = new int[]{wordstart - (this._stringIndexIs0Based ? 1 : 0), wordend - (this._stringIndexIs0Based ? 1 : 0)};
        if (!('I' != ((String)line).charAt(ans[0]) && 'i' != ((String)line).charAt(ans[0]) || ans[0] + 1 >= ans[1] || 'N' != ((String)line).charAt(ans[0] + 1) && 'n' != ((String)line).charAt(ans[0] + 1) || ans[0] < 1 || ((String)line).charAt(ans[0] - 1) != '*')) {
            ans[0] = ans[0] - 1;
        }
        return ans;
    }

    @Override
    public String doLanguageSpecifics(String token, String line, int index) {
        if (token == null || token.length() == 0) {
            return null;
        }
        String updatedToken = null;
        char specifier = this._specifier;
        boolean is_comment = this._is_comment;
        boolean is_indicator = this._is_indicator;
        int start_pos = this._start_pos;
        int end_pos = this._end_pos;
        int start_index = index - this.getfPrefixLength() - 1;
        this._is_comment = false;
        this._is_indicator = false;
        if (token.length() <= 2) {
            this.sourceRPGLineInfo(line, start_index);
        }
        updatedToken = this.updateExpression(token, this._is_indicator);
        this._specifier = specifier;
        this._is_comment = is_comment;
        this._is_indicator = is_indicator;
        this._start_pos = start_pos;
        this._end_pos = end_pos;
        return updatedToken;
    }

    /*
     * Unable to fully structure code
     */
    private boolean sourceRPGLineInfo(String line, int char_idx) {
        block76: {
            block77: {
                src_prefixlen = this.getfPrefixLength();
                bstart = 0;
                bend = 0;
                opcodeColumnLength = 10;
                len = line.length();
                if (--len - src_prefixlen <= 0) {
                    return false;
                }
                this._start_pos = 0;
                this._end_pos = 0;
                this._is_comment = false;
                this._is_indicator = false;
                if (len < 7) break block76;
                if (this.isListing()) break block77;
                if (line.charAt(this.Min(7 + src_prefixlen - 1, len)) == '*') {
                    this._is_comment = true;
                    return true;
                }
                this._specifier = line.charAt(this.Min(6 + src_prefixlen - 1, len));
                switch (line.charAt(this.Min(6 + src_prefixlen - 1, len))) {
                    case 'D': 
                    case 'd': {
                        if (char_idx < 7 || char_idx > 21) ** GOTO lbl24
                        bstart = 7;
                        bend = 21;
                        break block76;
lbl24:
                        // 1 sources

                        return false;
                    }
                    case 'I': 
                    case 'i': {
                        if (char_idx < 21 || char_idx > 30) ** GOTO lbl30
                        bstart = 21;
                        bend = 30;
                        break block76;
lbl30:
                        // 1 sources

                        if (char_idx < 49 || char_idx > 62) ** GOTO lbl34
                        bstart = 49;
                        bend = 62;
                        break block76;
lbl34:
                        // 1 sources

                        switch (char_idx) {
                            case 69: 
                            case 70: {
                                bstart = 69;
                                bend = 70;
                                this._is_indicator = true;
                                break block76;
                            }
                            case 71: 
                            case 72: {
                                bstart = 71;
                                bend = 72;
                                this._is_indicator = true;
                                break block76;
                            }
                            case 73: 
                            case 74: {
                                bstart = 73;
                                bend = 74;
                                this._is_indicator = true;
                                break block76;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case 'O': 
                    case 'o': {
                        if (char_idx < 30 || char_idx > 43) ** GOTO lbl57
                        bstart = 30;
                        bend = 43;
                        break block76;
lbl57:
                        // 1 sources

                        switch (char_idx) {
                            case 22: 
                            case 23: {
                                bstart = 22;
                                bend = 23;
                                this._is_indicator = true;
                                break block76;
                            }
                            case 25: 
                            case 26: {
                                bstart = 25;
                                bend = 26;
                                this._is_indicator = true;
                                break block76;
                            }
                            case 28: 
                            case 29: {
                                bstart = 28;
                                bend = 29;
                                this._is_indicator = true;
                                break block76;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case 'C': 
                    case 'c': {
                        if (char_idx < 36 || char_idx > this.Min(80, len)) ** GOTO lbl121
                        begin_index = this.Min(src_prefixlen + 26 - 1, len);
                        opcode = line.substring(begin_index, this.Min(begin_index + opcodeColumnLength, len));
                        index = opcode.indexOf(40);
                        if (index >= 0) {
                            opcode = opcode.substring(0, this.Min(index, len));
                        }
                        opcode = opcode.trim();
                        if (!this.isExt2Factor(opcode = opcode.toUpperCase())) ** GOTO lbl121
                        c = line.charAt(this.Min(char_idx + src_prefixlen - 1, len));
                        if (c == '(' || c == ')') {
                            return false;
                        }
                        bend = 80;
                        i = char_idx;
                        while (i <= len) {
                            c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                            if (c >= ':' && c <= '>' || c >= '*' && c <= '/' || c == ' ' || c == '\'') {
                                bend = i - 1;
                                break;
                            }
                            ++i;
                        }
                        bstart = 36;
                        i = this.Min(char_idx, len);
                        while (i >= 36) {
                            c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                            if (c >= ':' && c <= '>' || c >= '\'' && c <= '/' || c == ' ') {
                                bstart = i + 1;
                                break;
                            }
                            --i;
                        }
                        if (line.charAt(this.Min(bstart + src_prefixlen - 1, len)) == '%') {
                            return false;
                        }
                        l_paren = 0;
                        i = char_idx;
                        while (i <= this.Min(bend, len)) {
                            c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                            if (c == '(') {
                                ++l_paren;
                            }
                            if (c == ')' && --l_paren < 0) {
                                bend = i - 1;
                                break;
                            }
                            ++i;
                        }
                        if (l_paren > 0) {
                            return false;
                        }
                        break block76;
lbl121:
                        // 2 sources

                        if (char_idx < 12 || char_idx > 25) ** GOTO lbl125
                        bstart = 12;
                        bend = 25;
                        break block76;
lbl125:
                        // 1 sources

                        if (char_idx < 36 || char_idx > 49) ** GOTO lbl129
                        bstart = 36;
                        bend = 49;
                        break block76;
lbl129:
                        // 1 sources

                        if (char_idx < 50 || char_idx > 63) ** GOTO lbl133
                        bstart = 50;
                        bend = 63;
                        break block76;
lbl133:
                        // 1 sources

                        switch (char_idx) {
                            case 7: 
                            case 10: 
                            case 71: 
                            case 73: 
                            case 75: {
                                bstart = char_idx;
                                bend = char_idx + 1;
                                this._is_indicator = true;
                                break block76;
                            }
                            case 8: 
                            case 11: 
                            case 72: 
                            case 74: 
                            case 76: {
                                bstart = char_idx - 1;
                                bend = char_idx;
                                this._is_indicator = true;
                                break block76;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (line.charAt(this.Min(7 + src_prefixlen + 5 - 1, len)) == '*') {
                this._is_comment = true;
                return true;
            }
            this._specifier = line.charAt(this.Min(11 + src_prefixlen - 1, len));
            block20 : switch (line.charAt(this.Min(11 + src_prefixlen - 1, len))) {
                case 'D': 
                case 'd': {
                    if (char_idx >= 12 && char_idx <= 26) {
                        bstart = 12;
                        bend = 26;
                        break;
                    }
                    return false;
                }
                case 'I': 
                case 'i': {
                    if (char_idx >= 26 && char_idx <= 35) {
                        bstart = 26;
                        bend = 35;
                        break;
                    }
                    if (char_idx >= 54 && char_idx <= 67) {
                        bstart = 54;
                        bend = 67;
                        break;
                    }
                    switch (char_idx) {
                        case 74: 
                        case 75: {
                            bstart = 74;
                            bend = 75;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 76: 
                        case 77: {
                            bstart = 76;
                            bend = 77;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 78: 
                        case 79: {
                            bstart = 78;
                            bend = 79;
                            this._is_indicator = true;
                            break block20;
                        }
                    }
                    return false;
                }
                case 'O': 
                case 'o': {
                    if (char_idx >= 35 && char_idx <= 48) {
                        bstart = 35;
                        bend = 48;
                        break;
                    }
                    switch (char_idx) {
                        case 27: 
                        case 28: {
                            bstart = 27;
                            bend = 28;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 30: 
                        case 31: {
                            bstart = 30;
                            bend = 31;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 33: 
                        case 34: {
                            bstart = 33;
                            bend = 34;
                            this._is_indicator = true;
                            break block20;
                        }
                    }
                    return false;
                }
                case 'C': 
                case 'c': {
                    if (char_idx >= 41 && char_idx <= 85) {
                        begin_index = this.Min(src_prefixlen + 31 - 1, len);
                        opcode = line.substring(begin_index, this.Min(6 + begin_index, len));
                        index = opcode.indexOf(40);
                        if (index >= 0) {
                            opcode = opcode.substring(0, this.Min(index, len));
                        }
                        opcode = opcode.trim();
                        if (this.isExt2Factor(opcode = opcode.toUpperCase())) {
                            c = line.charAt(this.Min(char_idx + src_prefixlen - 1, len));
                            if (c == '(' || c == ')') {
                                return false;
                            }
                            bend = 85;
                            i = char_idx;
                            while (i <= this.Min(85, len)) {
                                c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                                if (c >= ':' && c <= '>' || c >= '*' && c <= '/' || c == ' ' || c == '\'') {
                                    bend = i - 1;
                                    break;
                                }
                                ++i;
                            }
                            bstart = 41;
                            i = this.Min(char_idx, len);
                            while (i >= 41) {
                                c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                                if (c >= ':' && c <= '>' || c >= '\'' && c <= '/' || c == ' ') {
                                    bstart = i + 1;
                                    break;
                                }
                                --i;
                            }
                            if (line.charAt(this.Min(bstart + src_prefixlen - 1, len)) == '%') {
                                return false;
                            }
                            l_paren = 0;
                            i = char_idx;
                            while (i <= this.Min(bend, len)) {
                                c = line.charAt(this.Min(i + src_prefixlen - 1, len));
                                if (c == '(') {
                                    ++l_paren;
                                }
                                if (c == ')' && --l_paren < 0) {
                                    bend = i - 1;
                                    break;
                                }
                                ++i;
                            }
                            if (l_paren <= 0) break;
                            return false;
                        }
                    }
                    if (char_idx >= 17 && char_idx <= 30) {
                        bstart = 17;
                        bend = 30;
                        break;
                    }
                    if (char_idx >= 41 && char_idx <= 54) {
                        bstart = 41;
                        bend = 54;
                        break;
                    }
                    if (char_idx >= 55 && char_idx <= 68) {
                        bstart = 55;
                        bend = 68;
                        break;
                    }
                    switch (char_idx) {
                        case 12: 
                        case 13: {
                            bstart = 12;
                            bend = 13;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 15: 
                        case 16: {
                            bstart = 15;
                            bend = 16;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 76: 
                        case 77: {
                            bstart = 76;
                            bend = 77;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 78: 
                        case 79: {
                            bstart = 78;
                            bend = 79;
                            this._is_indicator = true;
                            break block20;
                        }
                        case 80: 
                        case 81: {
                            bstart = 80;
                            bend = 81;
                            this._is_indicator = true;
                            break block20;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        this._start_pos = bstart;
        this._end_pos = bend;
        return true;
    }

    @Override
    public String updateExpression(String expression, boolean flag) {
        if (flag) {
            return "*IN" + expression;
        }
        String updatedExpression = null;
        if (!expression.isEmpty() && expression.charAt(0) == '%') {
            int indexOfBreak = expression.indexOf(40);
            int indexOfLastBreak = expression.indexOf(41);
            if (indexOfBreak >= 0 && indexOfLastBreak >= 0) {
                updatedExpression = expression.substring(indexOfBreak, indexOfLastBreak);
            }
        }
        if (updatedExpression == null) {
            return expression;
        }
        return updatedExpression;
    }

    @Override
    public boolean isIndicator() {
        return this._is_indicator;
    }

    private boolean isExt2Factor(String opcode) {
        if (opcode.trim().equalsIgnoreCase("")) {
            return true;
        }
        int i = 0;
        while (i < this.freeFormOpCodeArray.length) {
            if (opcode.trim().equalsIgnoreCase(this.freeFormOpCodeArray[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int Min(int a, int b) {
        return a > b ? b : a;
    }

    private boolean ifFreeForm(ViewFile viewFile, int lineNumber, String line, int char_idx) {
        Line sourceLine;
        if (viewFile != null && lineNumber >= 0 && (sourceLine = viewFile.getLine(lineNumber)) != null && sourceLine.isRPGFreeForm()) {
            return true;
        }
        int src_prefixlen = this.getfPrefixLength();
        int len = line.length();
        if (--len - src_prefixlen <= 0) {
            return false;
        }
        if (!this.isListing()) {
            return line.charAt(this.Min(6 + src_prefixlen - 1, len)) == ' ' && line.charAt(this.Min(7 + src_prefixlen - 1, len)) == ' ';
        }
        return line.charAt(this.Min(11 + src_prefixlen - 1, len)) == ' ' && line.charAt(this.Min(12 + src_prefixlen - 1, len)) == ' ';
    }
}

