/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DelimitersBasedIdentifierParser;

public class IdentifierParserForPLI
extends DelimitersBasedIdentifierParser {
    private static final char[] delims = new char[]{' ', '<', '(', '+', '$', '*', ')', ';', ':', '/', ',', '>', '=', '\"', '\'', '&', ';', '^', '\u00ac'};
    private static final String rDelims = " <(+$*);:,>=\"'&^\u00ac.";

    @Override
    public char[] getDelimiters() {
        return delims;
    }

    protected boolean isInvalidIndex(String input, int index) {
        return index < 0 || index >= input.length();
    }

    protected boolean isDelimiter(char c) {
        return this.table.containsKey(Character.valueOf(c));
    }

    protected boolean isRef(String input, int index) {
        return input.charAt(index) == '>' && index >= 1 && input.charAt(index - 1) == '=';
    }

    protected int parseLeftWithRef(String input, int index) {
        int left = 0;
        int i = index;
        while (i >= 0) {
            if (this.isDelimiter(input.charAt(i))) {
                if (this.isRef(input, i)) {
                    return this.parseLeftWithRef(input.substring(0, i - 1), i - 2);
                }
                left = i + 1;
                break;
            }
            --i;
        }
        return left;
    }

    @Override
    public int[] identifierInString(String input, int index) {
        int left = 0;
        int right = input.length() - 1;
        int[] ans = new int[2];
        if (this.isInvalidIndex(input, index)) {
            return null;
        }
        if (this.isDelimiter(input.charAt(index))) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        left = this.parseLeftWithRef(input, index);
        int i = index + 1;
        while (i < input.length()) {
            if (rDelims.indexOf(input.charAt(i)) > -1) {
                right = i - 1;
                break;
            }
            ++i;
        }
        ans[0] = left;
        ans[1] = right;
        return ans;
    }
}

