/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.ColumnBasedIdentifierParser;

public class IdentifierParserForOPMRPG
extends ColumnBasedIdentifierParser {
    private boolean _stringIndexIs0Based = false;
    private char _specifier;
    private boolean _is_comment = false;
    private boolean _is_indicator = false;
    private int _start_pos = 0;
    private int _end_pos = 0;

    public IdentifierParserForOPMRPG(boolean stringIndexIs0Based) {
        this._stringIndexIs0Based = stringIndexIs0Based;
    }

    @Override
    public int[] identifierInString(String line, int startChar) {
        int src_prefixlen;
        if (this._stringIndexIs0Based) {
            ++startChar;
        }
        int oldPrefixLength = src_prefixlen = this.getfPrefixLength();
        if (!this.isListing()) {
            src_prefixlen = IdentifierParserForOPMRPG.getSequenceNumberLength((String)line);
            this.setPrefixLength(src_prefixlen);
        }
        int char_idx = startChar - src_prefixlen;
        int linelen = ((String)line).length();
        line = (String)line + " ";
        linelen = ((String)line).length();
        boolean isSourceOPMRPGLineInfo = this.sourceOPMRPGLineInfo((String)line, char_idx);
        this.setPrefixLength(oldPrefixLength);
        if (!isSourceOPMRPGLineInfo) {
            return null;
        }
        if (this._start_pos == 0 && this._end_pos == 0) {
            return null;
        }
        int wordstart = this._start_pos;
        int wordend = this._end_pos;
        if (wordend + src_prefixlen + 1 > linelen) {
            wordend = linelen - src_prefixlen;
        }
        boolean colon_found = false;
        int i = char_idx;
        while (i <= this.Min(wordend, linelen - 1)) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ':') {
                wordend = i - 1;
                colon_found = true;
                break;
            }
            ++i;
        }
        if (!colon_found) {
            i = this.Min(char_idx, linelen - 1);
            while (i >= wordstart) {
                if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ':') {
                    wordstart = i + 1;
                    colon_found = true;
                    break;
                }
                --i;
            }
        }
        int bend_old = wordend;
        int bstart_old = wordstart;
        boolean right_paren_found = false;
        boolean left_paren_found = false;
        i = char_idx;
        while (i <= this.Min(bend_old, linelen - 1)) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == ')') {
                wordend = i - 1;
                right_paren_found = true;
                break;
            }
            ++i;
        }
        if (right_paren_found) {
            i = this.Min(char_idx, linelen - 1);
            while (i >= bstart_old) {
                if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) == '(') {
                    wordstart = i + 1;
                    left_paren_found = true;
                    break;
                }
                --i;
            }
        }
        if (!right_paren_found || !left_paren_found || char_idx < wordstart || char_idx > wordend) {
            wordstart = bstart_old;
            wordend = bend_old;
        }
        boolean nonblank = false;
        i = this.Min(wordend, linelen - 1);
        while (i >= wordstart) {
            if (((String)line).charAt(this.Min(i + src_prefixlen - 1, linelen - 1)) != ' ') {
                nonblank = true;
                break;
            }
            --i;
        }
        if (!nonblank) {
            return null;
        }
        wordstart += src_prefixlen;
        wordend = src_prefixlen + i - 1;
        if (!left_paren_found || ((String)line).charAt(this.Min(i, linelen - 1)) != ')') {
            ++wordend;
        }
        int[] ans = new int[]{wordstart - (this._stringIndexIs0Based ? 1 : 0), wordend - (this._stringIndexIs0Based ? 1 : 0)};
        return ans;
    }

    @Override
    public String doLanguageSpecifics(String token, String line, int index) {
        if (token == null || token.length() == 0) {
            return null;
        }
        String updatedToken = null;
        char specifier = this._specifier;
        boolean is_comment = this._is_comment;
        boolean is_indicator = this._is_indicator;
        int start_pos = this._start_pos;
        int end_pos = this._end_pos;
        int start_index = index - this.getfPrefixLength() - 1;
        this._is_comment = false;
        this._is_indicator = false;
        if (token.length() <= 2) {
            this.sourceOPMRPGLineInfo(line, start_index);
        }
        updatedToken = this.updateExpression(token, this._is_indicator);
        this._specifier = specifier;
        this._is_comment = is_comment;
        this._is_indicator = is_indicator;
        this._start_pos = start_pos;
        this._end_pos = end_pos;
        return updatedToken;
    }

    @Override
    public String updateExpression(String expression, boolean flag) {
        if (flag) {
            return "*IN" + expression;
        }
        String updatedExpression = null;
        int i = 0;
        while (i < expression.length()) {
            if (expression.charAt(i) == ',') {
                updatedExpression = expression.substring(0, i - 1) + "(" + expression.substring(i + 1, expression.length() - 1) + ")";
                break;
            }
            ++i;
        }
        if (updatedExpression == null) {
            return expression;
        }
        return updatedExpression;
    }

    @Override
    public boolean isIndicator() {
        return this._is_indicator;
    }

    /*
     * Unable to fully structure code
     */
    private boolean sourceOPMRPGLineInfo(String line, int char_idx) {
        block60: {
            block61: {
                src_prefixlen = this.getfPrefixLength();
                bstart = 0;
                bend = 0;
                len = line.length();
                if (--len - src_prefixlen <= 0) {
                    return false;
                }
                this._start_pos = 0;
                this._end_pos = 0;
                this._is_comment = false;
                this._is_indicator = false;
                if (len < 7) break block60;
                if (this.isListing()) break block61;
                if (line.charAt(this.Min(7 + src_prefixlen - 1, len)) == '*') {
                    this._is_comment = true;
                    return true;
                }
                this._specifier = line.charAt(this.Min(6 + src_prefixlen - 1, len));
                switch (line.charAt(this.Min(6 + src_prefixlen - 1, len))) {
                    case 'F': {
                        switch (char_idx) {
                            case 33: 
                            case 34: {
                                bstart = 33;
                                bend = 34;
                                this._is_indicator = true;
                                break block60;
                            }
                            case 71: 
                            case 72: {
                                bstart = 71;
                                bend = 72;
                                this._is_indicator = true;
                                break block60;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case 'E': {
                        if (char_idx < 27 || char_idx > 32) ** GOTO lbl37
                        bstart = 27;
                        bend = 32;
                        break block60;
lbl37:
                        // 1 sources

                        if (char_idx < 46 || char_idx > 51) ** GOTO lbl41
                        bstart = 46;
                        bend = 51;
                        break block60;
lbl41:
                        // 1 sources

                        return false;
                    }
                    case 'I': {
                        if (char_idx < 7 || char_idx > 14) ** GOTO lbl47
                        bstart = 7;
                        bend = 14;
                        break block60;
lbl47:
                        // 1 sources

                        if (char_idx < 21 || char_idx > 30) ** GOTO lbl51
                        bstart = 21;
                        bend = 30;
                        break block60;
lbl51:
                        // 1 sources

                        if (char_idx < 53 || char_idx > 58) ** GOTO lbl55
                        bstart = 53;
                        bend = 58;
                        break block60;
lbl55:
                        // 1 sources

                        switch (char_idx) {
                            case 19: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 65: 
                            case 67: 
                            case 69: {
                                bstart = char_idx;
                                bend = char_idx + 1;
                                this._is_indicator = true;
                                break block60;
                            }
                            case 20: 
                            case 60: 
                            case 62: 
                            case 64: 
                            case 66: 
                            case 68: 
                            case 70: {
                                bstart = char_idx - 1;
                                bend = char_idx;
                                this._is_indicator = true;
                                break block60;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case 'C': {
                        if (char_idx < 18 || char_idx > 27) ** GOTO lbl73
                        bstart = 18;
                        bend = 27;
                        break block60;
lbl73:
                        // 1 sources

                        if (char_idx < 33 || char_idx > 42) ** GOTO lbl77
                        bstart = 33;
                        bend = 42;
                        break block60;
lbl77:
                        // 1 sources

                        if (char_idx < 43 || char_idx > 48) ** GOTO lbl81
                        bstart = 43;
                        bend = 48;
                        break block60;
lbl81:
                        // 1 sources

                        switch (char_idx) {
                            case 7: 
                            case 10: 
                            case 13: 
                            case 16: 
                            case 54: 
                            case 56: 
                            case 58: {
                                bstart = char_idx;
                                bend = char_idx + 1;
                                this._is_indicator = true;
                                break block60;
                            }
                            case 8: 
                            case 11: 
                            case 14: 
                            case 17: 
                            case 55: 
                            case 57: 
                            case 59: {
                                bstart = char_idx - 1;
                                bend = char_idx;
                                this._is_indicator = true;
                                break block60;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case 'O': {
                        if (char_idx < 7 || char_idx > 14) ** GOTO lbl99
                        bstart = 7;
                        bend = 14;
                        break block60;
lbl99:
                        // 1 sources

                        if (char_idx < 32 || char_idx > 37) ** GOTO lbl103
                        bstart = 32;
                        bend = 37;
                        break block60;
lbl103:
                        // 1 sources

                        switch (char_idx) {
                            case 24: 
                            case 27: 
                            case 30: {
                                bstart = char_idx;
                                bend = char_idx + 1;
                                this._is_indicator = true;
                                break block60;
                            }
                            case 25: 
                            case 28: 
                            case 31: {
                                bstart = char_idx - 1;
                                bend = char_idx;
                                this._is_indicator = true;
                                break block60;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (line.charAt(this.Min(13 + src_prefixlen - 1, len)) == '*') {
                this._is_comment = true;
                return true;
            }
            this._specifier = line.charAt(this.Min(6 + src_prefixlen - 1, len));
            block23 : switch (line.charAt(this.Min(12 + src_prefixlen - 1, len))) {
                case 'F': {
                    switch (char_idx) {
                        case 39: 
                        case 40: {
                            bstart = 39;
                            bend = 40;
                            this._is_indicator = true;
                            break block23;
                        }
                        case 77: 
                        case 78: {
                            bstart = 77;
                            bend = 78;
                            this._is_indicator = true;
                            break block23;
                        }
                    }
                    return false;
                }
                case 'E': {
                    if (char_idx >= 33 && char_idx <= 38) {
                        bstart = 33;
                        bend = 38;
                        break;
                    }
                    if (char_idx >= 52 && char_idx <= 57) {
                        bstart = 52;
                        bend = 57;
                        break;
                    }
                    return false;
                }
                case 'I': {
                    if (char_idx >= 13 && char_idx <= 20) {
                        bstart = 13;
                        bend = 20;
                        break;
                    }
                    if (char_idx >= 27 && char_idx <= 36) {
                        bstart = 27;
                        bend = 36;
                        break;
                    }
                    if (char_idx >= 59 && char_idx <= 64) {
                        bstart = 59;
                        bend = 64;
                        break;
                    }
                    switch (char_idx) {
                        case 25: 
                        case 65: 
                        case 67: 
                        case 69: 
                        case 71: 
                        case 73: 
                        case 75: {
                            bstart = char_idx;
                            bend = char_idx + 1;
                            this._is_indicator = true;
                            break block23;
                        }
                        case 26: 
                        case 66: 
                        case 68: 
                        case 70: 
                        case 72: 
                        case 74: 
                        case 76: {
                            bstart = char_idx - 1;
                            bend = char_idx;
                            this._is_indicator = true;
                            break block23;
                        }
                    }
                    return false;
                }
                case 'C': {
                    if (char_idx >= 24 && char_idx <= 33) {
                        bstart = 24;
                        bend = 33;
                        break;
                    }
                    if (char_idx >= 39 && char_idx <= 48) {
                        bstart = 39;
                        bend = 48;
                        break;
                    }
                    if (char_idx >= 49 && char_idx <= 54) {
                        bstart = 49;
                        bend = 54;
                        break;
                    }
                    switch (char_idx) {
                        case 13: 
                        case 16: 
                        case 19: 
                        case 22: 
                        case 60: 
                        case 62: 
                        case 64: {
                            bstart = char_idx;
                            bend = char_idx + 1;
                            this._is_indicator = true;
                            break block23;
                        }
                        case 14: 
                        case 17: 
                        case 20: 
                        case 23: 
                        case 61: 
                        case 63: 
                        case 65: {
                            bstart = char_idx - 1;
                            bend = char_idx;
                            this._is_indicator = true;
                            break block23;
                        }
                    }
                    return false;
                }
                case 'O': {
                    if (char_idx >= 13 && char_idx <= 20) {
                        bstart = 13;
                        bend = 20;
                        break;
                    }
                    if (char_idx >= 38 && char_idx <= 43) {
                        bstart = 38;
                        bend = 43;
                        break;
                    }
                    switch (char_idx) {
                        case 30: 
                        case 31: {
                            bstart = 24;
                            bend = 25;
                            this._is_indicator = true;
                            break block23;
                        }
                        case 33: 
                        case 36: {
                            bstart = char_idx;
                            bend = char_idx + 1;
                            this._is_indicator = true;
                            break block23;
                        }
                        case 34: 
                        case 37: {
                            bstart = char_idx - 1;
                            bend = char_idx;
                            this._is_indicator = true;
                            break block23;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        this._start_pos = bstart;
        this._end_pos = bend;
        return true;
    }

    private int Min(int a, int b) {
        return a > b ? b : a;
    }
}

