/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DelimitersBasedIdentifierParser;

public class IdentifierParserForFreeFormRPG
extends DelimitersBasedIdentifierParser {
    private static final char[] delims = new char[]{'*', '<', '>', ':', '\'', '\"', ';', '+', '-', '=', '/', ' ', ',', '\\'};

    @Override
    public char[] getDelimiters() {
        return delims;
    }

    @Override
    public int[] identifierInString(String input, int index) {
        if (input == null || index + 1 > input.length()) {
            return null;
        }
        char[] buffer = input.toCharArray();
        return this.identifierInSubString(buffer, index, this.getfPrefixLength(), buffer.length - 1);
    }

    public int[] identifierInSubString(char[] buffer, int index, int start, int end) {
        int[] ans = new int[2];
        int left = start;
        int right = end;
        int i = index;
        while (i >= start) {
            if (this.table.containsKey(Character.valueOf(buffer[i]))) {
                left = i + 1;
                break;
            }
            --i;
        }
        if (left > index) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        i = index + 1;
        while (i <= end) {
            if (this.table.containsKey(Character.valueOf(buffer[i]))) {
                right = i - 1;
                break;
            }
            ++i;
        }
        int l_paren = 0;
        int r_paren = 0;
        int first_l_paren = 0;
        int last_r_paren = 0;
        int match_r_paren = 0;
        int i2 = left;
        while (i2 <= right) {
            if ('(' == buffer[i2]) {
                if (first_l_paren == 0) {
                    first_l_paren = i2;
                }
                ++l_paren;
            }
            if (')' == buffer[i2] && --l_paren == 0) {
                right = i2;
                match_r_paren = i2;
                break;
            }
            ++i2;
        }
        if (first_l_paren == 0) {
            for (i2 = right + 1; i2 <= end; ++i2) {
                if (' ' == buffer[i2]) continue;
                if ('(' != buffer[i2]) break;
                ++l_paren;
                first_l_paren = i2;
                right = i2;
                break;
            }
        }
        if (l_paren > 0) {
            i2 = right + 1;
            while (i2 <= end) {
                if ('(' == buffer[i2]) {
                    ++l_paren;
                }
                if (')' == buffer[i2] && --l_paren == 0) {
                    right = i2;
                    match_r_paren = i2;
                    break;
                }
                ++i2;
            }
        } else if (l_paren < 0) {
            i2 = right;
            while (i2 >= start) {
                if (')' == buffer[i2]) {
                    if (last_r_paren == 0) {
                        last_r_paren = i2;
                    }
                    ++r_paren;
                }
                if ('(' == buffer[i2] && --r_paren == 0) {
                    first_l_paren = i2;
                    match_r_paren = last_r_paren;
                    left = i2;
                    break;
                }
                --i2;
            }
        }
        if (l_paren > 0 || r_paren > 0) {
            if (l_paren > 0) {
                ans[0] = first_l_paren + 1;
                ans[1] = right;
            } else {
                ans[0] = left;
                ans[1] = last_r_paren - 1;
            }
            return ans;
        }
        if (end > match_r_paren && '.' == buffer[match_r_paren + 1]) {
            i2 = match_r_paren + 1;
            while (i2 <= end) {
                if (this.table.containsKey(Character.valueOf(buffer[i2])) || '(' == buffer[i2] || ')' == buffer[i2]) {
                    right = i2 - 1;
                    break;
                }
                ++i2;
            }
        }
        if (index > first_l_paren && index < match_r_paren) {
            return this.identifierInSubString(buffer, index, first_l_paren + 1, match_r_paren - 1);
        }
        if (index == first_l_paren || index == match_r_paren) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        if (left == first_l_paren) {
            int k;
            for (k = left - 1; k >= start && ' ' == buffer[k]; --k) {
            }
            if (k < start) {
                ans[0] = -1;
                ans[1] = -1;
                return ans;
            }
            int i3 = k - 1;
            while (i3 >= start) {
                if (this.table.containsKey(Character.valueOf(buffer[i3])) && ' ' != buffer[i3] || ' ' == buffer[i3] || '(' == buffer[i3] || ')' == buffer[i3]) {
                    left = i3 + 1;
                    break;
                }
                --i3;
            }
        }
        if ('%' == buffer[left]) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        if ('I' != buffer[left] && 'i' != buffer[left] || 'N' != buffer[left + 1] && 'n' != buffer[left + 1] || left < 1 || buffer[left - 1] == '*') {
            // empty if block
        }
        ans[0] = --left;
        ans[1] = right;
        return ans;
    }
}

