/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DelimitersBasedIdentifierParser;

public class IdentifierParserForASM
extends DelimitersBasedIdentifierParser {
    private static final char[] delims = new char[]{' ', '<', '(', '+', '$', '*', ')', ';', ':', '/', ',', '>', '=', '\"', '\'', '&', ';', '^', '\u00ac'};

    @Override
    public char[] getDelimiters() {
        return delims;
    }

    private boolean isInvalidIndex(String input, int index) {
        return index < 0 || index >= input.length();
    }

    private boolean isDelimiter(char c) {
        return this.table.containsKey(Character.valueOf(c));
    }

    private int parseLeft(String input, int index) {
        int left = 0;
        int i = index;
        while (i >= 0) {
            if (this.isDelimiter(input.charAt(i))) {
                left = i + 1;
                break;
            }
            --i;
        }
        return left;
    }

    @Override
    public int[] identifierInString(String input, int index) {
        int left = 0;
        int right = input.length() - 1;
        int[] ans = new int[2];
        if (this.isInvalidIndex(input, index)) {
            return null;
        }
        if (this.isDelimiter(input.charAt(index))) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        left = this.parseLeft(input, index);
        int i = index + 1;
        while (i < input.length()) {
            if (this.isDelimiter(input.charAt(i))) {
                right = i - 1;
                break;
            }
            ++i;
        }
        ans[0] = left;
        ans[1] = right;
        return ans;
    }
}

