/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.saverestore.ISaveRestore;
import com.ibm.debug.pdt.core.saverestore.ISaveRestoreConstants;
import com.ibm.debug.pdt.core.saverestore.SaveRestoreVersion;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggerPersistentProfile;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LocalFilter;
import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GlobalProfile2
extends DebuggerPersistentProfile
implements ISaveRestore,
ISaveRestoreConstants {
    public static final int CURRENT_VERSION = 20110620;
    public static final String FILE_NAME_PREFIX = "esro";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static final int SERVICE_VERSION = 0;
    private transient DebuggeeProcess fDebuggeeProcess = null;
    protected boolean fEntryBreakpointsAutoSetEnabled;
    protected boolean fDateBreakpointsEnabled;
    protected boolean fEntryBreakpointsAutoSetInstalled;
    protected int fDefaultMemoryRep;
    protected LocalFilter[] fLocalVarFilters;
    protected boolean fTeamProfile;
    private List<ERepGetPlaybackOptions> fPlaybackOptions;
    private boolean fZeroAddressBreakpointInstalled;
    private boolean fZeroAddressBreakpointEnabled;

    public GlobalProfile2() {
        super(20110620);
    }

    public GlobalProfile2(int version) {
        super(version);
    }

    public GlobalProfile2(DebugEngine from) {
        super(20110620);
        this.fDebuggeeProcess = from.getProcess();
        this.fEntryBreakpointsAutoSetEnabled = from.fAllEntryBreakpointsEnabled;
        this.fEntryBreakpointsAutoSetInstalled = from.fAllEntryBreakpointsInstalled;
        this.fDateBreakpointsEnabled = from.fDateBreakpointsEnabled;
        this.fDefaultMemoryRep = from._defaultMemoryRep;
        this.fLocalVarFilters = from._localFilters;
        this.fPlaybackOptions = ERepGetPlaybackOptions.getGlobalOptions(from.getEngineSession().getPlaybackOptions());
        this.fZeroAddressBreakpointInstalled = from.fZeroAddressBreakpointInstalled;
        this.fZeroAddressBreakpointEnabled = from.fZeroAddressBreakpointEnabled;
    }

    public GlobalProfile2(String attributes) {
        super(20110620);
        try {
            StringTokenizer tokens = new StringTokenizer(attributes, ",");
            this.fEntryBreakpointsAutoSetEnabled = Boolean.parseBoolean(tokens.nextToken());
            this.fDateBreakpointsEnabled = Boolean.parseBoolean(tokens.nextToken());
            this.fEntryBreakpointsAutoSetInstalled = Boolean.parseBoolean(tokens.nextToken());
            this.fDefaultMemoryRep = Integer.parseInt(tokens.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fTeamProfile = true;
    }

    public String getTeamDebugString() {
        StringBuilder attributes = new StringBuilder();
        attributes.append(this.fEntryBreakpointsAutoSetEnabled);
        attributes.append(',');
        attributes.append(this.fDateBreakpointsEnabled);
        attributes.append(',');
        attributes.append(this.fEntryBreakpointsAutoSetInstalled);
        attributes.append(',');
        attributes.append(this.fDefaultMemoryRep);
        return attributes.toString();
    }

    public boolean restore(DebugEngine to, int flags) {
        if (!this.isReadComplete() && !this.fTeamProfile) {
            return false;
        }
        boolean completeSuccess = true;
        if ((flags & 0x800000) != 0) {
            boolean bl = completeSuccess = completeSuccess ? this.restoreSpecialOptions(to) : false;
        }
        if ((flags & 0x400000) != 0) {
            boolean bl = completeSuccess = completeSuccess ? this.restoreLocalVarFilters(to) : false;
        }
        if ((flags & 0x200000) != 0) {
            completeSuccess = completeSuccess ? this.restorePlaybackOptions(to) : false;
        }
        return completeSuccess;
    }

    protected boolean restorePlaybackOptions(DebugEngine to) {
        if (this.fPlaybackOptions != null && to.getEngineSession().getPlaybackOptions() != null) {
            to.getEngineSession().updatePlaybackOptions(this.fPlaybackOptions);
        }
        return true;
    }

    protected boolean restoreLocalVarFilters(DebugEngine to) {
        if (this.fLocalVarFilters == null || this.fLocalVarFilters.length == 0) {
            return true;
        }
        LocalFilter[] filters = to.getLocalFilters();
        if (this.fLocalVarFilters.length != filters.length) {
            return false;
        }
        int i = 0;
        while (i < filters.length) {
            filters[i].setEnabled(this.fLocalVarFilters[i].isEnabled());
            ++i;
        }
        return true;
    }

    protected boolean restoreSpecialOptions(DebugEngine to) {
        to._defaultMemoryRep = this.fDefaultMemoryRep;
        to.fAllEntryBreakpointsInstalled = this.fEntryBreakpointsAutoSetInstalled || this.fEntryBreakpointsAutoSetEnabled;
        try {
            if (to.getEngineSession().supportsEntryAutoSet() || to.getEngineSession().supportsDateBreakpoints()) {
                to.setSpecialBreakpointsEnabled(this.fDateBreakpointsEnabled, this.fEntryBreakpointsAutoSetEnabled);
            }
        }
        catch (EngineRequestException e1) {
            return false;
        }
        to.fZeroAddressBreakpointInstalled = this.fZeroAddressBreakpointInstalled;
        try {
            if (to.getEngineSession().supportsZeroAddressBreakpoint() && to.fZeroAddressBreakpointInstalled) {
                to.setZeroAddressBreakpointEnabled(this.fZeroAddressBreakpointEnabled);
            } else if (this.fZeroAddressBreakpointInstalled) {
                to.fZeroAddressBreakpointEnabled = this.fZeroAddressBreakpointEnabled;
                to.saveDebugObjects();
            }
        }
        catch (EngineRequestException e1) {
            return false;
        }
        return true;
    }

    @Override
    public String getFileName() {
        StringBuilder baseName = new StringBuilder();
        String uniqueEngineKey = this.fDebuggeeProcess.getEngineSession().getUniqueEngineKey();
        String version = this.getSaveRestoreVersion().toString();
        baseName.append(FILE_NAME_PREFIX).append('@').append(uniqueEngineKey).append('.').append(version).append('.').append("xml");
        return baseName.toString();
    }

    @Override
    public SaveRestoreVersion getSaveRestoreVersion() {
        return new SaveRestoreVersion(1, 0, 0);
    }

    @Override
    protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    protected void writeObjects(ObjectOutputStream out) throws IOException {
    }
}

