/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepEntryGetNext;
import com.ibm.debug.pdt.internal.epdc.ERepEntryWhere;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntry;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqEntryWhere;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.HashMap;

public class Function
extends DebugModelObject
implements IDebugLocationProvider {
    private static final String NOFILE = "NO_FILE";
    private ERepEntryGetNext fEpdcEntry;
    private Part fPart;
    private int fBrkId = -1;
    private boolean fLocationsInitialized = false;
    private HashMap<ViewInformation, Location> fLocations = new HashMap();

    public Function(ERepEntryGetNext epdcEntry, Part part, DebugEngine debugEngine) {
        super(debugEngine);
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Creating Function : Name=" + epdcEntry.getName());
        }
        this.fEpdcEntry = epdcEntry;
        this.fPart = part;
    }

    protected final boolean isHidden() {
        String functionLabel = this.getName();
        return functionLabel.startsWith("_");
    }

    @Override
    public ViewFile getViewFile() {
        Location loc = this.getLocation();
        return loc.getViewFile();
    }

    public String getFileName() {
        ViewFile vf = this.getViewFile();
        if (vf != null) {
            return vf.getFileName();
        }
        return NOFILE;
    }

    public ViewFile getViewFile(ViewInformation viewInfo) {
        return this.getLocation(viewInfo).getViewFile();
    }

    public int getId() {
        return this.fEpdcEntry.getEntryID();
    }

    public String getName() {
        return this.fEpdcEntry.getName();
    }

    public String getReturnType() {
        return this.fEpdcEntry.getEntryReturnType();
    }

    public Part getPart() {
        return this.fPart;
    }

    EStdView getEStdView() {
        return this.fEpdcEntry.getEStdView();
    }

    public Location getLocation() {
        ViewInformation viewInfo = this.fPart.getCurrentView().getViewInformation();
        return this.getLocation(viewInfo);
    }

    public Location getLocation(ViewInformation viewInformation) {
        if (!this.fLocationsInitialized) {
            this.fLocationsInitialized = true;
            try {
                EStdView context = this.fEpdcEntry.getEStdView();
                Location loc = new Location(this.getDebugEngine().getProcess(), context);
                this.fLocations.put(loc.getView().getViewInformation(), loc);
            }
            catch (LocationConstructionException locationConstructionException) {
                // empty catch block
            }
        }
        if (!this.fLocations.containsKey(viewInformation)) {
            this.retrieveLocations();
        }
        return this.fLocations.get(viewInformation);
    }

    private void retrieveLocations() {
        DebugEngine engine = this.getDebugEngine();
        DebuggeeProcess process = engine.getProcess();
        EReqEntryWhere request = new EReqEntryWhere(this.getId(), this.getEngineSession());
        try {
            EStdView[] contexts;
            ERepEntryWhere reply = (ERepEntryWhere)engine.processRequest(request);
            EStdView[] eStdViewArray = contexts = reply.getContexts();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                EStdView context = eStdViewArray[n2];
                if (context != null && this.fPart.isViewValid(context.getViewNum())) {
                    ViewInformation vi = engine.getViewInformation((short)context.getViewNum());
                    try {
                        Location loc = new Location(process, context);
                        this.fLocations.put(vi, loc);
                    }
                    catch (LocationConstructionException e) {
                        PDTCoreUtils.logError(e);
                    }
                }
                ++n2;
            }
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logError(e);
        }
    }

    @Override
    public String getLabel() {
        String returnType = this.getReturnType();
        String functionName = this.getName();
        if (functionName == null || functionName.length() == 0) {
            functionName = PICLLabels.picl_stack_frame_label_unknown;
        }
        if (returnType == null || returnType.length() == 0) {
            return functionName;
        }
        return functionName + " : " + returnType;
    }

    public int getLineNumber() {
        return this.getLocation().getLineNumber();
    }

    public int getLastLineNumber() {
        ViewFile vf = this.getViewFile();
        Function nextFunction = vf.getNextFunction(this);
        if (nextFunction == null) {
            return vf.getLastLineNumber();
        }
        return nextFunction.getLineNumber() - 1;
    }

    public int getLineNumber(ViewInformation viewInfo) {
        Location loc = this.getLocation(viewInfo);
        return loc.getLineNumber();
    }

    public void toggleBreakpoint() throws EngineRequestException {
        if (this.fBrkId == -1) {
            this.setBreakpoint(true, false, new OptionalBreakpointData());
        } else {
            Breakpoint entryBreakpoint = this.getDebugEngine().getProcess().getBreakpoint(this.fBrkId);
            entryBreakpoint.remove();
        }
    }

    public void setBreakpoint(boolean enabled, boolean caseSensitive, OptionalBreakpointData optBpData) throws EngineRequestException {
        EReqBreakpointLocation request = Function.createBreakpointRequest(this.getId(), enabled, optBpData, this.getDebugEngine());
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public static EReqBreakpointLocation createBreakpointRequest(int functionId, boolean enabled, OptionalBreakpointData optBpData, DebugEngine debugEngine) throws EngineRequestException {
        EPDC_EngineSession engineSession = debugEngine.getEngineSession();
        if (!engineSession.supportsFunctionBreakpoints()) {
            throw new EngineRequestUnsupportedException();
        }
        short attribute = enabled ? (short)Short.MIN_VALUE : 0;
        attribute = (short)(attribute | optBpData.getSyncStopControlAttribute());
        EEveryClause clause = optBpData.getEEveryClause();
        EStdExpression2 conditionalExpr = null;
        if (!PDTCoreUtils.isEmpty(optBpData.getStopIfExpression())) {
            conditionalExpr = optBpData.getEStdExpression2(EStdView.EMPTY_VIEW, engineSession);
        }
        int threadId = optBpData.getThreadId(engineSession, debugEngine);
        EReqBreakpointEntry request = new EReqBreakpointEntry(attribute, clause, null, null, null, null, conditionalExpr, threadId, functionId, optBpData.getBreakpointAction(), engineSession);
        return request;
    }

    void setBrkId(int id) {
        this.fBrkId = id;
    }

    void removeBrkId() {
        this.fBrkId = -1;
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        if (o instanceof Function) {
            return this.getName().compareTo(((Function)o).getName());
        }
        return 0;
    }

    @Override
    protected void doCleanupDetails() {
    }

    void updateEntry(ERepEntryGetNext entry) {
        this.fEpdcEntry = entry;
    }
}

