/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionEndedEvent;
import com.ibm.debug.pdt.internal.core.model.IExpressionEventListener;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionDisable;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionEnable;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionFree;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class ExpressionBase
extends DebugModelObject
implements Serializable {
    private transient DebuggeeProcess _owningProcess;
    protected transient Hashtable<Integer, ExprNodeBase> fNodes;
    private transient boolean fDisposed = false;
    private transient boolean fSuppressChangeFlags = false;
    protected ECPMonitorExprBase _epdcMonitoredExpr;
    @Deprecated
    protected HashMap<String, Representation> _savedReps;
    private static final long serialVersionUID = 20050314L;

    boolean isSuppressChangeFlags() {
        return this.fSuppressChangeFlags;
    }

    public void setSuppressChangeFlags(boolean suppress) {
        this.fSuppressChangeFlags = suppress;
    }

    ExpressionBase(DebuggeeProcess owningProcess, ECPMonitorExprBase epdcMonitoredExpr, DebugEngine debugEngine) {
        super(debugEngine);
        this._epdcMonitoredExpr = epdcMonitoredExpr;
        this._owningProcess = owningProcess;
    }

    protected abstract void update(ECPMonitorExprBase var1);

    public ExprNodeBase getRootNode() {
        if (this.hasChildren()) {
            try {
                return (ExprNodeBase)this.getChildren()[0];
            }
            catch (EngineRequestException e) {
                return null;
            }
        }
        return null;
    }

    public int getThreadID() {
        return this._epdcMonitoredExpr.getThreadID();
    }

    public DebuggeeThread getThread() {
        DebuggeeThread thread = this._owningProcess.getThread(this._epdcMonitoredExpr.getThreadID());
        if (thread == null) {
            return this._owningProcess.getStoppingThread();
        }
        return thread;
    }

    public int getId() {
        return this._epdcMonitoredExpr.getId();
    }

    public DebuggeeProcess getOwningProcess() {
        return this._owningProcess;
    }

    public void addEventListener(IExpressionEventListener eventListener) {
        this.addListener(eventListener);
    }

    public void remove() throws EngineRequestException {
        if (this.fDisposed) {
            return;
        }
        this.fDisposed = true;
        EReqExpressionFree request = new EReqExpressionFree(this.getId(), this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    void prepareToDie() {
        this.addEvent(new ExpressionEndedEvent(this, this));
    }

    public void disable() throws EngineRequestException {
        if (!this.getEngineSession().supportsEnableDisableMonitors()) {
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        EReqExpressionDisable request = new EReqExpressionDisable(this.getId(), this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    public void enable() throws EngineRequestException {
        if (!this.getEngineSession().supportsEnableDisableMonitors()) {
            return;
        }
        if (this.isEnabled()) {
            return;
        }
        EReqExpressionEnable request = new EReqExpressionEnable(this.getId(), this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    protected boolean isDisabled() {
        return this._epdcMonitoredExpr.isDisabled();
    }

    public boolean isEnabled() {
        return this._epdcMonitoredExpr.isEnabled();
    }

    public boolean isPending() {
        return this._epdcMonitoredExpr.isPending();
    }

    public boolean isDeferred() {
        return this._epdcMonitoredExpr.isDeferred();
    }

    public boolean isReadOnly() {
        return this._epdcMonitoredExpr.isReadOnly();
    }

    public boolean isLocalVariable() {
        return this._epdcMonitoredExpr.isLocalVariable();
    }

    public boolean isPopup() {
        return this._epdcMonitoredExpr.isPopup();
    }

    protected ECPMonitorExprBase getEPDCMonitoredExpression() {
        return this._epdcMonitoredExpr;
    }

    public short getMonitorType() {
        return this._epdcMonitoredExpr.getType();
    }

    public Location getLocation() {
        try {
            return new Location(this._owningProcess, this._epdcMonitoredExpr.getContext());
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    public int getStatementNumber() {
        String stmtField = this._epdcMonitoredExpr.getStmtNumber();
        if (stmtField == null) {
            return 0;
        }
        try {
            return Integer.parseInt(stmtField);
        }
        catch (NumberFormatException excp) {
            PDTCoreUtils.logError(excp);
            return 0;
        }
    }

    void restore(DebuggeeProcess targetProcess) throws EngineRequestException {
        String stmtNum = null;
        if (targetProcess.getEngineSession().supportsStatementBreakpoints()) {
            stmtNum = this._epdcMonitoredExpr.getStmtNumber();
        }
        byte attributes = -64;
        EStdView fromLocation = this._epdcMonitoredExpr.getContext();
        EStdView toLocation = new EStdView(0, fromLocation.getViewNum(), 0, fromLocation.getLineNumber());
        EStdExpression2 expression = new EStdExpression2(toLocation, this.getExpressionString(), this.getThreadID(), 0, targetProcess.getEngineSession());
        EReqExpression request = new EReqExpression(attributes, this._epdcMonitoredExpr.getType(), expression, this._epdcMonitoredExpr.getModuleName(), this._epdcMonitoredExpr.getPartName(), this._epdcMonitoredExpr.getFileName(), stmtNum, targetProcess.getEngineSession());
        this.addProperties(request);
        targetProcess.getDebugEngine().processRequest(request);
    }

    protected void addNode(ExprNodeBase node, ExprNodeBase parentNode) {
        if (this.fNodes == null) {
            this.fNodes = new Hashtable();
        }
        this.fNodes.put(node.getId(), node);
        if (parentNode == null) {
            this.addChild(node, false);
        } else {
            parentNode.addChild(node, false);
        }
    }

    protected void putNode(ExprNodeBase node, ExprNodeBase parentNode, int index) {
        this.fNodes.put(node.getId(), node);
        parentNode.putChild(node, index);
    }

    protected ExprNodeBase findNode(int nodeID) {
        if (this.fNodes == null) {
            return null;
        }
        return this.fNodes.get(nodeID);
    }

    protected int removeNode(ExprNodeBase node) {
        node.removeAllChildren();
        if (node.getParentElement() == null) {
            this.removeChild(node, false);
            return -1;
        }
        return node.getParentElement().removeChild(node, false);
    }

    protected void replaceNode(ExprNodeBase oldNode, ExprNodeBase newNode) {
        int idx = this.removeNode(oldNode);
        if (idx < 0) {
            this.addNode(newNode, (ExprNodeBase)oldNode.getParentElement());
        } else {
            this.putNode(newNode, (ExprNodeBase)oldNode.getParentElement(), idx);
        }
        if (!this.isSuppressChangeFlags()) {
            newNode.setChanged();
        }
    }

    public String getExpressionString() {
        return this._epdcMonitoredExpr.getExpressionString();
    }

    void removeNodeID(int nodeID) {
        this.fNodes.remove(nodeID);
    }

    @Override
    public void fireChangeEvent(int detail) {
        if (this.getThread().isSuspended()) {
            super.fireChangeEvent(detail);
        }
    }

    abstract void addProperties(EPDC_Request var1);

    abstract void setSavedRep(String var1, int var2);

    abstract void removeSavedRep(String var1);

    public boolean isSaveInProfile() {
        return this._epdcMonitoredExpr.isSaveable();
    }
}

