/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNode;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionChangedEvent;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr2;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionNodeAction;
import com.ibm.debug.pdt.internal.epdc.EStdExprNode;
import java.util.ArrayDeque;
import java.util.HashMap;

public class Expression2
extends ExpressionBase {
    private static final long serialVersionUID = 20050525L;
    protected HashMap<String, Integer> fSavedReps;
    private transient ArrayDeque<EPDC_Request> fPendingRequests;
    private static final transient EPDC_Request[] EMPTYREQUESTS = new EPDC_Request[0];

    public Expression2(DebuggeeProcess owningProcess, ECPMonitorExpr2 epdcMonitoredExpr, HashMap<String, Integer> savedReps, DebugEngine debugEngine) {
        super(owningProcess, epdcMonitoredExpr, debugEngine);
        this.fSavedReps = savedReps;
        this.update(epdcMonitoredExpr);
    }

    @Override
    protected void update(ECPMonitorExprBase epdcMonitoredExpr) {
        this._epdcMonitoredExpr = epdcMonitoredExpr;
        ECPMonitorExpr2 newExpr = (ECPMonitorExpr2)this._epdcMonitoredExpr;
        EStdExprNode[] nodes = newExpr.getExprNodes();
        if (nodes.length == 0 && newExpr.hasChanged()) {
            ExprNodeBase rootNode = this.getRootNode();
            if (rootNode != null) {
                rootNode.fireChangeEvent(256);
            }
        } else {
            int i = 0;
            while (i < nodes.length) {
                EStdExprNode chgdNode = nodes[i];
                ExprNodeBase oldNode = this.findNode(chgdNode.getId());
                if (oldNode == null) {
                    parentNode = this.findNode(chgdNode.getParentID());
                    newNode = this.isLocalVariable() ? new ExprNodeLocal(chgdNode, parentNode, this, this.getDebugEngine()) : new ExprNode(chgdNode, parentNode, this, this.getDebugEngine());
                    this.addNode(newNode, parentNode);
                    this.restoreReps(newNode);
                    if (newNode.isRootNode()) {
                        newNode.fireCreationEvent();
                    }
                } else if (chgdNode.isNodeReplaced()) {
                    parentNode = this.findNode(oldNode.getParentID());
                    newNode = this.isLocalVariable() ? new ExprNodeLocal(chgdNode, parentNode, this, this.getDebugEngine()) : new ExprNode(chgdNode, parentNode, this, this.getDebugEngine());
                    this.replaceNode(oldNode, newNode);
                    if (newNode.isRootNode()) {
                        this.fireChangeEvent(512);
                        if (this.isLocalVariable()) {
                            this.addEvent(new ExpressionChangedEvent(this, this));
                        }
                    } else {
                        newNode.getParentElement().fireChangeEvent(512);
                    }
                } else if (chgdNode.isNodeUpdated()) {
                    oldNode.update(chgdNode);
                    oldNode.fireChangeEvent(256);
                }
                ++i;
            }
        }
    }

    private void restoreReps(ExprNodeBase node) {
        int savedRepIndex = this.getSavedRep(node.getKey());
        if (savedRepIndex != -1) {
            try {
                EPDC_Request request = node.changeRepresentation(node.getRepresentations()[savedRepIndex], false);
                if (request == null) {
                    this.removeSavedRep(node.getKey());
                } else {
                    this.addPendingRequest(request);
                }
            }
            catch (EngineRequestException e) {
                this.removeSavedRep(node.getKey());
            }
        }
    }

    public String getActionLabel(int idx) {
        return ((ECPMonitorExpr2)this._epdcMonitoredExpr).getActionLabel(idx);
    }

    public void doNodeAction(int nodeID, int actionID) throws EngineRequestException {
        EReqExpressionNodeAction request = new EReqExpressionNodeAction(this.getId(), nodeID, actionID, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
        ((PDTDebugTarget)this.getDebugTarget()).markMemBlksChanged(true);
    }

    @Override
    protected void doCleanupDetails() {
        if (this.fPendingRequests != null) {
            this.fPendingRequests.clear();
        }
    }

    private void addPendingRequest(EPDC_Request request) {
        if (request == null) {
            return;
        }
        if (this.fPendingRequests == null) {
            this.fPendingRequests = new ArrayDeque();
        }
        this.fPendingRequests.add(request);
    }

    EPDC_Request[] getPendingRequests() {
        if (this.fPendingRequests == null) {
            return EMPTYREQUESTS;
        }
        EPDC_Request[] requests = this.fPendingRequests.toArray(new EPDC_Request[this.fPendingRequests.size()]);
        this.fPendingRequests.clear();
        return requests;
    }

    @Override
    protected void setSavedRep(String key, int repIndex) {
        if (this.fSavedReps == null) {
            if (repIndex == -1) {
                return;
            }
            this.fSavedReps = new HashMap();
        }
        if (repIndex == -1) {
            this.fSavedReps.remove(key);
        } else {
            this.fSavedReps.put(key, repIndex);
        }
    }

    public int getSavedRep(String key) {
        if (this.fSavedReps != null && this.fSavedReps.containsKey(key)) {
            return this.fSavedReps.get(key);
        }
        return -1;
    }

    protected void setSaveReps(HashMap<String, Integer> reps) {
        this.fSavedReps = reps;
    }

    @Override
    void removeSavedRep(String key) {
        if (this.fSavedReps != null) {
            this.fSavedReps.remove(key);
        }
    }

    protected HashMap<String, Integer> getSavedReps() {
        return this.fSavedReps;
    }

    @Override
    void addProperties(EPDC_Request request) {
        request.putProperty(new EPDC_Request.EProperty(7, this.fSavedReps));
    }
}

