/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.ArrayExprNode;
import com.ibm.debug.pdt.internal.core.model.ArrayExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.ClassExprNode;
import com.ibm.debug.pdt.internal.core.model.ClassExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionChangedEvent;
import com.ibm.debug.pdt.internal.core.model.PointerExprNode;
import com.ibm.debug.pdt.internal.core.model.PointerExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.ScalarExprNode;
import com.ibm.debug.pdt.internal.core.model.ScalarExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.StructExprNode;
import com.ibm.debug.pdt.internal.core.model.StructExprNodeLocal;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdTreeNode;
import java.util.ArrayList;

public class Expression
extends ExpressionBase {
    private static final long serialVersionUID = 20051011L;

    Expression(DebuggeeProcess owningProcess, ECPMonitorExpr epdcMonitoredExpr, DebugEngine debugEngine) {
        super(owningProcess, epdcMonitoredExpr, debugEngine);
        this.update(epdcMonitoredExpr);
    }

    @Override
    protected void update(ECPMonitorExprBase monitorExpr) {
        this._epdcMonitoredExpr = monitorExpr;
        ECPMonitorExpr newExpr = (ECPMonitorExpr)monitorExpr;
        ArrayList<EStdTreeNode> allNodes = new ArrayList<EStdTreeNode>();
        EStdTreeNode node = newExpr.getExprTree();
        allNodes.add(node);
        node.addNodes(allNodes);
        if (allNodes.isEmpty() && newExpr.hasChanged()) {
            ExprNodeBase rootNode = this.getRootNode();
            if (rootNode != null) {
                rootNode.fireChangeEvent(256);
            }
        } else {
            if (this.getRootNode() != null && node.getId() != this.getRootNode().getId()) {
                this.removeNode(this.getRootNode());
            }
            for (EStdTreeNode newTreeNode : allNodes) {
                ExprNodeBase oldNode = this.findNode(newTreeNode.getId());
                if (newTreeNode.isRootNode() && this.getRootNode() != null) {
                    oldNode = this.getRootNode();
                }
                if (oldNode == null) {
                    ExprNodeBase parentNode = this.findNode(newTreeNode.getParentID());
                    ExprNodeBase newNode = this.createNode(newTreeNode, parentNode);
                    this.addNode(newNode, parentNode);
                    if (!newNode.isRootNode()) continue;
                    newNode.fireCreationEvent();
                    continue;
                }
                if (newTreeNode.getTreeNodeData().getGenericNodeType() != ((EStdTreeNode)oldNode.getInternalNode()).getTreeNodeData().getGenericNodeType()) {
                    ExprNodeBase newNode = this.createNode(newTreeNode, (ExprNodeBase)oldNode.getParentElement());
                    this.replaceNode(oldNode, newNode);
                    if (newNode.isRootNode()) {
                        this.fireChangeEvent(512);
                        if (!this.isLocalVariable()) continue;
                        this.addEvent(new ExpressionChangedEvent(this, this));
                        continue;
                    }
                    newNode.getParentElement().fireChangeEvent(512);
                    continue;
                }
                if (!oldNode.update(newTreeNode)) continue;
                oldNode.fireChangeEvent(256);
            }
        }
    }

    private ExprNodeBase createNode(EStdTreeNode node, ExprNodeBase parentNode) {
        ExprNodeBase newNode = null;
        switch (node.getTreeNodeData().getGenericNodeType()) {
            case 3: {
                if (this.isLocalVariable()) {
                    newNode = new ScalarExprNodeLocal(node, parentNode, this, this.getDebugEngine());
                    break;
                }
                newNode = new ScalarExprNode(node, parentNode, this, this.getDebugEngine());
                break;
            }
            case 4: {
                if (this.isLocalVariable()) {
                    newNode = new StructExprNodeLocal(node, parentNode, this, this.getDebugEngine());
                    break;
                }
                newNode = new StructExprNode(node, parentNode, this, this.getDebugEngine());
                break;
            }
            case 11: {
                if (this.isLocalVariable()) {
                    newNode = new ClassExprNodeLocal(node, parentNode, this, this.getDebugEngine());
                    break;
                }
                newNode = new ClassExprNode(node, parentNode, this, this.getDebugEngine());
                break;
            }
            case 5: {
                if (this.isLocalVariable()) {
                    newNode = new ArrayExprNodeLocal(node, parentNode, this, this.getDebugEngine());
                    break;
                }
                newNode = new ArrayExprNode(node, parentNode, this, this.getDebugEngine());
                break;
            }
            case 8: {
                if (this.isLocalVariable()) {
                    newNode = new PointerExprNodeLocal(node, parentNode, this, this.getDebugEngine());
                    break;
                }
                newNode = new PointerExprNode(node, parentNode, this, this.getDebugEngine());
                break;
            }
            default: {
                return null;
            }
        }
        return newNode;
    }

    @Override
    protected void doCleanupDetails() {
    }

    @Override
    void addProperties(EPDC_Request request) {
    }

    @Override
    void setSavedRep(String key, int repIndex) {
    }

    @Override
    void removeSavedRep(String key) {
    }
}

