/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracerTarget;
import com.ibm.debug.pdt.internal.core.IPartitionCache;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.NodeValue;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetNodeExpression;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionRepTypeSet;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionValueModify;
import com.ibm.debug.pdt.internal.epdc.EReqGetNodeExpression;
import com.ibm.debug.pdt.internal.epdc.EStdExprNodeBase;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class ExprNodeBase
extends DebugModelObject
implements IVariable,
IPartitionCache {
    protected static final Representation[] EMPTYREPRESENTATIONS = new Representation[0];
    protected Representation[] _availableReps = EMPTYREPRESENTATIONS;
    private String fKey;
    protected EStdExprNodeBase _node;
    protected ExpressionBase _monitoredExpr;
    private IValue fValue;
    private int fEditOffset;
    protected Object fNodeChildLock = new Object();
    private Object[] fPartitionCache = null;
    static final int INITIALNUMBERINDEXTOTRACK = 100;
    private Map<Integer, PDTDebugElement> fChildIndexMap = null;

    protected ExprNodeBase(EStdExprNodeBase node, ExprNodeBase parentNode, ExpressionBase expr, DebugEngine debugEngine) {
        super(debugEngine, parentNode);
        this._monitoredExpr = expr;
        this._node = node;
        this.fKey = parentNode == null ? String.valueOf(this.getChildNumber()) : parentNode.fKey + "," + this.getChildNumber();
    }

    protected void createChildIndexMap() {
        if (this.fChildIndexMap != null) {
            this.fChildIndexMap.clear();
        }
        this.fChildIndexMap = new HashMap<Integer, PDTDebugElement>(100);
    }

    public EPDC_Request changeRepresentation(Representation newRep, boolean execute) throws EngineRequestException {
        if (newRep == null || newRep.equals(this.getCurrentRepresentation())) {
            this._monitoredExpr.removeSavedRep(this.getKey());
            return null;
        }
        int repIndex = -1;
        int i = 0;
        while (i < this._availableReps.length) {
            if (this._availableReps[i].equals(newRep)) {
                repIndex = i;
                break;
            }
            ++i;
        }
        if (repIndex == -1) {
            return null;
        }
        int id = this._monitoredExpr.getId();
        EReqExpressionRepTypeSet request = new EReqExpressionRepTypeSet(id, this._node.getId(), (short)(repIndex + 1), this.getEngineSession());
        this._monitoredExpr.setSavedRep(this.getKey(), repIndex);
        if (execute) {
            try {
                try {
                    this._monitoredExpr.setSuppressChangeFlags(true);
                    this.getDebugEngine().processRequest(request);
                }
                catch (EngineRequestException e) {
                    this._monitoredExpr.removeSavedRep(this.getKey());
                    throw e;
                }
            }
            finally {
                this._monitoredExpr.setSuppressChangeFlags(false);
            }
            return null;
        }
        return request;
    }

    public String getName() {
        return this._node.getName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this._node.getType();
    }

    public int getId() {
        return this._node.getId();
    }

    public int getParentID() {
        return this._node.getParentID();
    }

    public int getChildNumber() {
        return this._node.getChildNum();
    }

    public abstract Representation getCurrentRepresentation();

    protected void setupRepresentations(int[] reps) {
        if (reps.length == 0 || reps[0] < 1) {
            return;
        }
        this._availableReps = new Representation[reps.length];
        int i = 0;
        while (i < reps.length) {
            this._availableReps[i] = this.getDebugEngine().getRepresentation(reps[i]);
            ++i;
        }
    }

    public Representation[] getRepresentations() {
        return this._availableReps;
    }

    public int getLanguageID() {
        return this._node.getLanguageID();
    }

    public int getTypeIndex() {
        return this._node.getTypeIndex();
    }

    public String getKey() {
        return this.fKey;
    }

    public abstract String getRawValueString();

    public String getValueString() {
        String valueString = this.getRawValueString();
        try {
            if (this.getEngineSession().hostBIDIStringsAreInVisualFormat()) {
                valueString = PDTCorePlugin.getBIDIEngine().convertVisualToLogical(valueString, true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return PDTCoreUtils.getNullFreeDisplayString(valueString);
    }

    public void setValue(IValue value) throws DebugException {
    }

    public void setRawValue(String expression) throws DebugException {
        try {
            if (this.getDebugTarget() instanceof IPDTDebugTracerTarget) {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = ((IPDTDebugTracerTarget)this.getDebugTarget()).getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceUserAction(this, (short)0, new String[]{expression});
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
        int id = this._monitoredExpr.getId();
        EReqExpressionValueModify request = new EReqExpressionValueModify(id, this._node.getId(), expression, this.getEngineSession());
        try {
            this.getDebugEngine().processRequest(request);
        }
        catch (EngineRequestException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
        }
        ((PDTDebugTarget)this.getDebugTarget()).markMemBlksChanged(true);
    }

    public void setValue(String expression) throws DebugException {
        if (this.getEngineSession().hostBIDIStringsAreInVisualFormat()) {
            expression = PDTCorePlugin.getBIDIEngine().convertLogicalToVisual(expression);
        }
        this.setRawValue(expression);
    }

    public boolean supportsValueModification() {
        if (this._node.isReadOnly()) {
            return false;
        }
        return !this._monitoredExpr.isReadOnly() && !this._monitoredExpr.isDisabled() && !this._monitoredExpr.isDeferred();
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isChanged();
    }

    public boolean isAllocated() {
        return true;
    }

    public abstract int getNumChildren();

    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            this.fValue = new NodeValue(this);
        }
        return this.fValue;
    }

    public boolean isRootNode() {
        return this._node.isRootNode();
    }

    protected abstract boolean update(EStdExprNodeBase var1);

    public ExpressionBase getExpression() {
        return this._monitoredExpr;
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        if (o instanceof ExprNodeBase) {
            return this.getName().compareTo(((ExprNodeBase)o).getName());
        }
        return 0;
    }

    public EStdExprNodeBase getInternalNode() {
        return this._node;
    }

    public int getBaseIndex() {
        return this._node.getBaseIndex();
    }

    public int getEditOffset() {
        return this.fEditOffset;
    }

    public void setEditOffset(int offset) {
        this.fEditOffset = offset;
    }

    @Override
    public void addChild(PDTDebugElement child, boolean fireCreationEvent) {
        if (this.fChildIndexMap != null) {
            this.fChildIndexMap.put(((ExprNodeBase)child).getChildNumber(), child);
        }
        super.addChild(child, fireCreationEvent);
    }

    @Override
    public void putChild(PDTDebugElement child, int idx) {
        if (this.fChildIndexMap != null) {
            this.fChildIndexMap.put(((ExprNodeBase)child).getChildNumber(), child);
        }
        super.putChild(child, idx);
    }

    @Override
    public int removeChild(PDTDebugElement child, boolean fireEvent) {
        if (this.fChildIndexMap != null) {
            this.fChildIndexMap.remove(((ExprNodeBase)child).getChildNumber());
        }
        return super.removeChild(child, fireEvent);
    }

    @Override
    public void removeAllChildren() {
        if (this.fChildIndexMap != null) {
            this.fChildIndexMap.clear();
        }
        super.removeAllChildren();
    }

    public PDTDebugElement getChild(int offset) {
        if (!this.hasChildren() || this.fChildIndexMap == null) {
            return null;
        }
        return this.fChildIndexMap.get(offset);
    }

    public PDTDebugElement[] getChildren(int offset, int length) {
        if (!this.hasChildren()) {
            return EMPTYCHILDREN;
        }
        PDTDebugElement[] children = new PDTDebugElement[length];
        boolean retrieve_attempted = false;
        int i = offset;
        int j = 0;
        while (j < length) {
            children[j] = this.getChild(i);
            if (children[j] == null && !retrieve_attempted) {
                retrieve_attempted = true;
                try {
                    this.retrieveNodes(offset, length);
                }
                catch (EngineRequestException engineRequestException) {
                    // empty catch block
                }
                children[j] = this.getChild(i);
            }
            ++i;
            ++j;
        }
        return children;
    }

    void retrieveNodes(int startNode, int numNodes) throws EngineRequestException {
    }

    @Override
    protected void doCleanupDetails() {
        this._monitoredExpr.removeNodeID(this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isChildrenRetrieved() {
        Object object = this.fNodeChildLock;
        synchronized (object) {
            block4: {
                if (this.fChildIndexMap == null || this.getNumChildren() != this.fChildIndexMap.size()) break block4;
                return true;
            }
            return false;
        }
    }

    public String getNodeExpression(boolean isAddress) throws EngineRequestException {
        try {
            if (this.getEngineSession().supportsNewMonitorFormat() && this.getEngineSession().supportsGetNodeExpression()) {
                EReqGetNodeExpression request = new EReqGetNodeExpression(this._monitoredExpr.getId(), this.getId(), this.getEngineSession());
                ERepGetNodeExpression reply = (ERepGetNodeExpression)this.getDebugEngine().processRequest(request);
                return reply.getExpression();
            }
        }
        catch (EngineRequestException request) {
            // empty catch block
        }
        if (this.isC() || this.isCPP() || this.isUPC() || this.isFORTRAN() || this.isRPG()) {
            return this.getNodeExpression(null, false);
        }
        if (this.isPLI()) {
            return this.getName();
        }
        if (isAddress) {
            if (this.isRootNode()) {
                return this.getExpression().getExpressionString();
            }
            String value = this.getValueString();
            if (value.startsWith("0x")) {
                return value;
            }
            try {
                BigInteger address = new BigInteger(value);
                return "0x" + address.toString(16);
            }
            catch (NumberFormatException nfe) {
                return value;
            }
        }
        return this.getExpression().getExpressionString();
    }

    private String getNodeExpression(String expression, boolean childIsArray) {
        if (this.isRootNode()) {
            if (childIsArray) {
                return expression == null ? this.getExpression().getExpressionString() : expression;
            }
            return expression == null ? this.getExpression().getExpressionString() : this.getExpression().getExpressionString() + (String)expression;
        }
        ExprNodeBase parentNode = (ExprNodeBase)this.getParentElement();
        Object nodeName = this.getName();
        if (this.isArrayNode()) {
            if (childIsArray) {
                return parentNode.getNodeExpression((String)expression, true);
            }
            return parentNode.getNodeExpression((String)(expression == null ? nodeName : (String)nodeName + (String)expression), true);
        }
        if (childIsArray) {
            expression = this.getStructAccessor() + (String)expression;
            return parentNode.getNodeExpression((String)expression, false);
        }
        nodeName = this.getStructAccessor() + (String)nodeName;
        return parentNode.getNodeExpression((String)(expression == null ? nodeName : (String)nodeName + (String)expression), false);
    }

    public boolean isArrayNode() {
        if (this.isC() || this.isCPP() || this.isUPC()) {
            return this.getName().endsWith("]");
        }
        if (this.isFORTRAN() || this.isRPG()) {
            return this.getName().endsWith(")");
        }
        return false;
    }

    public String getStructAccessor() {
        if (this.isC() || this.isCPP() || this.isUPC() || this.isRPG()) {
            return ".";
        }
        if (this.isFORTRAN()) {
            return "%";
        }
        return "";
    }

    public boolean isC() {
        return this.getLanguageID() == 1;
    }

    public boolean isCPP() {
        return this.getLanguageID() == 2;
    }

    public boolean isUPC() {
        return this.getLanguageID() == 15;
    }

    public boolean isFORTRAN() {
        return this.getLanguageID() == 11;
    }

    public boolean isPLI() {
        return this.getLanguageID() == 4;
    }

    public boolean isRPG() {
        return this.getLanguageID() == 5;
    }

    @Override
    public Object[] getPartitionCache() {
        return this.fPartitionCache;
    }

    @Override
    public void setPartitionCache(Object[] partitions) {
        this.fPartitionCache = partitions;
    }

    @Override
    public boolean hasPartitionCache() {
        return this.fPartitionCache != null;
    }

    boolean isSuppressChangeFlags() {
        return this._monitoredExpr.isSuppressChangeFlags();
    }
}

