/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.Expression2;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionSubTree;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionSubTreeDelete;
import com.ibm.debug.pdt.internal.epdc.EStdAction;
import com.ibm.debug.pdt.internal.epdc.EStdExprNode;
import com.ibm.debug.pdt.internal.epdc.EStdExprNodeBase;

public class ExprNode
extends ExprNodeBase {
    public ExprNode(EStdExprNode node, ExprNodeBase parentNode, Expression2 expr, DebugEngine debugEngine) {
        super(node, parentNode, expr, debugEngine);
        this.setupRepresentations(node.getReps());
        if (this.getNumChildren() > 0) {
            this.createChildIndexMap();
        }
    }

    @Override
    public String getRawValueString() {
        return ((EStdExprNode)this._node).getValueString();
    }

    public EStdAction[] getActions() {
        return ((EStdExprNode)this._node).getActions();
    }

    @Override
    public int getNumChildren() {
        return this._node.getNumChildren();
    }

    @Override
    public boolean hasChildren() {
        if (this._monitoredExpr.isEnabled()) {
            return this._node.hasChildren();
        }
        return this.isChildrenRetrieved();
    }

    @Override
    public Representation getCurrentRepresentation() {
        return this._availableReps[((EStdExprNode)this._node).getCurrentRep()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PDTDebugElement[] getChildren() throws EngineRequestException {
        if (!this.hasChildren()) {
            return EMPTYCHILDREN;
        }
        Object object = this.fNodeChildLock;
        synchronized (object) {
            if (!this.isChildrenRetrieved()) {
                this.retrieveNodes(this.getBaseIndex(), this.getNumChildren());
            }
        }
        return super.getChildren();
    }

    @Override
    void retrieveNodes(int startNode, int numNodes) throws EngineRequestException {
        this.getDebugEngine().processRequest(new EReqExpressionSubTree(this._monitoredExpr.getId(), this.getId(), startNode, startNode + numNodes - 1, this.getEngineSession()));
    }

    void removeNodes(int startNode, int numNodes) throws EngineRequestException {
        this.getDebugEngine().processRequest(new EReqExpressionSubTreeDelete(this._monitoredExpr.getId(), this.getId(), startNode, startNode + numNodes - 1, this.getEngineSession()));
    }

    @Override
    protected boolean update(EStdExprNodeBase newNode) {
        if (newNode.isValueChanged() && !this.isSuppressChangeFlags()) {
            this.setChanged();
        }
        int baseIndex = this._node.getBaseIndex();
        int numChildren = this._node.getNumChildren();
        this._node = newNode;
        if (!this.isSuppressChangeFlags()) {
            ((EStdExprNode)this._node).setIndexRange(baseIndex, numChildren);
        }
        this.setupRepresentations(((EStdExprNode)newNode).getReps());
        return true;
    }

    public void setIndexRange(int base, int number) {
        try {
            this.removeNodes(this._node.getBaseIndex(), this._node.getNumChildren());
            this.removeAllChildren();
            ((EStdExprNode)this._node).setIndexRange(base, number);
            this.retrieveNodes(base, number);
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        this.setPartitionCache(null);
    }

    public int getOrigBaseIndex() {
        return ((EStdExprNode)this._node).getOrigBaseIndex();
    }

    public int getOrigNumChildren() {
        return ((EStdExprNode)this._node).getOrigNumChildren();
    }

    public boolean isUnlimitedRange() {
        return ((EStdExprNode)this._node).isUnlimitedRange();
    }

    public int getValueMaxLength() {
        return ((EStdExprNode)this._node).getValueMaxLength();
    }
}

