/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.IDebugEventProvider;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.ModelEvent;
import com.ibm.debug.pdt.internal.core.model.QueuedEvent;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.LinkedList;

class EventManager {
    private LinkedList<QueuedEvent> fQueuedEvents = new LinkedList();
    private boolean fCurrentlyFiringQueuedEvents = false;

    EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(ModelEvent event, IDebugEventProvider eventProvider) {
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, ".addEvent( " + PDTCoreUtils.getBaseName(event) + " )");
        }
        LinkedList<QueuedEvent> linkedList = this.fQueuedEvents;
        synchronized (linkedList) {
            this.fQueuedEvents.addLast(new QueuedEvent(event, eventProvider));
        }
    }

    void fireEvent(ModelEvent event, IModelEventListener[] listeners) {
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, ".fireEvent( " + PDTCoreUtils.getBaseName(event) + " )");
        }
        IModelEventListener[] iModelEventListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IModelEventListener listener = iModelEventListenerArray[n2];
            if (listener != null) {
                try {
                    event.fire(listener);
                }
                catch (Exception e) {
                    PDTCoreUtils.logError(e);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireAllQueuedEvents() {
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, ".fireAllQueuedEvents()");
        }
        if (this.fCurrentlyFiringQueuedEvents) {
            return true;
        }
        this.fCurrentlyFiringQueuedEvents = true;
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, " begin firing events");
        }
        LinkedList<QueuedEvent> linkedList = this.fQueuedEvents;
        synchronized (linkedList) {
            while (!this.fQueuedEvents.isEmpty()) {
                QueuedEvent queuedEvent = this.fQueuedEvents.removeFirst();
                if (queuedEvent == null) continue;
                this.fireEvent(queuedEvent.getEvent(), queuedEvent.getListeners());
            }
        }
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, " finished firing events");
        }
        this.fCurrentlyFiringQueuedEvents = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeEventQueue() {
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, ".purgeEventQueue()");
        }
        LinkedList<QueuedEvent> linkedList = this.fQueuedEvents;
        synchronized (linkedList) {
            this.fQueuedEvents.clear();
        }
    }
}

