/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntry;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.Map;

public class EntryBreakpoint
extends LocationBreakpoint {
    private static final long serialVersionUID = 20050525L;
    private transient Function fFunction;

    EntryBreakpoint() {
    }

    public EntryBreakpoint(DebuggeeProcess process, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(process, epdcBkp, properties);
    }

    public void modify(Function function, boolean caseSensitive, OptionalBreakpointData optData) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".modify ()");
        }
        if (this.isDeferred() || this.isReadOnly() || !optData.areAllOptionalDataSupported(this.getEngineSession()) || !this.getEngineSession().supportsModifyingBreakpoints()) {
            return;
        }
        short attribute = this.getRequestAttributes();
        attribute = (short)(attribute | optData.getSyncStopControlAttribute());
        attribute = caseSensitive ? (short)(attribute | 0x2000) : (short)(attribute & 0xFFFFDFFF);
        EEveryClause clause = optData.getEEveryClause();
        EStdView epdcContext = function.getEStdView();
        EStdExpression2 conditionalExpr = optData.getEStdExpression2(epdcContext, this.getEngineSession());
        EReqBreakpointEntry request = new EReqBreakpointEntry(attribute, clause, null, null, null, null, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), function.getId(), optData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void modifyDeferred(String entryName, String moduleName, String partName, boolean caseSensitive, OptionalBreakpointData optData) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".modify ()");
        }
        if (!(this.isDeferred() && this.getEngineSession().supportsDeferredBreakpoints() && !this.isReadOnly() && optData.areAllOptionalDataSupported(this.getEngineSession()) && this.getEngineSession().supportsModifyingBreakpoints())) {
            return;
        }
        short attribute = this.getRequestAttributes();
        attribute = (short)(attribute | optData.getSyncStopControlAttribute());
        attribute = caseSensitive ? (short)(attribute | 0x2000) : (short)(attribute & 0xFFFFDFFF);
        EEveryClause clause = optData.getEEveryClause();
        EStdExpression2 conditionalExpr = optData.getEStdExpression2(null, this.getEngineSession());
        EReqBreakpointEntry request = new EReqBreakpointEntry(attribute, clause, entryName, moduleName, partName, null, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), 0, optData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        try {
            targetProcess.setDeferredEntryBreakpoint(this.isEnabled(), this.getFunctionName(), this.getModuleName(), this.getPartName(), this.isCaseSensitive(), new OptionalBreakpointData(this), property);
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }

    public boolean isSourceEntryBreakpoint() {
        return this.getModuleName() == null || this.getModuleName().equals("*") || this.getPartName() == null || this.getPartName().equals("*");
    }

    public Function getFunction() {
        if (this.fFunction == null) {
            this.fFunction = this.getProcess().getFunction(this.getEntryID());
        }
        return this.fFunction;
    }

    @Override
    protected void doCleanupDetails() {
    }
}

