/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEnhancedWatchpoint;
import com.ibm.debug.pdt.internal.epdc.EStdEnhancedWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.Map;

public class EnhancedWatchpoint
extends Watchpoint {
    private static final long serialVersionUID = 20090720L;

    EnhancedWatchpoint() {
    }

    public EnhancedWatchpoint(DebuggeeProcess process, ECPBreakpoint breakpointChangeItem, Map<Integer, Object> properties) {
        super(process, breakpointChangeItem, properties);
    }

    @Override
    protected void doCleanupDetails() {
    }

    private final EStdEnhancedWatchBPData getBreakpointData() {
        return (EStdEnhancedWatchBPData)this._epdcBkp.getEventBPData();
    }

    public String getAddrOrExpr() {
        return EStdString.toString(this.getBreakpointData().getAddrOrExpr());
    }

    @Override
    public int getByteCount() {
        return this.getBreakpointData().getByteCount();
    }

    public EStdView getContext() {
        return this.getBreakpointData().getContext();
    }

    public EStdExpression2 getConditionalExpr() {
        return this.getBreakpointData().getConditionalExpr();
    }

    public String getMatchModuleName() {
        return EStdString.toString(this.getBreakpointData().getMatchModuleName());
    }

    public String getMatchPartName() {
        return EStdString.toString(this.getBreakpointData().getMatchPartName());
    }

    public String getRegister() {
        return EStdString.toString(this.getBreakpointData().getRegister());
    }

    public String getMatchContents() {
        return EStdString.toString(this.getBreakpointData().getMatchContents());
    }

    public String getFromAddrRange() {
        return EStdString.toString(this.getBreakpointData().getFromAddrRange());
    }

    public String getToAddrRange() {
        return EStdString.toString(this.getBreakpointData().getToAddrRange());
    }

    public String getAction() {
        return EStdString.toString(this.getBreakpointData().getAction());
    }

    public String getRestoreAddress() {
        return EStdString.toString(this.getBreakpointData().getRestoreAddress());
    }

    public void modify(String addrOrExpr, String register, int byteCount, String matchContents, String matchModuleName, String matchPartName, String fromAddrRange, String toAddrRange, OptionalBreakpointData optData, EStdView esv) throws EngineRequestException {
        if (!this.getEngineSession().supportsModifyingBreakpoints() || this.isReadOnly() || !optData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        EStdView context = esv != null ? esv : EStdView.EMPTY_VIEW;
        EStdEnhancedWatchBPData updateBkpData = new EStdEnhancedWatchBPData(addrOrExpr, byteCount, context, this.getEngineSession());
        updateBkpData.setRestoreAddress(this._epdcBkp.getAddress());
        updateBkpData.setRegister(register);
        updateBkpData.setMatchContents(matchContents);
        updateBkpData.setMatchModuleName(matchModuleName);
        updateBkpData.setMatchPartName(matchPartName);
        updateBkpData.setFromAddrRange(fromAddrRange);
        updateBkpData.setToAddrRange(toAddrRange);
        updateBkpData.setAction(optData.getBreakpointAction());
        if (this.getEngineSession().supportsChgAddrContionalBkp()) {
            updateBkpData.setConditionalExpr(optData.getEStdExpression2(context, this.getEngineSession()));
        }
        EReqBreakpointEnhancedWatchpoint request = new EReqBreakpointEnhancedWatchpoint(this._epdcBkp.getId(), this.getRequestAttributes(), optData.getEEveryClause(), optData.getThreadId(), updateBkpData, this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        if (!targetProcess.getEngineSession().supportsChangeAddrBreakpoints()) {
            return false;
        }
        try {
            targetProcess.setEnhancedWatchpoint(this._epdcBkp.isEnabled(), this.getAddrOrExpr(), this.getRegister(), this.getByteCount(), this.getMatchContents(), this.getMatchModuleName(), this.getMatchPartName(), this.getFromAddrRange(), this.getToAddrRange(), new OptionalBreakpointData(this), property, this.getContext());
        }
        catch (EngineRequestException e) {
            return false;
        }
        return true;
    }
}

