/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EPDCReadThread;
import com.ibm.debug.pdt.internal.core.model.EPDCReplyProcessor;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionTerminatedException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestProgramTerminatedException;
import com.ibm.debug.pdt.internal.core.model.RequestCanceledException;
import com.ibm.debug.pdt.internal.core.model.SemaphoreRequest;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepError;
import com.ibm.debug.pdt.internal.epdc.ERepRequestCancelled;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;

public final class EPDCRequestProcessor {
    private DebugEngine fDebugEngine;
    private EPDC_EngineSession fEngineSession;
    private EPDCReplyProcessor fReplyProcessor;
    private EPDCReadThread fReadThread;
    private Socket fSocket;
    private final Object fGroupIdLock = new Object();
    private SemaphoreRequest fRequestSemaphore = new SemaphoreRequest(this);
    private boolean fSupportsASYNC = false;
    private volatile boolean fAllowProgramRequests = true;
    private Timer fTimer;
    private BufferedOutputStream fBufferedOutputStream;
    private volatile Integer fGroupId = 0;

    public EPDCRequestProcessor(DebugEngine debugEngine) throws IOException {
        this.fDebugEngine = debugEngine;
        this.fEngineSession = this.fDebugEngine.getEngineSession();
        this.fSupportsASYNC = this.fEngineSession.supportsAsync();
        this.fSocket = debugEngine.getConnection();
        this.fBufferedOutputStream = new BufferedOutputStream(this.fSocket.getOutputStream());
        this.fReadThread = new EPDCReadThread(this.fDebugEngine);
        this.fReplyProcessor = new EPDCReplyProcessor(this, this.fReadThread);
        this.fReadThread.start();
        this.fReplyProcessor.start();
        this.fTimer = new Timer(true);
    }

    protected void processImmediateEPDCRequest(EPDC_Request request, int threadID) throws EngineRequestException {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, String.format(".processImmediateEPDCRequest(%s)", EPDC_Base.getClassName(request)));
        }
        this.canProcess(request);
        if (!this.isAcceptingRequests(false)) {
            try {
                if (this.fSupportsASYNC) {
                    this.fReadThread.addRequest(request);
                }
                request.send(this.fBufferedOutputStream);
            }
            catch (Exception excp) {
                throw new EngineConnectionException(excp);
            }
        } else {
            this.processEPDCRequest(request, threadID);
        }
    }

    protected EPDC_Reply processEPDCRequest(EPDC_Request request, int threadID) throws EngineRequestException {
        return this.internalProcessEPDCRequest(request, threadID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EPDC_Reply internalProcessEPDCRequest(EPDC_Request request, int threadID) throws EngineRequestException {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, String.format(".processEPDCRequest(%s %s)", EPDC_Base.getClassName(request), request.isImmediate() ? "<IMMEDIATE>" : "<LONG_RUNNING>"));
        }
        if (PDTCorePlugin.fEPDCRequestOnMainThread) {
            this.logRequestOnUIThread(request);
        }
        request.setThreadID(threadID);
        try {
            try {
                this.fRequestSemaphore.waitIfBusy(request);
                this.canProcess(request);
                this.sendRequest(request);
                EPDC_Request ePDC_Request = request;
                synchronized (ePDC_Request) {
                    while (!request._replyReceived) {
                        if (request.isImmediate() && this.fEngineSession.getConnectionTimeout() > 0) {
                            EPDCTimerTask timerTask = new EPDCTimerTask(request, this.fSocket, this.fReadThread);
                            request.setTimerTask(timerTask);
                            this.fTimer.schedule((TimerTask)timerTask, this.fEngineSession.getConnectionTimeout());
                        }
                        request.wait();
                    }
                }
                if (request.isProgramTerminating()) {
                    this.fAllowProgramRequests = false;
                } else if (request.isProgramStarting()) {
                    this.fAllowProgramRequests = true;
                }
            }
            catch (EngineRequestException ere) {
                throw ere;
            }
            catch (InterruptedException ie) {
                PDTCoreUtils.logString(this, "Wait interrupted but was not expected", 2, ie);
                throw new EngineConnectionException(ie);
            }
        }
        finally {
            this.fRequestSemaphore.release();
        }
        EPDC_Reply reply = this.getProcessedReply(request);
        switch (reply.getReturnCode()) {
            case 0: {
                break;
            }
            case 998: {
                throw new EngineConnectionException();
            }
            case 997: {
                throw new EngineConnectionTerminatedException();
            }
            case 996: {
                throw new RequestCanceledException(reply);
            }
            default: {
                throw new EngineRequestErrorException(reply);
            }
        }
        return reply;
    }

    protected void sendRequest(EPDC_Request request) throws EngineConnectionException {
        this.fReadThread.addRequest(request);
        try {
            request.send(this.fBufferedOutputStream);
        }
        catch (IOException ioe) {
            this.fReadThread.cancelRequest(request);
            throw new EngineConnectionException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EPDC_Reply getProcessedReply(EPDC_Request request) throws EngineRequestException {
        EPDC_Reply reply;
        block11: {
            reply = null;
            try {
                if (Thread.currentThread().equals(this.fReplyProcessor)) {
                    reply = this.fReadThread.getReply(request);
                    this.fReplyProcessor.updateModel(reply, true);
                    if (reply instanceof ERepError || reply == null || reply.getReplyCode() == 42) {
                        this.fReadThread.queueReplyForProcessing(null);
                        this.fAllowProgramRequests = false;
                        if (reply == null) {
                            throw new EngineRequestProgramTerminatedException();
                        }
                    }
                    reply._processed = true;
                    break block11;
                }
                reply = request.getReply();
                if (reply.isProgramTerminating()) {
                    this.fAllowProgramRequests = false;
                }
                EPDC_Reply ePDC_Reply = reply;
                synchronized (ePDC_Reply) {
                    while (!reply._processed) {
                        reply.wait();
                    }
                }
            }
            catch (EngineRequestException ere) {
                throw ere;
            }
            catch (Exception e) {
                throw new EngineConnectionException(e);
            }
        }
        return reply;
    }

    public final boolean isAcceptingRequests() {
        return this.isAcceptingRequests(PDTCorePlugin.fLogEPDCBusy);
    }

    final synchronized boolean isAcceptingRequests(boolean log) {
        if (this.fReadThread == null || this.fReplyProcessor == null) {
            return false;
        }
        EPDC_Request request = this.fReadThread.getCurrentRequest();
        if (request != null && !request.isImmediate()) {
            if (log) {
                PDTCoreUtils.logError(new Exception(" Not accepting requests"));
            }
            return false;
        }
        return true;
    }

    private void canProcess(EPDC_Request request) throws EngineRequestException {
        boolean thisRequestAllowed;
        boolean requestsPossible;
        boolean bl = requestsPossible = this.fDebugEngine.isConnected() && this.fReadThread.isAlive() && this.fReplyProcessor.isAlive();
        if (!requestsPossible) {
            throw new EngineConnectionException();
        }
        boolean bl2 = thisRequestAllowed = this.fAllowProgramRequests || request.isValidAfterProgramTerminate();
        if (!thisRequestAllowed) {
            throw new EngineRequestProgramTerminatedException();
        }
    }

    public void setProgramTerminating() {
        this.fAllowProgramRequests = false;
        this.fReadThread.cancelAllPendingRequsts();
    }

    public final boolean isIdle() {
        return this.isIdle(PDTCorePlugin.fLogEPDCBusy);
    }

    private final boolean isIdle(boolean log) {
        if (log) {
            PDTCoreUtils.logError(new Exception(" Not accepting ASYNC requests"));
        }
        return !this.fRequestSemaphore.isBusy();
    }

    protected DebugEngine getDebugEngine() {
        return this.fDebugEngine;
    }

    public void setConnectionTerminated() {
        if (this.fReadThread != null) {
            this.fReadThread.setConnectionTerminated();
        }
    }

    protected void cleanup() {
        if (this.fTimer != null) {
            this.fTimer.cancel();
        }
        if (this.fReadThread != null) {
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void logRequestOnUIThread(EPDC_Request request) {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("main")) {
            String logString = "Running on main thread -> " + request.toString();
            Exception exception = new Exception(logString);
            exception.setStackTrace(thread.getStackTrace());
            PDTCoreUtils.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startGroupRequest(int groupId) {
        Object object = this.fGroupIdLock;
        synchronized (object) {
            block4: {
                if (this.fGroupId == 0) break block4;
                PDTCoreUtils.logString(this, "Start group request (" + groupId + ") rejected because of pending group (" + String.valueOf(this.fGroupId) + ")");
                return false;
            }
            this.fGroupId = groupId;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endGroupRequest(int groupId) {
        Object object = this.fGroupIdLock;
        synchronized (object) {
            if (groupId == this.fGroupId) {
                this.fGroupId = 0;
            } else {
                PDTCoreUtils.logString(this, "End group request (" + groupId + ") doesn't match pending group id (" + String.valueOf(this.fGroupId) + ")");
            }
        }
    }

    int getGroupId() {
        return this.fGroupId;
    }

    class EPDCTimerTask
    extends TimerTask {
        private Socket fSocket;
        private EPDC_Request fRequest;
        private EPDCReadThread fReadThread;
        private boolean fRequestOnUIThread;

        EPDCTimerTask(EPDC_Request request, Socket socket, EPDCReadThread readThread) {
            this.fSocket = socket;
            this.fRequest = request;
            this.fReadThread = readThread;
            Thread thread = Thread.currentThread();
            this.fRequestOnUIThread = thread.getName().equals("main");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.fRequest._replyReceived) {
                return;
            }
            if (!this.fRequestOnUIThread && EPDCRequestProcessor.this.fDebugEngine.continueWaiting()) {
                EPDC_Request ePDC_Request = this.fRequest;
                synchronized (ePDC_Request) {
                    this.fRequest.notify();
                }
            }
            if (this.fRequest._replyReceived) {
                return;
            }
            if (this.fRequestOnUIThread && EPDCRequestProcessor.this.fDebugEngine.getEngineSession().supportsAsync() && this.fRequest.isCancelOnTimeout()) {
                EPDC_Request ePDC_Request = this.fRequest;
                synchronized (ePDC_Request) {
                    PDTCoreUtils.logString(this, "Canceling, timeout reached for request: " + this.fRequest.getDescription());
                    this.fRequest.setReply(new ERepRequestCancelled(EPDCRequestProcessor.this.fDebugEngine.getEngineSession()));
                    this.fRequest._replyReceived = true;
                    this.fRequest.notify();
                }
            }
            try {
                if (this.fRequestOnUIThread) {
                    PDTCoreUtils.logString(this, "Debug session terminated due to request timeout for request: " + this.fRequest.getDescription());
                }
                this.fReadThread.setConnectionTerminated();
                this.fSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

